/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.AbstractValidator;

@Serialized
public class ExpressionValidator
extends AbstractValidator {
    private String regexp;
    private transient Matcher matcher;
    private String key_;

    public ExpressionValidator() {
    }

    public ExpressionValidator(String regex) {
        this(regex, "ExpressionValidator.msg.value-invalid");
    }

    public ExpressionValidator(String regex, String key) {
        this.regexp = regex;
        this.key_ = key;
    }

    private Matcher getMatcherFor(String input) {
        if (this.matcher == null) {
            this.matcher = Pattern.compile(this.regexp).matcher(input);
        } else {
            this.matcher.reset(input);
        }
        return this.matcher;
    }

    @Override
    protected String getMessageLocalizationKey() {
        return this.key_;
    }

    @Override
    protected boolean isValid(String value, UIFormInput uiInput) {
        return this.getMatcherFor(value).matches();
    }

    @Override
    protected Object[] getMessageArgs(String value, UIFormInput uiInput) throws Exception {
        return new Object[]{this.getLabelFor(uiInput), this.matcher.pattern().toString()};
    }
}

