/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.gamification.github.services.impl;

import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.model.filter.EventFilter;
import io.meeds.gamification.service.ConnectorService;
import io.meeds.gamification.service.EventService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.gamification.github.model.Event;
import org.exoplatform.gamification.github.plugin.GithubTriggerPlugin;
import org.exoplatform.gamification.github.services.GithubTriggerService;
import org.exoplatform.gamification.github.services.WebhookService;
import org.exoplatform.gamification.github.services.impl.GithubTriggerServiceImpl$AjcClosure1;
import org.exoplatform.gamification.github.utils.Utils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.picocontainer.Startable;

public class GithubTriggerServiceImpl
implements GithubTriggerService,
Startable {
    private static final Log LOG;
    private final Map<String, GithubTriggerPlugin> triggerPlugins = new HashMap<String, GithubTriggerPlugin>();
    private final ConnectorService connectorService;
    private final EventService eventService;
    private WebhookService webhookService;
    private final IdentityManager identityManager;
    private final ListenerService listenerService;
    private ExecutorService executorService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public GithubTriggerServiceImpl(ListenerService listenerService, ConnectorService connectorService, IdentityManager identityManager, EventService eventService) {
        this.listenerService = listenerService;
        this.connectorService = connectorService;
        this.identityManager = identityManager;
        this.eventService = eventService;
    }

    public void start() {
        QueuedThreadPool threadFactory = new QueuedThreadPool(5, 1, 1);
        threadFactory.setName("Gamification - Github connector");
        this.executorService = Executors.newCachedThreadPool((ThreadFactory)threadFactory);
    }

    public void stop() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    @Override
    public void addPlugin(GithubTriggerPlugin githubTriggerPlugin) {
        this.triggerPlugins.put(githubTriggerPlugin.getName(), githubTriggerPlugin);
    }

    @Override
    public void removePlugin(String name) {
        this.triggerPlugins.remove(name);
    }

    @Override
    public void handleTriggerAsync(String trigger, String signature, String payload) {
        this.executorService.execute(() -> this.handleTriggerAsyncInternal(trigger, signature, payload));
    }

    @ExoTransactional
    public void handleTriggerAsyncInternal(String trigger, String signature, String payload) {
        String string = trigger;
        String string2 = signature;
        String string3 = payload;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, joinPoint};
        GithubTriggerServiceImpl$AjcClosure1 githubTriggerServiceImpl$AjcClosure1 = new GithubTriggerServiceImpl$AjcClosure1(objectArray2);
        ExoTransactionalAspect.aspectOf().around(githubTriggerServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    public void handleTrigger(String trigger, String signature, String payload) {
        if (!this.getWebhookService().verifyWebhookSecret(payload, signature) || !this.getWebhookService().isWebHookRepositoryEnabled(payload)) {
            return;
        }
        Map<String, Object> payloadMap = Utils.fromJsonStringToMap(payload);
        String organizationId = Utils.extractSubItem(payloadMap, "organization", "id");
        List<Event> events = new ArrayList<Event>();
        GithubTriggerPlugin triggerPlugin = this.getGithubTriggerPlugin(trigger);
        if (triggerPlugin != null) {
            events = triggerPlugin.getEvents(payloadMap);
        }
        this.processEvents(events, trigger, organizationId);
    }

    private void processEvents(List<Event> events, String trigger, String organizationId) {
        events.stream().filter(event -> this.isEventEnabled(event.getName(), trigger, organizationId)).forEach(this::processEvent);
    }

    private boolean isEventEnabled(String eventName, String trigger, String organizationId) {
        EventDTO eventDTO = this.eventService.getEventByTitleAndTrigger(eventName, trigger);
        if (eventDTO != null) {
            return this.isOrganizationEventEnabled(eventDTO, organizationId);
        }
        return true;
    }

    private boolean isOrganizationEventEnabled(EventDTO eventDTO, String organizationId) {
        String organizationPropertyKey = organizationId + ".enabled";
        Map properties = eventDTO.getProperties();
        if (properties != null && !properties.isEmpty()) {
            return Boolean.parseBoolean((String)properties.get(organizationPropertyKey));
        }
        return true;
    }

    private void processEvent(Event event) {
        Identity socialIdentity;
        String receiverId = this.connectorService.getAssociatedUsername("github", event.getReceiver());
        String senderId = event.getSender() != null && !StringUtils.equals((CharSequence)event.getReceiver(), (CharSequence)event.getSender()) ? this.connectorService.getAssociatedUsername("github", event.getSender()) : receiverId;
        if (StringUtils.isNotBlank((CharSequence)senderId) && (socialIdentity = this.identityManager.getOrCreateUserIdentity(senderId)) != null) {
            this.broadcastGithubEvent(event.getName(), senderId, receiverId, event.getObjectId(), event.getObjectType());
        }
    }

    @Override
    public String[] getTriggers() {
        return (String[])this.triggerPlugins.values().stream().map(BaseComponentPlugin::getName).toArray(String[]::new);
    }

    private void broadcastGithubEvent(String ruleTitle, String senderId, String receiverId, String objectId, String objectType) {
        try {
            HashMap<String, String> gam = new HashMap<String, String>();
            gam.put("senderId", senderId);
            gam.put("receiverId", receiverId);
            gam.put("objectId", objectId);
            gam.put("objectType", objectType);
            EventDTO eventDTO = this.eventService.getEventByTypeAndTitle("github", ruleTitle);
            if (eventDTO != null) {
                gam.put("ruleTitle", eventDTO.getTitle());
                this.listenerService.broadcast("github.action.event", gam, (Object)"");
            } else {
                List events = this.eventService.getEvents(new EventFilter("github", null), 0, 0);
                List<EventDTO> eventsToCancel = events.stream().filter(event -> event.getCancellerEvents() != null && event.getCancellerEvents().contains(ruleTitle)).toList();
                if (CollectionUtils.isNotEmpty(eventsToCancel)) {
                    for (EventDTO eventToCancel : eventsToCancel) {
                        gam.put("ruleTitle", eventToCancel.getTitle());
                        this.listenerService.broadcast("github.cancel.action.event", gam, (Object)"");
                    }
                }
            }
            LOG.info("Github action {} broadcasted for user {}", new Object[]{ruleTitle, senderId});
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot broadcast github event", (Throwable)e);
        }
    }

    private GithubTriggerPlugin getGithubTriggerPlugin(String trigger) {
        return this.triggerPlugins.get(trigger);
    }

    private WebhookService getWebhookService() {
        if (this.webhookService == null) {
            this.webhookService = (WebhookService)ExoContainerContext.getService(WebhookService.class);
        }
        return this.webhookService;
    }

    static {
        GithubTriggerServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(GithubTriggerServiceImpl.class);
    }

    static /* synthetic */ void handleTriggerAsyncInternal_aroundBody0(GithubTriggerServiceImpl ajc$this, String trigger, String signature, String payload, JoinPoint joinPoint) {
        ajc$this.handleTrigger(trigger, signature, payload);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GithubTriggerServiceImpl.java", GithubTriggerServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "handleTriggerAsyncInternal", "org.exoplatform.gamification.github.services.impl.GithubTriggerServiceImpl", "java.lang.String:java.lang.String:java.lang.String", "trigger:signature:payload", "", "void"), 105);
    }
}

