/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletContext;
import org.exoplatform.portal.resource.Resource;
import org.exoplatform.portal.resource.ResourceResolver;
import org.exoplatform.portal.resource.SimpleResourceContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MainResourceResolver
implements ResourceResolver {
    final Map<String, SimpleResourceContext> contexts;
    final CopyOnWriteArrayList<ResourceResolver> resolvers;
    private final Log log = ExoLogger.getLogger(MainResourceResolver.class);

    public MainResourceResolver() {
        this.contexts = new HashMap<String, SimpleResourceContext>();
        this.resolvers = new CopyOnWriteArrayList();
    }

    SimpleResourceContext registerContext(ServletContext servletContext) {
        String key = "/" + servletContext.getServletContextName();
        SimpleResourceContext ctx = this.contexts.get(key);
        if (ctx == null) {
            ctx = new SimpleResourceContext(key, servletContext);
            this.contexts.put(ctx.getContextPath(), ctx);
        }
        return ctx;
    }

    public void removeServletContext(ServletContext servletContext) {
        String key = "/" + servletContext.getServletContextName();
        SimpleResourceContext ctx = this.contexts.get(key);
        if (ctx == null) {
            this.log.warn((Object)"Cannot find servlet context module");
            return;
        }
        this.contexts.remove(ctx.getContextPath());
    }

    @Override
    public Resource resolve(String path) {
        if (path == null) {
            throw new NullPointerException("No null path is accepted");
        }
        for (ResourceResolver resolver : this.resolvers) {
            Resource res = resolver.resolve(path);
            if (res == null) continue;
            return res;
        }
        int i1 = path.indexOf("/", 2);
        if (i1 == -1) {
            throw new AssertionError();
        }
        String targetedContextPath = path.substring(0, i1);
        SimpleResourceContext context = this.contexts.get(targetedContextPath);
        if (context == null) {
            this.log.warn((Object)("Could not resolve " + targetedContextPath + " resource for path " + path));
            return null;
        }
        return context.getResource(path.substring(i1));
    }
}

