/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.layoutmanagement.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.layoutmanagement.rest.EntityBuilder;
import org.exoplatform.layoutmanagement.rest.model.NodeLabelRestEntity;
import org.exoplatform.layoutmanagement.utils.SiteNavigationUtils;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.service.DescriptionService;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.utils.MOPUtils;
import org.exoplatform.portal.page.PageTemplateService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.gatein.api.Portal;
import org.gatein.api.page.PageQuery;
import org.gatein.api.site.SiteType;
import org.picocontainer.Startable;

@Path(value="v1/siteNavigation")
@Tag(name="v1/siteNavigation", description="Managing site navigation")
public class SiteNavigationRestService
implements ResourceContainer,
Startable {
    private static final Log LOG = ExoLogger.getLogger(SiteNavigationRestService.class);
    private final NavigationService navigationService;
    private ScheduledExecutorService scheduledExecutor;
    private final PortalContainer container;
    private LayoutService layoutService;
    private PageTemplateService pageTemplateService;
    private Portal portal;
    private UserPortalConfigService userPortalConfigService;
    private DescriptionService descriptionService;
    private final Map<Long, String> navigationNodeToDeleteQueue = new HashMap<Long, String>();

    public SiteNavigationRestService(NavigationService navigationService, PortalContainer container, LayoutService layoutService, PageTemplateService pageTemplateService, Portal portal, UserPortalConfigService userPortalConfigService, DescriptionService descriptionService) {
        this.navigationService = navigationService;
        this.container = container;
        this.layoutService = layoutService;
        this.pageTemplateService = pageTemplateService;
        this.portal = portal;
        this.userPortalConfigService = userPortalConfigService;
        this.descriptionService = descriptionService;
    }

    @POST
    @Path(value="node")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Create a navigation node", method="POST", description="This creates the given navigation node")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="navigation node created"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Node not found"), @ApiResponse(responseCode="401", description="User not authorized to create the navigation node"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createNode(@Parameter(description="navigation node id") @QueryParam(value="parentNodeId") Long parentNodeId, @Parameter(description="previous node id") @QueryParam(value="previousNodeId") Long previousNodeId, @Parameter(description="node label") @QueryParam(value="nodeLabel") String nodeLabel, @Parameter(description="node id") @QueryParam(value="nodeId") String nodeId, @Parameter(description="isVisible") @QueryParam(value="isVisible") boolean isVisible, @Parameter(description="isScheduled") @QueryParam(value="isScheduled") boolean isScheduled, @Parameter(description="startScheduleDate") @QueryParam(value="startScheduleDate") Long startScheduleDate, @Parameter(description="endScheduleDate") @QueryParam(value="endScheduleDate") Long endScheduleDate, @Parameter(description="page reference") @QueryParam(value="pageRef") String pageRef, @Parameter(description="node target") @QueryParam(value="target") String target, @RequestBody(description="node labels", required=true) NodeLabelRestEntity nodeLabelRestEntity, @Parameter(description="isPasteMode") @QueryParam(value="isPasteMode") boolean isPasteMode, @Parameter(description="node icon") @QueryParam(value="icon") String icon) {
        if (parentNodeId == null || StringUtils.isBlank((String)nodeLabel) || StringUtils.isBlank((String)nodeId) || nodeLabelRestEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"params are mandatory").build();
        }
        try {
            NodeState nodeState;
            NodeData parentNodeData = this.navigationService.getNodeById(parentNodeId);
            if (parentNodeData == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Node data with parent node id is not found").build();
            }
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            if (!SiteNavigationUtils.canEditNavigation(currentIdentity, parentNodeData)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            HashMap nodeLabels = new HashMap();
            if (nodeLabelRestEntity.getLabels() != null) {
                nodeLabel = null;
                nodeLabelRestEntity.getLabels().entrySet().forEach(label -> {
                    State state = new State((String)label.getValue(), null);
                    nodeLabels.put(new Locale((String)label.getKey()), state);
                });
            }
            long now = System.currentTimeMillis();
            if (isVisible && isScheduled && startScheduleDate != null && endScheduleDate != null) {
                if (startScheduleDate > endScheduleDate) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"end schedule date must be after start schedule date").build();
                }
                if (now > startScheduleDate && !isPasteMode) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"start schedule date must be after current date").build();
                }
                nodeState = new NodeState(nodeLabel, icon, startScheduleDate.longValue(), endScheduleDate.longValue(), Visibility.TEMPORAL, StringUtils.isBlank((String)pageRef) ? null : PageKey.parse((String)pageRef), null, target, System.currentTimeMillis());
            } else {
                nodeState = new NodeState(nodeLabel, icon, -1L, -1L, isVisible ? Visibility.DISPLAYED : Visibility.HIDDEN, StringUtils.isBlank((String)pageRef) ? null : PageKey.parse((String)pageRef), null, target, System.currentTimeMillis());
            }
            NodeData[] nodeData = this.navigationService.createNode(parentNodeId, previousNodeId, nodeId, nodeState);
            this.descriptionService.setDescriptions(nodeData[1].getId(), nodeLabels);
            return Response.ok().entity((Object)nodeData).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when creating a new navigation node", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="node")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Update a navigation node", method="PUT", description="This updates the given navigation node")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="navigation node updated"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Node not found"), @ApiResponse(responseCode="401", description="User not authorized to update the navigation node"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateNode(@Parameter(description="navigation node id") @QueryParam(value="nodeId") Long nodeId, @Parameter(description="node label") @QueryParam(value="nodeLabel") String nodeLabel, @Parameter(description="pageRef") @QueryParam(value="pageRef") String pageRef, @Parameter(description="node target") @QueryParam(value="target") String target, @Parameter(description="isVisible") @QueryParam(value="isVisible") boolean isVisible, @Parameter(description="isScheduled") @QueryParam(value="isScheduled") boolean isScheduled, @Parameter(description="startScheduleDate") @QueryParam(value="startScheduleDate") Long startScheduleDate, @Parameter(description="endScheduleDate") @QueryParam(value="endScheduleDate") Long endScheduleDate, @RequestBody(description="node labels", required=true) NodeLabelRestEntity nodeLabelRestEntity, @Parameter(description="node icon") @QueryParam(value="icon") String icon) {
        if (nodeId == null || StringUtils.isBlank((String)nodeLabel) || nodeLabelRestEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"params are mandatory").build();
        }
        try {
            NodeState nodeState;
            Identity currentIdentity;
            NodeData nodeData = this.navigationService.getNodeById(nodeId);
            if (nodeData == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Node data with node id is not found").build();
            }
            PageKey pageKey = null;
            if (!StringUtils.isBlank((String)pageRef)) {
                PageContext pageContext = this.layoutService.getPageContext(PageKey.parse((String)pageRef));
                if (pageContext == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Page context with page reference is not found").build();
                }
                pageKey = pageContext.getKey();
            }
            if (!SiteNavigationUtils.canEditNavigation(currentIdentity = ConversationState.getCurrent().getIdentity(), nodeData)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            HashMap nodeLabels = new HashMap();
            if (nodeLabelRestEntity.getLabels() != null) {
                nodeLabel = null;
                nodeLabelRestEntity.getLabels().entrySet().forEach(label -> {
                    State state = new State((String)label.getValue(), null);
                    nodeLabels.put(new Locale((String)label.getKey()), state);
                });
            }
            long now = System.currentTimeMillis();
            if (isVisible && isScheduled && startScheduleDate != null && endScheduleDate != null) {
                if (startScheduleDate > endScheduleDate) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"end schedule date must be after start schedule date").build();
                }
                if (now > startScheduleDate) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"start schedule date must be after current date").build();
                }
                nodeState = new NodeState(nodeLabel, icon, startScheduleDate.longValue(), endScheduleDate.longValue(), Visibility.TEMPORAL, pageKey, null, target, System.currentTimeMillis());
            } else {
                nodeState = new NodeState(nodeLabel, icon, -1L, -1L, isVisible ? Visibility.DISPLAYED : Visibility.HIDDEN, pageKey, null, target, System.currentTimeMillis());
            }
            this.descriptionService.setDescriptions(String.valueOf(nodeId), nodeLabels);
            this.navigationService.updateNode(nodeId, nodeState);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when updating a navigation node", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="node/{nodeId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Delete a navigation node ", method="DELETE", description="This deletes the given navigation node")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="navigation node deleted"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Node not found"), @ApiResponse(responseCode="401", description="User not authorized to delete the navigation node"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteNode(@Context HttpServletRequest request, @Parameter(description="Node id", required=true) @PathParam(value="nodeId") Long nodeId, @Parameter(description="Time to effectively delete navigation node", required=false) @QueryParam(value="delay") long delay) {
        try {
            if (nodeId == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Node id is mandatory").build();
            }
            NodeData nodeData = this.navigationService.getNodeById(nodeId);
            if (nodeData == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Node data with node id is not found").build();
            }
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            if (!SiteNavigationUtils.canEditNavigation(currentIdentity, nodeData)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (delay > 0L) {
                this.navigationNodeToDeleteQueue.put(nodeId, currentIdentity.getUserId());
                this.scheduledExecutor.schedule(() -> {
                    if (this.navigationNodeToDeleteQueue.containsKey(nodeId)) {
                        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
                        RequestLifeCycle.begin((ExoContainer)this.container);
                        try {
                            this.navigationNodeToDeleteQueue.remove(nodeId);
                            this.navigationService.deleteNode(nodeId);
                        }
                        catch (Exception e) {
                            LOG.warn("Error when deleting the navigation node with id {}", new Object[]{nodeId, e});
                        }
                        finally {
                            RequestLifeCycle.end();
                        }
                    }
                }, delay, TimeUnit.SECONDS);
            } else {
                this.navigationNodeToDeleteQueue.remove(nodeId);
                this.navigationService.deleteNode(nodeId);
            }
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("Error when deleting the navigation node with id {}", new Object[]{nodeId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="node/{nodeId}/undoDelete")
    @POST
    @RolesAllowed(value={"users"})
    @Operation(summary="Undo delete a navigation node if not yet effectively deleted", method="POST", description="This undo deletes the given navigation node if not yet effectively deleted")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Node not found"), @ApiResponse(responseCode="403", description="Forbidden operation"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response undoDeleteNode(@Context HttpServletRequest request, @Parameter(description="Node identifier", required=true) @PathParam(value="nodeId") Long nodeId) {
        try {
            if (nodeId == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Node id is mandatory").build();
            }
            NodeData nodeData = this.navigationService.getNodeById(nodeId);
            if (nodeData == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Node data with node id is not found").build();
            }
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            if (!SiteNavigationUtils.canEditNavigation(currentIdentity, nodeData)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (this.navigationNodeToDeleteQueue.containsKey(nodeId)) {
                String authenticatedUser = request.getRemoteUser();
                String originalModifierUser = this.navigationNodeToDeleteQueue.get(nodeId);
                if (!originalModifierUser.equals(authenticatedUser)) {
                    LOG.warn("User {} attempts to cancel deletion of navigation node deleted by user {}", new Object[]{authenticatedUser, originalModifierUser});
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                }
                this.navigationNodeToDeleteQueue.remove(nodeId);
                return Response.noContent().build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Node with id {} was already deleted or isn't planned to be deleted" + nodeId)).build();
        }
        catch (Exception e) {
            LOG.error("Error when undo deleting the navigation node with id {}", new Object[]{nodeId, e});
            return Response.serverError().build();
        }
    }

    @Path(value="node/{nodeId}/labels")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieve node labels", method="GET", description="This retrieves node labels")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getNodeLabels(@Context HttpServletRequest request, @Parameter(description="Node id", required=true) @PathParam(value="nodeId") Long nodeId) {
        try {
            Map nodeLabels = this.descriptionService.getDescriptions(String.valueOf(nodeId));
            NodeLabelRestEntity nodeLabelRestEntity = EntityBuilder.toNodeLabelRestEntity(nodeLabels);
            return Response.ok().entity((Object)nodeLabelRestEntity).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when retrieving node labels", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @PATCH
    @Path(value="/node/move")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Move a navigation node", method="PATCH", description="This moves the given navigation node")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="User not authorized to move the navigation node"), @ApiResponse(responseCode="404", description="Node not found")})
    public Response moveNode(@Parameter(description="node id") @QueryParam(value="nodeId") Long nodeId, @Parameter(description="destination parent id") @QueryParam(value="destinationParentId") Long destinationParentId, @Parameter(description="previous id") @QueryParam(value="previousNodeId") Long previousNodeId) {
        try {
            if (nodeId == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Node id is mandatory").build();
            }
            NodeData nodeData = this.navigationService.getNodeById(nodeId);
            if (nodeData == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Node data with node id is not found").build();
            }
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            if (!SiteNavigationUtils.canEditNavigation(currentIdentity, nodeData)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            long parentId = Long.parseLong(nodeData.getParentId());
            if (destinationParentId == null) {
                destinationParentId = parentId;
            }
            this.navigationService.moveNode(nodeId, Long.valueOf(parentId), destinationParentId, previousNodeId);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("Error when moving the navigation node with id {}", new Object[]{nodeId, e});
            return Response.serverError().build();
        }
    }

    @Path(value="/page/permissions")
    @PATCH
    @RolesAllowed(value={"users"})
    @Operation(summary="Update a page access and edit permission", method="PATCH", description="This updates the given page access and edit permission")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Page permissions updated"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Page not found"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updatePagePermissions(@Context HttpServletRequest request, @Parameter(description="Page reference", required=true) @QueryParam(value="pageRef") String pageRef, @Parameter(description="Page new edit permission", required=true) @QueryParam(value="editPermission") String editPermission, @Parameter(description="Page new access permissions", required=true) @QueryParam(value="accessPermissions") String accessPermissions) {
        try {
            if (StringUtils.isBlank((String)pageRef) || StringUtils.isBlank((String)editPermission) || StringUtils.isBlank((String)accessPermissions)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"params are mandatory").build();
            }
            PageContext pageContext = this.layoutService.getPageContext(PageKey.parse((String)pageRef));
            if (pageContext == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!SiteNavigationUtils.canEditPage(pageContext)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            PageState pageState = pageContext.getState();
            List accessPermissionsList = List.of(accessPermissions.split(",")).stream().distinct().toList();
            pageContext.setState(new PageState(pageState.getDisplayName(), pageState.getDescription(), pageState.getShowMaxWindow(), pageState.getFactoryId(), accessPermissionsList, editPermission, pageState.getMoveAppsPermissions(), pageState.getMoveContainersPermissions(), pageState.getType(), pageState.getLink()));
            this.layoutService.save(pageContext);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("Error when updating page permissions with reference {}", new Object[]{pageRef, e});
            return Response.serverError().build();
        }
    }

    @Path(value="/page/templates")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieve page templates", method="GET", description="This retrieves page templates")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getPageTemplates(@Context HttpServletRequest httpRequest) {
        try {
            Locale locale = httpRequest.getLocale();
            List pageTemplates = this.pageTemplateService.getPageTemplates();
            return Response.ok().entity(EntityBuilder.toPageTemplateRestEntities(pageTemplates, locale)).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when retrieving page templates", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @Path(value="/pages")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieve pages", method="GET", description="This retrieves pages")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getPages(@Context HttpServletRequest httpRequest, @Parameter(description="Portal site type, possible values: PORTAL, GROUP or USER") @QueryParam(value="siteType") String siteType, @Parameter(description="Portal site name") @QueryParam(value="siteName") String siteName, @Parameter(description="page display name") @QueryParam(value="pageDisplayName") String pageDisplayName) {
        try {
            SiteType selectedSiteType = null;
            if (!StringUtils.isBlank((String)siteType)) {
                selectedSiteType = MOPUtils.convertSiteType((org.exoplatform.portal.mop.SiteType)org.exoplatform.portal.mop.SiteType.valueOf((String)siteType.toUpperCase()));
            }
            PageQuery pageQuery = new PageQuery.Builder().withSiteType(selectedSiteType).withSiteName(siteName).withDisplayName(pageDisplayName).build();
            List pages = this.portal.findPages(pageQuery);
            return Response.ok().entity((Object)pages).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when retrieving pages", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @Path(value="/page")
    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Create a page", method="POST", description="This creates the page")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="page created"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createPage(@Parameter(description="page name", required=true) @QueryParam(value="pageName") String pageName, @Parameter(description="page name", required=true) @QueryParam(value="pageTitle") String pageTitle, @Parameter(description="page site type", required=true) @QueryParam(value="pageSiteType") String pageSiteType, @Parameter(description="page site name", required=true) @QueryParam(value="pageSiteName") String pageSiteName, @Parameter(description="Page Type : GROUP, PAGE OR LINK", required=true) @QueryParam(value="pageType") String pageType, @Parameter(description="link") @QueryParam(value="link") String link, @Parameter(description="page template : blank , normal, analytics ...") @QueryParam(value="pageTemplate") String pageTemplate) {
        if (StringUtils.isBlank((String)pageName) || StringUtils.isBlank((String)pageTitle) || StringUtils.isBlank((String)pageType) || StringUtils.isBlank((String)pageSiteName) || StringUtils.isBlank((String)pageSiteType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"params are mandatory").build();
        }
        try {
            Page page;
            pageName = (String)pageName + "_" + UUID.randomUUID();
            if (PageType.PAGE.equals((Object)PageType.valueOf((String)pageType))) {
                if (StringUtils.isBlank((String)pageTemplate)) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"pageTemplate param is mandatory for PAGE pageType").build();
                }
                page = this.userPortalConfigService.createPageTemplate(pageTemplate, pageSiteType, pageSiteName);
            } else {
                page = new Page(pageSiteType, pageSiteName, (String)pageName);
            }
            page.setName((String)pageName);
            page.setTitle(pageTitle);
            page.setType(pageType);
            page.setLink(PageType.LINK.equals((Object)PageType.valueOf((String)pageType)) ? link : null);
            this.setDefaultPermission(page, new SiteKey(pageSiteType, pageSiteName));
            PageState pageState = Utils.toPageState((Page)page);
            this.layoutService.save(new PageContext(page.getPageKey(), pageState), page);
            PageContext createdPage = this.layoutService.getPageContext(page.getPageKey());
            return Response.ok().entity((Object)createdPage).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when creating a new page", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/page")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieve page by reference", method="GET", description="This retrieves page by reference")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getPageByRef(@Context HttpServletRequest httpRequest, @Parameter(description="page reference", required=true) @QueryParam(value="pageRef") String pageRef) {
        try {
            if (StringUtils.isBlank((String)pageRef)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"params are mandatory").build();
            }
            return Response.ok().entity((Object)this.layoutService.getPageContext(PageKey.parse((String)pageRef))).build();
        }
        catch (Exception e) {
            LOG.error("Error when retrieving page with reference {} ", new Object[]{pageRef, e});
            return Response.serverError().build();
        }
    }

    @Path(value="/page/link")
    @PATCH
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Update page link", method="GET", description="This updates page link")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updatePageLink(@Context HttpServletRequest httpRequest, @Parameter(description="page display name", required=true) @QueryParam(value="pageRef") String pageRef, @Parameter(description="page new Link") @QueryParam(value="link") String link) {
        try {
            if (StringUtils.isBlank((String)pageRef) || StringUtils.isBlank((String)link)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"params are mandatory").build();
            }
            PageContext pageContext = this.layoutService.getPageContext(PageKey.parse((String)pageRef));
            PageState pageState = pageContext.getState();
            pageContext.setState(new PageState(pageState.getDisplayName(), pageState.getDescription(), pageState.getShowMaxWindow(), pageState.getFactoryId(), pageState.getAccessPermissions(), pageState.getEditPermission(), pageState.getMoveAppsPermissions(), pageState.getMoveContainersPermissions(), pageState.getType(), link));
            this.layoutService.save(pageContext);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("Error when updating  page link with reference {} ", new Object[]{pageRef, e});
            return Response.serverError().build();
        }
    }

    private void setDefaultPermission(Page page, SiteKey siteKey) {
        if (org.exoplatform.portal.mop.SiteType.PORTAL.equals((Object)siteKey.getType())) {
            page.setAccessPermissions(new String[]{"Everyone"});
            page.setEditPermission("*:/platform/administrators");
        } else if (org.exoplatform.portal.mop.SiteType.GROUP.equals((Object)siteKey.getType())) {
            Object siteName = siteKey.getName().startsWith("/") ? siteKey.getName() : "/" + siteKey.getName();
            page.setAccessPermissions(new String[]{"*:" + (String)siteName});
            page.setEditPermission("manager:" + (String)siteName);
        }
    }

    public void start() {
        this.scheduledExecutor = Executors.newScheduledThreadPool(1);
    }

    public void stop() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
        }
    }
}

