/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.deployment.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class XSD {
    private static final Log log = ExoLogger.getLogger(XSD.class);
    private static final Map<String, String> a = new HashMap<String, String>();
    public static final XSD PORTLET_1_0;
    public static final XSD PORTLET_2_0;
    private final FutureTask<Schema> schema;

    public XSD(final URL url) {
        this.schema = new FutureTask<Schema>(new Callable<Schema>(){

            @Override
            public Schema call() throws Exception {
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                factory.setResourceResolver(new LSResourceResolver(){

                    @Override
                    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                        String resolvedName = a.get(systemId);
                        if (resolvedName != null) {
                            try {
                                InputStream in = XSD.class.getResourceAsStream(resolvedName);
                                log.debug((Object)("Resolved systemId=" + systemId));
                                DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                                DOMImplementationLS ls = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
                                LSInput input = ls.createLSInput();
                                input.setByteStream(in);
                                return input;
                            }
                            catch (Exception e) {
                                log.error((Object)"Could not obtain xml.xsd", (Throwable)e);
                            }
                        }
                        return null;
                    }
                });
                return factory.newSchema(url);
            }
        });
    }

    public XSD fetch() {
        new Thread(){

            @Override
            public void run() {
                XSD.this.schema.run();
            }
        }.start();
        return this;
    }

    public XSD fetch(Executor executor) {
        executor.execute(this.schema);
        return this;
    }

    public Validator getValidator() {
        try {
            return this.schema.get().newValidator();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        catch (ExecutionException e) {
            throw new AssertionError((Object)e.getCause());
        }
    }

    public void validate(Source source) throws SAXException, IOException {
        this.getValidator().validate(source);
    }

    static {
        a.put("http://www.w3.org/2001/xml.xsd", "xml.xsd");
        a.put("XMLSchema.dtd", "XMLSchema.dtd");
        a.put("datatypes.dtd", "datatypes.dtd");
        PORTLET_1_0 = new XSD(XSD.class.getResource("portlet-app_1_0.xsd")).fetch();
        PORTLET_2_0 = new XSD(XSD.class.getResource("portlet-app_2_0.xsd")).fetch();
    }
}

