/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

public final class Semaphores {
    public static final int NULL_COLLECTION = 1;
    public static final int METADATA_ONLY = 2;
    public static final int CONVERSION_AND_CRS = 4;
    public static final int ENCLOSED_IN_OPERATION = 8;
    public static final int SUSPEND_PARAMETER_CHECK = 16;
    public static final int FINER_OBJECT_CREATION_LOGS = 32;
    private static final ThreadLocal<Semaphores> FLAGS = new ThreadLocal();
    private int flags;

    private Semaphores() {
    }

    public static boolean query(int n) {
        Semaphores semaphores = FLAGS.get();
        return semaphores != null && (semaphores.flags & n) != 0;
    }

    public static boolean queryAndSet(int n) {
        Semaphores semaphores = FLAGS.get();
        if (semaphores == null) {
            semaphores = new Semaphores();
            FLAGS.set(semaphores);
        }
        boolean bl = (semaphores.flags & n) != 0;
        semaphores.flags |= n;
        return bl;
    }

    public static void clear(int n) {
        Semaphores semaphores = FLAGS.get();
        if (semaphores != null) {
            semaphores.flags &= ~n;
        }
    }

    public static void clear(int n, boolean bl) {
        if (!bl) {
            Semaphores.clear(n);
        }
    }
}

