/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.router.metamodel;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import juzu.impl.common.JSON;
import juzu.impl.plugin.router.ParamDescriptor;

public class RouteMetaModel
implements Serializable {
    final String path;
    final String handle;
    final int priority;
    HashMap<String, ParamDescriptor> parameters;

    public RouteMetaModel(String path, String handle, int priority, HashMap<String, ParamDescriptor> parameters) {
        this.path = path;
        this.handle = handle;
        this.priority = priority;
        this.parameters = parameters;
    }

    public String getPath() {
        return this.path;
    }

    public JSON toJSON() {
        JSON json = new JSON();
        json.set("path", this.path);
        json.set("handle", this.handle);
        if (this.parameters != null && this.parameters.size() > 0) {
            JSON b = new JSON();
            for (Map.Entry<String, ParamDescriptor> parameter : this.parameters.entrySet()) {
                ParamDescriptor value = parameter.getValue();
                b.set(parameter.getKey(), new JSON().set("pattern", value.getPattern()).set("preserve-path", value.getPreservePath()).set("capture-group", value.getCaptureGroup()));
            }
            json.set("parameters", b);
        }
        return json;
    }
}

