/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class CollectionMap<K, V>
implements Serializable {
    private final Map<K, Collection<V>> map;
    protected Comparator<V> comparator;

    public CollectionMap() {
        this.map = this.init(null);
    }

    public CollectionMap(CollectionMap<K, V> other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("Cannot copy null argument");
        }
        this.map = this.init(other);
    }

    public CollectionMap(CollectionMap<K, V> other, Comparator<V> comparator) throws IllegalArgumentException {
        this(other);
        super.initComparator(comparator);
    }

    public CollectionMap(Comparator<V> comparator) {
        this();
        super.initComparator(comparator);
    }

    private void initComparator(Comparator<V> comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException("No null comparator allowed");
        }
        this.comparator = comparator;
    }

    public final void put(K key, V o) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("No null key");
        }
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            collection = this.newCollection();
            this.map.put(key, collection);
        }
        this.add(collection, o);
    }

    public final Set<K> keySet() {
        return this.map.keySet();
    }

    public final void remove(K key) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("No null key");
        }
        this.map.remove(key);
    }

    public final void remove(K key, Object o) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("No null key");
        }
        Collection<V> collection = this.map.get(key);
        if (collection != null) {
            this.remove(collection, o);
            if (collection.isEmpty()) {
                this.map.remove(key);
            }
        }
    }

    public final boolean contains(K key, Object o) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("No null key");
        }
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            return false;
        }
        return collection.contains(o);
    }

    public Collection<V> get(K key) {
        return this.map.get(key);
    }

    public final Iterator<V> iterator(final K key) {
        if (key == null) {
            throw new NullPointerException("No null key");
        }
        Collection<V> set = this.map.get(key);
        if (set == null) {
            Set tmp = Collections.emptySet();
            return tmp.iterator();
        }
        final Iterator<V> iterator = set.iterator();
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public V next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
                if (!iterator.hasNext()) {
                    CollectionMap.this.map.remove(key);
                }
            }
        };
    }

    private Map<K, Collection<V>> init(CollectionMap<K, V> other) {
        HashMap<K, Collection<V>> map = new HashMap<K, Collection<V>>();
        if (other != null) {
            for (Map.Entry<K, Collection<V>> entry : other.map.entrySet()) {
                K key = entry.getKey();
                Collection<V> value = entry.getValue();
                map.put(key, this.newCollection(value));
            }
        }
        return map;
    }

    protected abstract void add(Collection<V> var1, V var2);

    protected abstract void remove(Collection<V> var1, Object var2);

    protected abstract Collection<V> newCollection();

    protected abstract Collection<V> newCollection(Collection<V> var1);
}

