/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class TimeZoneUtils {
    private TimeZoneUtils() {
    }

    public static List<TimeZone> getTimeZones() {
        String[] ids = TimeZone.getAvailableIDs();
        HashMap<Integer, TimeZone> timeZoneByOffset = new HashMap<Integer, TimeZone>();
        for (String id : ids) {
            TimeZone timeZone = TimeZone.getTimeZone(id);
            if (timeZone.getDisplayName().contains("GMT")) continue;
            timeZoneByOffset.put(timeZone.getRawOffset(), timeZone);
        }
        ArrayList offsets = new ArrayList(timeZoneByOffset.keySet());
        Collections.sort(offsets);
        return offsets.stream().map(offset -> (TimeZone)timeZoneByOffset.get(offset)).collect(Collectors.toList());
    }

    public static String getTimeZoneDisplay(TimeZone timeZone, Locale locale) {
        long hours = TimeUnit.MILLISECONDS.toHours(timeZone.getRawOffset());
        long minutes = TimeUnit.MILLISECONDS.toMinutes(timeZone.getRawOffset()) - TimeUnit.HOURS.toMinutes(hours);
        minutes = Math.abs(minutes);
        String result = "";
        result = hours > 0L ? String.format("(GMT +%02d:%02d) %s", hours, minutes, timeZone.getDisplayName(locale)) : String.format("(GMT %02d:%02d) %s", hours, minutes, timeZone.getDisplayName(locale));
        return result;
    }
}

