/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.Map;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.concurrent.jdk8backported.EquivalentConcurrentHashMapV8;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsTopologyAwareAddress;
import org.infinispan.topology.PersistentUUID;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.UUID;

public class JGroupsAddressCache {
    private static final EquivalentConcurrentHashMapV8<org.jgroups.Address, JGroupsAddress> addressCache = new EquivalentConcurrentHashMapV8((Equivalence)AnyEquivalence.getInstance(), (Equivalence)AnyEquivalence.getInstance());
    private static final EquivalentConcurrentHashMapV8<JGroupsAddress, PersistentUUID> persistentUUIDCache = new EquivalentConcurrentHashMapV8((Equivalence)AnyEquivalence.getInstance(), (Equivalence)AnyEquivalence.getInstance());

    public static Address fromJGroupsAddress(Object address) {
        org.jgroups.Address jgAddress = (org.jgroups.Address)address;
        JGroupsAddress ispnAddress = (JGroupsAddress)addressCache.get((Object)jgAddress);
        if (ispnAddress != null) {
            return ispnAddress;
        }
        return (Address)addressCache.computeIfAbsent((Object)jgAddress, uuid -> {
            if (jgAddress instanceof ExtendedUUID) {
                return new JGroupsTopologyAwareAddress((ExtendedUUID)jgAddress);
            }
            return new JGroupsAddress(jgAddress);
        });
    }

    public static void putAddressPersistentUUID(Object address, PersistentUUID uuid) {
        persistentUUIDCache.put((Object)((JGroupsAddress)address), (Object)uuid);
    }

    public static PersistentUUID getPersistentUUID(Object address) {
        return (PersistentUUID)persistentUUIDCache.get(address);
    }

    public static Address fromPersistentUUID(PersistentUUID uuid) {
        for (Map.Entry entry : persistentUUIDCache.entrySet()) {
            if (!((PersistentUUID)entry.getValue()).equals(uuid)) continue;
            return (Address)entry.getKey();
        }
        return null;
    }

    static void pruneAddressCache() {
        addressCache.forEachKey(Integer.MAX_VALUE, address -> {
            if (UUID.get((org.jgroups.Address)address) == null) {
                addressCache.remove(address);
                persistentUUIDCache.remove(address);
            }
        });
    }

    public static void flushAddressCaches() {
        addressCache.clear();
        persistentUUIDCache.clear();
    }
}

