/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.jdbc.entity.PermissionEntity;
import org.exoplatform.portal.jdbc.entity.SiteEntity;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PortalConfigPermissionMigration
extends UpgradeProductPlugin {
    private final PortalContainer container;
    private final EntityManagerService entityManagerService;
    int pagesNodesCount;
    private CacheService cacheService;
    private static final Log LOG = ExoLogger.getExoLogger(PortalConfigPermissionMigration.class);

    public PortalConfigPermissionMigration(PortalContainer container, EntityManagerService entityManagerService, CacheService cacheService, InitParams initParams) {
        super(initParams);
        this.container = container;
        this.entityManagerService = entityManagerService;
        this.cacheService = cacheService;
        this.pagesNodesCount = 0;
    }

    public void processUpgrade(String s, String s1) {
        long startupTime = System.currentTimeMillis();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        boolean transactionStarted = false;
        LOG.info((Object)"Start upgrade of permission for portalConfiguration");
        RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
        EntityManager entityManager = this.entityManagerService.getEntityManager();
        try {
            if (!entityManager.getTransaction().isActive()) {
                entityManager.getTransaction().begin();
                transactionStarted = true;
            }
            String sqlString1 = "SELECT p FROM GateInPermission p WHERE p.permission LIKE '%@owner@%'";
            TypedQuery nativeQuery1 = entityManager.createQuery(sqlString1, PermissionEntity.class);
            List resultList = nativeQuery1.getResultList();
            resultList.forEach(permissionEntity -> {
                Long portalConfigId = permissionEntity.getReferenceId();
                String sqlString2 = "SELECT s FROM GateInSite s where s.id=:siteId";
                TypedQuery nativeQuery2 = entityManager.createQuery(sqlString2, SiteEntity.class);
                nativeQuery2.setParameter("siteId", (Object)portalConfigId);
                SiteEntity site = (SiteEntity)nativeQuery2.getSingleResult();
                String name = site.getName();
                String permission = permissionEntity.getPermission().replace("@owner@", name);
                String updateQuery = "UPDATE PORTAL_PERMISSIONS SET PERMISSION = :permission WHERE PERMISSION_ID=:permissionId";
                Query updateNativeQuery = entityManager.createNativeQuery(updateQuery);
                updateNativeQuery.setParameter("permission", (Object)permission);
                updateNativeQuery.setParameter("permissionId", (Object)permissionEntity.getId());
                this.pagesNodesCount += updateNativeQuery.executeUpdate();
                LOG.info("Update permission from {} to {} for portalConfig {}", new Object[]{permissionEntity.getPermission(), permission, name});
            });
            LOG.info("End upgrade of of permission for portalConfiguration. It took {} ms", new Object[]{System.currentTimeMillis() - startupTime});
            if (transactionStarted && entityManager.getTransaction().isActive()) {
                entityManager.getTransaction().commit();
            }
            this.clearNavigationCache();
        }
        catch (Exception e) {
            if (transactionStarted && entityManager.getTransaction().isActive() && entityManager.getTransaction().getRollbackOnly()) {
                entityManager.getTransaction().rollback();
            }
            throw new RuntimeException("Unable to update PortalSite", e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private void clearNavigationCache() {
        if (this.pagesNodesCount > 0) {
            ExoCache descriptionCache;
            ExoCache navigationCache = this.cacheService.getCacheInstance("portal.NavigationService");
            if (navigationCache != null) {
                navigationCache.clearCache();
            }
            if ((descriptionCache = this.cacheService.getCacheInstance("portal.DescriptionService")) != null) {
                descriptionCache.clearCache();
            }
        }
    }
}

