/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.web.linkedin;

import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import io.meeds.oauth.exception.OAuthException;
import io.meeds.oauth.exception.OAuthExceptionCode;
import io.meeds.oauth.linkedin.LinkedinAccessTokenContext;
import io.meeds.oauth.spi.InteractionState;
import io.meeds.oauth.spi.OAuthPrincipal;
import io.meeds.oauth.spi.OAuthProviderType;
import io.meeds.oauth.web.OAuthProviderFilter;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LinkedInFilter
extends OAuthProviderFilter<LinkedinAccessTokenContext> {
    private static String URL_CURRENT_PROFILE_USER = "https://api.linkedin.com/v2/me?projection=(id,firstName,lastName,profilePicture(displayImage~:playableStreams))";
    private static String URL_CURRENT_PROFILE_USER_EMAIL = "https://api.linkedin.com/v2/emailAddress?q=members&projection=(elements*(handle~))";

    @Override
    protected OAuthProviderType<LinkedinAccessTokenContext> getOAuthProvider() {
        return this.getOauthProvider("LINKEDIN", LinkedinAccessTokenContext.class);
    }

    @Override
    protected void initInteraction(HttpServletRequest request, HttpServletResponse response) {
        request.getSession().removeAttribute("_linkedinRequestToken");
    }

    @Override
    protected OAuthPrincipal<LinkedinAccessTokenContext> getOAuthPrincipal(HttpServletRequest request, HttpServletResponse response, InteractionState<LinkedinAccessTokenContext> interactionState) {
        LinkedinAccessTokenContext accessTokenContext = interactionState.getAccessTokenContext();
        OAuthRequest oauthRequest = new OAuthRequest(Verb.GET, URL_CURRENT_PROFILE_USER);
        OAuthRequest oauthRequest1 = new OAuthRequest(Verb.GET, URL_CURRENT_PROFILE_USER_EMAIL);
        accessTokenContext.oauth20Service.signRequest(accessTokenContext.accessToken, oauthRequest);
        accessTokenContext.oauth20Service.signRequest(accessTokenContext.accessToken, oauthRequest1);
        oauthRequest.addHeader("x-li-format", "json");
        oauthRequest.addHeader("Accept-Language", "ru-RU");
        oauthRequest1.addHeader("x-li-format", "json");
        oauthRequest1.addHeader("Accept-Language", "ru-RU");
        try {
            JSONArray arr;
            Response responses = accessTokenContext.oauth20Service.execute(oauthRequest);
            String body = responses.getBody();
            JSONObject json = new JSONObject(body);
            Response responses1 = accessTokenContext.oauth20Service.execute(oauthRequest1);
            String body1 = responses1.getBody();
            JSONObject json1 = new JSONObject(body1);
            String id = json.getString("id");
            String firstName = json.getString("firstName").substring(23, json.getString("firstName").indexOf("\"},"));
            String lastName = json.getString("lastName").substring(23, json.getString("lastName").indexOf("\"},"));
            String displayName = firstName + " " + lastName;
            String email = json1.getString("elements").substring(71, json1.getString("elements").indexOf("\"}}]"));
            String avatar = json.optString("pictureUrl");
            JSONObject profilePictures = json.optJSONObject("pictureUrls");
            if (profilePictures != null && (arr = profilePictures.optJSONArray("values")) != null && arr.length() > 0) {
                avatar = arr.getString(0);
            }
            OAuthPrincipal<LinkedinAccessTokenContext> principal = new OAuthPrincipal<LinkedinAccessTokenContext>(id, firstName, lastName, displayName, email, avatar, accessTokenContext, this.getOAuthProvider());
            return principal;
        }
        catch (IOException | InterruptedException | ExecutionException | JSONException ex) {
            throw new OAuthException(OAuthExceptionCode.LINKEDIN_ERROR, "Error when obtaining user", ex);
        }
    }
}

