/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration.dlp;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DlpFolderAndDriveMigration
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(DlpFolderAndDriveMigration.class);
    private static final String OLD_NODE_PATH = "old.nodePath";
    private static final String NEW_NODE_PATH = "new.nodePath";
    private static final String WORKSPACE_COLLABORATION = "collaboration";
    private String oldNodePath;
    private String newNodePath;
    private final RepositoryService repositoryService;
    private final ManageDriveService manageDriveService;
    private SessionProviderService sessionProviderService;
    private int nodesMovedCount;

    public DlpFolderAndDriveMigration(InitParams initParams, SettingService settingService, RepositoryService repositoryService, ManageDriveService manageDriveService) {
        super(settingService, initParams);
        this.repositoryService = repositoryService;
        this.manageDriveService = manageDriveService;
        if (initParams.containsKey((Object)OLD_NODE_PATH)) {
            this.oldNodePath = initParams.getValueParam(OLD_NODE_PATH).getValue();
        }
        if (initParams.containsKey((Object)NEW_NODE_PATH)) {
            this.newNodePath = initParams.getValueParam(NEW_NODE_PATH).getValue();
        }
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        if (StringUtils.isBlank((CharSequence)this.oldNodePath)) {
            LOG.error("Couldn't process upgrade, the parameter '{}' is mandatory", new Object[]{OLD_NODE_PATH});
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.newNodePath)) {
            LOG.error("Couldn't process upgrade, the parameter '{}' is mandatory", new Object[]{NEW_NODE_PATH});
            return;
        }
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            Session session = sessionProvider.getSession(WORKSPACE_COLLABORATION, this.repositoryService.getCurrentRepository());
            if (session.itemExists(this.oldNodePath)) {
                long startupTime = System.currentTimeMillis();
                LOG.info((Object)"Start migration of Dlp folder and drive");
                Node oldNode = (Node)session.getItem(this.oldNodePath);
                NodeIterator iter = oldNode.getNodes();
                Workspace workspace = session.getWorkspace();
                while (iter.hasNext()) {
                    Node node = iter.nextNode();
                    workspace.move(node.getPath(), this.newNodePath + "/" + node.getName());
                    node.save();
                    ++this.nodesMovedCount;
                }
                this.manageDriveService.removeDrive(oldNode.getName());
                oldNode.remove();
                session.save();
                LOG.info("End migration of '{}' node under Dlp folder and drive It took {} ms", new Object[]{this.nodesMovedCount, System.currentTimeMillis() - startupTime});
            }
        }
    }

    public int getNodesMovedCount() {
        return this.nodesMovedCount;
    }
}

