/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.actions.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.actions.activation.ScriptActionActivationJob;
import org.exoplatform.services.cms.actions.impl.ActionConfig;
import org.exoplatform.services.cms.actions.impl.BaseActionLauncherListener;
import org.exoplatform.services.cms.actions.impl.BaseActionPlugin;
import org.exoplatform.services.cms.actions.impl.ECMEventListener;
import org.exoplatform.services.cms.scripts.CmsScript;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class ScriptActionPlugin
extends BaseActionPlugin
implements ComponentPlugin {
    public static final String ACTION_TYPE = "exo:scriptAction";
    private ScriptService scriptService_;
    private RepositoryService repositoryService_;
    private ActionConfig config_;
    private String desc_ = "";

    public ScriptActionPlugin(ScriptService scriptService, InitParams params, RepositoryService repositoryService) throws Exception {
        this.scriptService_ = scriptService;
        this.repositoryService_ = repositoryService;
        this.config_ = (ActionConfig)params.getObjectParamValues(ActionConfig.class).get(0);
    }

    @Override
    public Collection<String> getActionExecutables() throws Exception {
        ArrayList<String> actionScriptNames = new ArrayList<String>();
        SessionProvider provider = SessionProvider.createSystemProvider();
        List<Node> actionScriptList = this.scriptService_.getECMActionScripts(provider);
        String baseScriptPath = this.scriptService_.getBaseScriptPath();
        for (Node script : actionScriptList) {
            String actionScriptName = StringUtils.substringAfter((String)script.getPath(), (String)(baseScriptPath + "/"));
            actionScriptNames.add(actionScriptName);
        }
        provider.close();
        return actionScriptNames;
    }

    @Override
    public String getActionExecutableLabel() {
        return "exo:scriptLabel";
    }

    @Override
    public String getExecutableDefinitionName() {
        return "exo:script";
    }

    @Override
    protected String getWorkspaceName() {
        return this.config_.getWorkspace();
    }

    @Override
    protected ManageableRepository getRepository() throws Exception {
        return this.repositoryService_.getCurrentRepository();
    }

    @Override
    protected String getActionType() {
        return ACTION_TYPE;
    }

    @Override
    protected List getActions() {
        return this.config_.getActions();
    }

    @Override
    protected ECMEventListener createEventListener(String actionName, String actionExecutable, String repository, String srcWorkspace, String srcPath, Map variables, String actiontype) throws Exception {
        return new ScriptActionLauncherListener(actionName, actionExecutable, repository, srcWorkspace, srcPath, variables);
    }

    public String getName() {
        return ACTION_TYPE;
    }

    public void setName(String s) {
    }

    public String getDescription() {
        return this.desc_;
    }

    public void setDescription(String desc) {
        this.desc_ = desc;
    }

    @Override
    public void executeAction(String userId, Node actionNode, Map variables) throws Exception {
        String script = null;
        if (actionNode.hasProperty("exo:script")) {
            script = actionNode.getProperty("exo:script").getString();
        } else {
            NodeType nodeType = actionNode.getPrimaryNodeType();
            for (PropertyDefinition propertyDefinition : nodeType.getPropertyDefinitions()) {
                if (!propertyDefinition.getName().equals("exo:script")) continue;
                script = this.getDefaultValue(propertyDefinition);
            }
        }
        variables.put("actionNode", actionNode);
        variables.put("repository", WCMCoreUtils.getRepository().getConfiguration().getName());
        this.executeAction(userId, script, variables);
    }

    private String getDefaultValue(PropertyDefinition proDef) throws Exception {
        StringBuilder defaultValue = new StringBuilder();
        Value[] values = proDef.getDefaultValues();
        if (values == null || values.length < 0) {
            return "";
        }
        for (Value value : values) {
            if (value == null) continue;
            if (defaultValue.length() > 0) {
                defaultValue.append(",");
            }
            defaultValue.append(this.getPropertyValue(value));
        }
        return defaultValue.toString();
    }

    private String getPropertyValue(Value value) throws Exception {
        switch (value.getType()) {
            case 2: {
                return Integer.toString(2);
            }
            case 6: {
                return Boolean.toString(value.getBoolean());
            }
            case 5: {
                return value.getDate().getTime().toString();
            }
            case 4: {
                return Double.toString(value.getDouble());
            }
            case 3: {
                return Long.toString(value.getLong());
            }
            case 7: {
                return value.getString();
            }
            case 1: {
                return value.getString();
            }
        }
        return null;
    }

    @Override
    public void executeAction(String userId, String executable, Map variables) throws Exception {
        if (!variables.containsKey("userId")) {
            variables.put("userId", userId);
        }
        ScriptService scriptService = WCMCoreUtils.getService(ScriptService.class);
        CmsScript cmsScript = scriptService.getScript(executable);
        cmsScript.execute(variables);
    }

    @Override
    public void activateAction(String userId, String executable, Map variables) throws Exception {
        this.executeAction(userId, executable, variables);
    }

    @Override
    protected Class createActivationJob() throws Exception {
        return ScriptActionActivationJob.class;
    }

    public class ScriptActionLauncherListener
    extends BaseActionLauncherListener {
        public ScriptActionLauncherListener(String actionName, String script, String repository, String srcWorkspace, String srcPath, Map actionVariables) throws Exception {
            super(actionName, script, repository, srcWorkspace, srcPath, actionVariables);
        }

        @Override
        public void triggerAction(String userId, Map variables, String repository) throws Exception {
            ScriptActionPlugin.this.executeAction(userId, this.executable_, variables);
        }
    }
}

