/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.util.Defs;

public class PaintTimer {
    protected static final Logger logger = Logger.getLogger(PaintTimer.class.toString());
    protected static int paintDelay;
    private long lastPaintTime;

    public boolean shouldTriggerRepaint() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastPaintTime > (long)paintDelay) {
            this.lastPaintTime = currentTime;
            return true;
        }
        return false;
    }

    static {
        try {
            paintDelay = Defs.intProperty("org.icepdf.core.views.refreshfrequency", 250);
        }
        catch (NumberFormatException e) {
            logger.log(Level.FINE, "Error reading buffered scale factor");
        }
    }
}

