/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service.impl;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.model.Announcement;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.service.AnnouncementService;
import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.storage.AnnouncementStorage;
import io.meeds.gamification.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;

public class AnnouncementServiceImpl
implements AnnouncementService {
    private static final Log LOG = ExoLogger.getLogger(AnnouncementServiceImpl.class);
    public static final long MILLIS_IN_A_DAY = 86400000L;
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private RuleService ruleService;
    private RealizationService realizationService;
    private AnnouncementStorage announcementStorage;
    private ListenerService listenerService;

    public AnnouncementServiceImpl(AnnouncementStorage announcementStorage, RuleService ruleService, RealizationService realizationService, IdentityManager identityManager, ActivityManager activityManager, ListenerService listenerService) {
        this.ruleService = ruleService;
        this.realizationService = realizationService;
        this.announcementStorage = announcementStorage;
        this.activityManager = activityManager;
        this.identityManager = identityManager;
        this.listenerService = listenerService;
    }

    @Override
    public Announcement createAnnouncement(Announcement announcement, Map<String, String> templateParams, String username) throws ObjectNotFoundException, IllegalAccessException {
        if (announcement == null) {
            throw new IllegalArgumentException("announcement is mandatory");
        }
        if (username == null) {
            throw new IllegalAccessException("Username is mandatory");
        }
        if (announcement.getId() != 0L) {
            throw new IllegalArgumentException("announcement id must be equal to 0");
        }
        RuleDTO rule = this.ruleService.findRuleById(announcement.getChallengeId(), username);
        if (rule == null) {
            throw new ObjectNotFoundException("Rule with id '" + announcement.getChallengeId() + "' doesn't exist");
        }
        if (rule.isDeleted()) {
            throw new IllegalAccessException("Rule with id '" + announcement.getChallengeId() + "' is deleted");
        }
        if (!rule.isEnabled()) {
            throw new IllegalAccessException("Rule with id '" + announcement.getChallengeId() + "' isn't enabled");
        }
        if (rule.getType() != EntityType.MANUAL) {
            throw new IllegalStateException("Rule with id '" + announcement.getChallengeId() + "' isn't a challenge");
        }
        Identity identity = this.identityManager.getOrCreateUserIdentity(username);
        if (identity == null || !this.canAnnounce(rule, identity.getId())) {
            throw new IllegalAccessException("user " + username + " is not allowed to announce a challenge on space with id " + rule.getSpaceId());
        }
        long creatorId = Long.parseLong(identity.getId());
        announcement.setCreator(creatorId);
        announcement.setCreatedDate(null);
        announcement.setAssignee(creatorId);
        announcement = this.announcementStorage.createAnnouncement(announcement);
        this.createActivity(rule, announcement, templateParams);
        Utils.broadcastEvent(this.listenerService, "announcement.created", announcement, creatorId);
        return announcement;
    }

    @Override
    public boolean canAnnounce(RuleDTO rule, String earnerIdentityId) {
        return this.realizationService.getRealizationValidityContext(rule, earnerIdentityId).isValidForIdentity();
    }

    @Override
    public Announcement deleteAnnouncement(long announcementId, String username) throws ObjectNotFoundException, IllegalAccessException {
        if (announcementId <= 0L) {
            throw new IllegalArgumentException("Announcement id has to be positive integer");
        }
        Announcement announcement = this.getAnnouncementById(announcementId);
        if (announcement == null) {
            throw new ObjectNotFoundException("Announcement does not exist");
        }
        Identity identity = this.identityManager.getOrCreateUserIdentity(username);
        if (!announcement.getCreator().equals(Long.parseLong(identity.getId()))) {
            throw new IllegalAccessException("user " + username + " is not allowed to cancel announcement with id " + announcement.getId());
        }
        this.deleteActivity(announcement);
        Utils.broadcastEvent(this.listenerService, "announcement.canceled", announcement, Long.parseLong(identity.getId()));
        return this.announcementStorage.deleteAnnouncement(announcementId);
    }

    @Override
    public Announcement getAnnouncementById(long announcementId) {
        if (announcementId <= 0L) {
            throw new IllegalArgumentException("announcementId is mandatory");
        }
        return this.announcementStorage.getAnnouncementById(announcementId);
    }

    @Override
    public Announcement updateAnnouncementComment(long announcementId, String comment) throws ObjectNotFoundException {
        if (announcementId == 0L) {
            throw new IllegalArgumentException("announcement id is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)comment)) {
            throw new IllegalArgumentException("announcement comment is mandatory");
        }
        Announcement announcement = this.announcementStorage.updateAnnouncementComment(announcementId, comment);
        Utils.broadcastEvent(this.listenerService, "announcement.updated", announcement, announcement.getCreator());
        return announcement;
    }

    private void deleteActivity(Announcement announcement) {
        try {
            String activityId = String.valueOf(announcement.getActivityId());
            this.activityManager.deleteActivity(activityId);
        }
        catch (Exception e) {
            LOG.warn("Error while deleting activity for announcement with challenge with id {} made by user {}", new Object[]{announcement.getChallengeId(), announcement.getCreator(), e});
        }
    }

    private void createActivity(RuleDTO rule, Announcement announcement, Map<String, String> templateParams) {
        try {
            if (templateParams == null) {
                templateParams = new HashMap<String, String>();
            }
            String userIdentityId = String.valueOf(announcement.getCreator());
            if (rule.getActivityId() == 0L) {
                throw new IllegalStateException("Rule " + rule.getId() + " doesn't have a dedicated activity yet");
            }
            ExoSocialActivity activity = this.activityManager.getActivity(String.valueOf(rule.getActivityId()));
            if (activity == null) {
                throw new IllegalStateException("Rule " + rule.getId() + " activity has been deleted");
            }
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
            comment.setType("gamificationActionAnnouncement");
            comment.setTitle(announcement.getComment());
            comment.setParentCommentId(activity.getId());
            comment.setPosterId(userIdentityId);
            comment.setUserId(userIdentityId);
            templateParams.put("announcementId", String.valueOf(announcement.getId()));
            templateParams.put("announcementDescription", rule.getTitle());
            this.buildActivityParams((ExoSocialActivity)comment, templateParams);
            this.activityManager.saveComment(activity, (ExoSocialActivity)comment);
            long commentId = Long.parseLong(comment.getId().replace("comment", ""));
            this.announcementStorage.updateAnnouncementActivityId(announcement.getId(), commentId);
            announcement.setActivityId(commentId);
        }
        catch (Exception e) {
            LOG.warn("Error while creating activity for announcement with challenge with id {} made by user {}", new Object[]{rule.getId(), announcement.getCreator(), e});
        }
    }

    private void buildActivityParams(ExoSocialActivity activity, Map<String, String> templateParams) {
        HashMap<String, String> currentTemplateParams;
        HashMap<String, String> hashMap = currentTemplateParams = activity.getTemplateParams() == null ? new HashMap<String, String>() : new HashMap(activity.getTemplateParams());
        if (templateParams != null) {
            currentTemplateParams.putAll(templateParams);
        }
        for (Map.Entry entry : currentTemplateParams.entrySet()) {
            if (entry == null || !StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue())) && !StringUtils.equals((CharSequence)((CharSequence)entry.getValue()), (CharSequence)"-")) continue;
            entry.setValue("");
        }
        activity.setTemplateParams(currentTemplateParams);
    }
}

