/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.views;

import java.util.ResourceBundle;
import org.exoplatform.ecm.webui.component.admin.views.UIViewList;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UIViewContainer
extends UIContainer {
    public UIViewContainer() throws Exception {
        this.addChild(UIViewList.class, null, null);
    }

    public void initPopup(String popupId, UIComponent uiComponent) throws Exception {
        this.initPopup(popupId, uiComponent, 600, 300);
    }

    public void initPopup(String popupId, UIComponent uiComponent, int width, int height) throws Exception {
        this.removeChildById(popupId);
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, popupId);
        uiPopup.setShowMask(true);
        uiPopup.setShowMask(true);
        uiPopup.setWindowSize(width, height);
        uiPopup.setUIComponent(uiComponent);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    public void update() throws Exception {
        UIViewList uiViewList = (UIViewList)this.getChild(UIViewList.class);
        uiViewList.refresh(uiViewList.getUIPageIterator().getCurrentPage());
    }

    public String getFriendlyPermission(String permission) throws Exception {
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        String permissionLabel = res.getString(this.getId() + ".label.permission");
        if (permission.indexOf(":") > -1) {
            String[] arr = permission.split(":");
            permissionLabel = arr[0].equals("*") ? permissionLabel.replace("{0}", "Any") : permissionLabel.replace("{0}", this.standardizeGroupName(arr[0]));
            String groupName = arr[1];
            groupName = groupName.substring(groupName.lastIndexOf("/") + 1);
            permissionLabel = permissionLabel.replace("{1}", this.standardizeGroupName(groupName));
        } else {
            permissionLabel = this.standardizeGroupName(permission);
        }
        return permissionLabel;
    }

    public String standardizeGroupName(String groupName) throws Exception {
        groupName = groupName.replaceAll("-", " ");
        char[] stringArray = groupName.toCharArray();
        stringArray[0] = Character.toUpperCase(stringArray[0]);
        groupName = new String(stringArray);
        return groupName;
    }
}

