/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.listener.post;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;

public class PostCreateContentEventListener
extends Listener<CmsService, Node> {
    private static final Log LOG = ExoLogger.getLogger((String)PostCreateContentEventListener.class.getName());
    public static final String POST_INIT_STATE_EVENT = "PublicationService.event.postInitState";
    private WCMPublicationService publicationService;
    private WCMConfigurationService configurationService;
    private WebContentSchemaHandler webContentSchemaHandler;
    private ListenerService listenerService = null;
    private ActivityCommonService activityService;

    public PostCreateContentEventListener(WCMPublicationService publicationService, WCMConfigurationService configurationService, WebSchemaConfigService schemaConfigService) {
        this.publicationService = publicationService;
        this.configurationService = configurationService;
        this.webContentSchemaHandler = (WebContentSchemaHandler)schemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
        this.activityService = (ActivityCommonService)WCMCoreUtils.getService(ActivityCommonService.class);
    }

    public void onEvent(Event<CmsService, Node> event) throws Exception {
        String remoteUser;
        String siteName;
        Node currentNode;
        block25: {
            block24: {
                block23: {
                    block22: {
                        if (this.listenerService == null) {
                            this.listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
                        }
                        currentNode = (Node)event.getData();
                        try {
                            if (currentNode.canAddMixin("exo:webContentChild") && currentNode.isNodeType("nt:resource") && currentNode.getParent().isNodeType("nt:file") && "default.html".equals(currentNode.getParent().getName()) && currentNode.getParent().getParent().isNodeType("exo:webContent")) {
                                currentNode.addMixin("exo:webContentChild");
                            }
                        }
                        catch (Exception e) {
                            if (!LOG.isWarnEnabled()) break block22;
                            LOG.warn((Object)("Error, can not add mixin 'exo:webContentChild' to node: " + currentNode.getPath()));
                        }
                    }
                    try {
                        if (currentNode.canAddMixin("exo:webContentChild") && currentNode.isNodeType("nt:resource") && currentNode.getParent().isNodeType("nt:file") && "default.css".equals(currentNode.getParent().getName()) && currentNode.getParent().getParent().isNodeType("exo:cssFolder") && "css".equals(currentNode.getParent().getParent().getName()) && currentNode.getParent().getParent().getParent().isNodeType("exo:webContent")) {
                            currentNode.addMixin("exo:webContentChild");
                        }
                    }
                    catch (Exception e) {
                        if (!LOG.isWarnEnabled()) break block23;
                        LOG.warn((Object)("Error, can not add mixin 'exo:webContentChild' to node: " + currentNode.getPath()));
                    }
                }
                try {
                    if (currentNode.canAddMixin("exo:webContentChild") && currentNode.isNodeType("nt:resource") && currentNode.getParent().isNodeType("nt:file") && "default.js".equals(currentNode.getParent().getName()) && currentNode.getParent().getParent().isNodeType("exo:jsFolder") && "js".equals(currentNode.getParent().getParent().getName()) && currentNode.getParent().getParent().getParent().isNodeType("exo:webContent")) {
                        currentNode.addMixin("exo:webContentChild");
                    }
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block24;
                    LOG.warn((Object)("Error, can not add mixin 'exo:webContentChild' to node: " + currentNode.getPath()));
                }
            }
            if (currentNode.canAddMixin("exo:rss-enable")) {
                currentNode.addMixin("exo:rss-enable");
            }
            if (currentNode.isNodeType("exo:rss-enable") && !currentNode.hasProperty("exo:title") || currentNode.hasProperty("exo:title") && StringUtils.isEmpty((String)currentNode.getProperty("exo:title").getString())) {
                currentNode.setProperty("exo:title", Text.unescapeIllegalJcrChars((String)currentNode.getName()));
            }
            if (currentNode.isNodeType("exo:cssFile") || currentNode.isNodeType("exo:jsFile") || currentNode.getParent().isNodeType("exo:actionStorage")) {
                if (currentNode.isNodeType("exo:cssFile") || currentNode.isNodeType("exo:jsFile")) {
                    CmsService cmsService = (CmsService)WCMCoreUtils.getService(CmsService.class);
                    this.listenerService.broadcast(POST_INIT_STATE_EVENT, (Object)cmsService, (Object)currentNode);
                }
                return;
            }
            Session session = currentNode.getSession();
            String nodePath = currentNode.getPath();
            currentNode.getParent().save();
            currentNode = (Node)session.getItem(nodePath);
            if (currentNode instanceof NodeImpl && !((NodeImpl)currentNode).isValid()) {
                currentNode = (Node)session.getItem(nodePath);
                LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
                if (linkManager.isLink((Item)currentNode)) {
                    try {
                        currentNode = linkManager.getTarget(currentNode, false);
                    }
                    catch (Exception ex) {
                        currentNode = linkManager.getTarget(currentNode, true);
                    }
                }
            }
            siteName = null;
            remoteUser = null;
            try {
                siteName = Util.getPortalRequestContext().getPortalOwner();
                remoteUser = Util.getPortalRequestContext().getRemoteUser();
            }
            catch (NullPointerException npe) {
                if (!LOG.isDebugEnabled()) break block25;
                LOG.debug((Object)"No portal context available");
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(currentNode.getPath() + "::" + siteName + "::" + remoteUser));
        }
        if (remoteUser == null) {
            remoteUser = IdentityConstants.ANONIM;
        }
        this.publicationService.updateLifecyleOnChangeContent(currentNode, siteName, remoteUser);
    }
}

