/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.filter.Filter;

public class DocumentPreviewFilter
implements Filter {
    private static final Log LOG = ExoLogger.getLogger(DocumentPreviewFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ListenerService listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String documentPreviewId = httpServletRequest.getParameter("documentPreviewId");
        String documentEditId = httpServletRequest.getParameter("docId");
        String sourcePreview = httpServletRequest.getParameter("source");
        if (documentPreviewId != null || documentEditId != null && sourcePreview == null) {
            String viewer = httpServletRequest.getRemoteUser();
            try {
                String documentId = documentPreviewId != null ? documentPreviewId : documentEditId;
                listenerService.broadcast("update-document-views-detail", (Object)viewer, (Object)documentId);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while broadcasting event", (Throwable)e);
            }
        }
        chain.doFilter(request, response);
    }
}

