/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.filters;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.ecm.webui.filters.AbstractCloudDriveNodeFilter;
import org.exoplatform.services.cms.clouddrives.CloudDrive;
import org.exoplatform.services.cms.clouddrives.CloudDriveService;
import org.exoplatform.services.cms.clouddrives.CloudFile;
import org.exoplatform.services.cms.clouddrives.DriveRemovedException;
import org.exoplatform.services.cms.clouddrives.NotCloudDriveException;
import org.exoplatform.services.cms.clouddrives.NotCloudFileException;
import org.exoplatform.services.cms.clouddrives.NotYetCloudFileException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.application.WebuiRequestContext;

public class CloudFileFilter
extends AbstractCloudDriveNodeFilter {
    protected static final Log LOG = ExoLogger.getLogger(CloudFileFilter.class);

    public CloudFileFilter() {
    }

    public CloudFileFilter(List<String> providers) {
        super(providers);
    }

    public CloudFileFilter(List<String> providers, long minSize, long maxSize) {
        super(providers, minSize, maxSize);
    }

    public CloudFileFilter(long minSize, long maxSize) {
        super(minSize, maxSize);
    }

    @Override
    protected boolean accept(Node node) throws RepositoryException {
        CloudDriveService driveService;
        CloudDrive drive;
        if (node != null && (drive = (driveService = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class)).findDrive(node)) != null) {
            try {
                CloudFile file;
                long size;
                if (this.acceptProvider(drive.getUser().getProvider()) && (size = (file = drive.getFile(node.getPath())).getSize()) >= this.minSize && size <= this.maxSize) {
                    WebuiRequestContext rcontext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                    rcontext.setAttribute(CloudDrive.class, (Object)drive);
                    rcontext.setAttribute(CloudFile.class, (Object)file);
                    return true;
                }
            }
            catch (DriveRemovedException driveRemovedException) {
            }
            catch (NotYetCloudFileException notYetCloudFileException) {
            }
            catch (NotCloudFileException notCloudFileException) {
            }
            catch (NotCloudDriveException notCloudDriveException) {
                // empty catch block
            }
        }
        return false;
    }
}

