/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.webconferencing.IdentityInfo;
import org.exoplatform.webconferencing.UserInfo;

public abstract class GroupInfo
extends IdentityInfo {
    protected String callId;
    protected final Map<String, UserInfo> members = new LinkedHashMap<String, UserInfo>();

    public GroupInfo(String id, String title) {
        super(id, title);
    }

    public String getCallId() {
        return this.callId;
    }

    @Override
    public boolean isGroup() {
        return true;
    }

    protected void setCallId(String callId) {
        this.callId = callId;
    }

    public Map<String, UserInfo> getMembers() {
        return Collections.unmodifiableMap(this.members);
    }

    protected void addMember(UserInfo user) {
        this.members.put(user.getId(), user);
    }

    protected void addMembers(Collection<UserInfo> users) {
        for (UserInfo u : users) {
            this.addMember(u);
        }
    }

    protected void setMembers(Collection<UserInfo> users) {
        this.members.clear();
        for (UserInfo u : users) {
            this.addMember(u);
        }
    }
}

