/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.jdbc.entity.NodeEntity;
import org.exoplatform.portal.mop.dao.NodeDAO;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NavigationNotesMigration
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(NavigationNotesMigration.class);
    private static final String OLD_NAVIGATION_NODE_NAME = "old.nav.name";
    private static final String NEW_NAVIGATION_NODE_NAME = "new.nav.name";
    private static final String NEW_NAVIGATION_NODE_LABEL = "new.nav.label";
    private final PortalContainer container;
    private final EntityManagerService entityManagerService;
    private CacheService cacheService;
    private int pagesNodesCount;
    private String oldNavName;
    private String newNavName;
    private String newNavLabel;

    public NavigationNotesMigration(PortalContainer container, EntityManagerService entityManagerService, CacheService cacheService, InitParams initParams) {
        super(initParams);
        this.container = container;
        this.entityManagerService = entityManagerService;
        this.cacheService = cacheService;
        if (initParams.containsKey((Object)OLD_NAVIGATION_NODE_NAME)) {
            this.oldNavName = initParams.getValueParam(OLD_NAVIGATION_NODE_NAME).getValue();
        }
        if (initParams.containsKey((Object)NEW_NAVIGATION_NODE_NAME)) {
            this.newNavName = initParams.getValueParam(NEW_NAVIGATION_NODE_NAME).getValue();
        }
        if (initParams.containsKey((Object)NEW_NAVIGATION_NODE_LABEL)) {
            this.newNavLabel = initParams.getValueParam(NEW_NAVIGATION_NODE_LABEL).getValue();
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousGroupVersion, UpgradePluginExecutionContext previousUpgradePluginExecution) {
        int executionCount = previousUpgradePluginExecution == null ? 0 : previousUpgradePluginExecution.getExecutionCount();
        return !this.isExecuteOnlyOnce() || executionCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (StringUtils.isEmpty((CharSequence)this.oldNavName) || StringUtils.isEmpty((CharSequence)this.newNavName) || StringUtils.isEmpty((CharSequence)this.newNavLabel)) {
            LOG.error((Object)"Couldn't process upgrade, all parameters are mandatory");
            return;
        }
        long startupTime = System.currentTimeMillis();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        boolean transactionStarted = false;
        LOG.info("Start upgrade of navigation node with name '{}' to use name '{}'", new Object[]{this.oldNavName, this.newNavName});
        RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
        EntityManager entityManager = this.entityManagerService.getEntityManager();
        try {
            if (!entityManager.getTransaction().isActive()) {
                entityManager.getTransaction().begin();
                transactionStarted = true;
            }
            String sqlString = "UPDATE PORTAL_NAVIGATION_NODES SET NAME = '" + this.newNavName + "' ,LABEL = '" + this.newNavLabel + "' WHERE NAME = '" + this.oldNavName + "' AND NODE_ID > 0;";
            Query nativeQuery = entityManager.createNativeQuery(sqlString);
            this.pagesNodesCount = nativeQuery.executeUpdate();
            String sqlString1 = "SELECT * FROM PORTAL_NAVIGATION_NODES as T\n              Where Exists    (\n                Select 1\n                From PORTAL_NAVIGATION_NODES As T2\n                Where T2.PARENT_ID =  T.PARENT_ID and T2.NAME =  T.NAME\n                    And T2.NODE_ID <> T.NODE_ID\n                )";
            Query nativeQuery1 = entityManager.createNativeQuery(sqlString1, NodeEntity.class);
            List resultList = nativeQuery1.getResultList();
            NodeDAO nodeDAO = (NodeDAO)CommonsUtils.getService(NodeDAO.class);
            LOG.info((Object)resultList);
            List parentIDList = resultList.stream().map(nodeEntity -> nodeEntity.getParent().getId()).distinct().collect(Collectors.toList());
            for (Long parentID : parentIDList) {
                List nodesListWithSameParent = resultList.stream().filter(c -> c.getParent().getId() == parentID).collect(Collectors.toList());
                for (int i = 1; i < nodesListWithSameParent.size(); ++i) {
                    ((NodeEntity)nodesListWithSameParent.get(i)).setName(((NodeEntity)nodesListWithSameParent.get(i)).getName() + "_" + i);
                }
                nodeDAO.updateAll(nodesListWithSameParent);
            }
            LOG.info("End upgrade of '{}' navigation node with name '{}' to use name '{}'. It took {} ms", new Object[]{this.pagesNodesCount, this.oldNavName, this.newNavName, System.currentTimeMillis() - startupTime});
            if (transactionStarted && entityManager.getTransaction().isActive()) {
                entityManager.getTransaction().commit();
                entityManager.clear();
                entityManager.flush();
            }
        }
        catch (Exception e) {
            if (transactionStarted && entityManager.getTransaction().isActive() && entityManager.getTransaction().getRollbackOnly()) {
                entityManager.getTransaction().rollback();
            }
        }
        finally {
            RequestLifeCycle.end();
        }
        this.clearNavigationCache();
    }

    public int getNodesUpdatedCount() {
        return this.pagesNodesCount;
    }

    private void clearNavigationCache() {
        if (this.pagesNodesCount > 0) {
            ExoCache descriptionCache;
            ExoCache navigationCache = this.cacheService.getAllCacheInstances().stream().filter(cache -> "portal.NavigationService".equals(cache.getName())).findFirst().orElse(null);
            if (navigationCache != null) {
                navigationCache.clearCache();
            }
            if ((descriptionCache = (ExoCache)this.cacheService.getAllCacheInstances().stream().filter(cache -> "portal.DescriptionService".equals(cache.getName())).findFirst().orElse(null)) != null) {
                descriptionCache.clearCache();
            }
        }
    }
}

