/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.thumbnail;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.thumbnail.ImageResizeService;
import org.imgscalr.Scalr;

public class ImageResizeServiceImpl
implements ImageResizeService {
    private static final Log LOG = ExoLogger.getLogger(ImageResizeServiceImpl.class);

    @Override
    public byte[] scaleImage(byte[] image, int width, int height, boolean fitExact, boolean ultraQuality) throws Exception {
        if (width == 0 && height == 0) {
            return image;
        }
        Scalr.Method resizeMethod = ultraQuality ? Scalr.Method.ULTRA_QUALITY : Scalr.Method.QUALITY;
        BufferedImage bufferedImage = this.toBufferedImage(image);
        if (bufferedImage == null) {
            return image;
        }
        int originWidth = bufferedImage.getWidth();
        int originHeight = bufferedImage.getHeight();
        if (width > originWidth || height > originHeight) {
            return image;
        }
        if (width == 0) {
            bufferedImage = Scalr.resize((BufferedImage)bufferedImage, (Scalr.Method)resizeMethod, (Scalr.Mode)Scalr.Mode.FIT_TO_HEIGHT, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
        } else if (height == 0) {
            bufferedImage = Scalr.resize((BufferedImage)bufferedImage, (Scalr.Method)resizeMethod, (Scalr.Mode)Scalr.Mode.FIT_TO_WIDTH, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
        } else if (fitExact) {
            bufferedImage = Scalr.resize((BufferedImage)bufferedImage, (Scalr.Method)resizeMethod, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
        } else {
            Scalr.Mode fitMode;
            float ratio = (float)originHeight / (float)originWidth;
            int calculatedTargetHeight = Math.round((float)width * ratio);
            Scalr.Mode mode = fitMode = width > height ? Scalr.Mode.FIT_TO_WIDTH : Scalr.Mode.FIT_TO_HEIGHT;
            if (calculatedTargetHeight < height) {
                fitMode = Scalr.Mode.FIT_TO_HEIGHT;
            }
            bufferedImage = Scalr.resize((BufferedImage)bufferedImage, (Scalr.Method)resizeMethod, (Scalr.Mode)fitMode, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
        }
        byte[] response = this.toByteArray(bufferedImage);
        if (response.length > image.length) {
            return image;
        }
        return response;
    }

    private BufferedImage toBufferedImage(byte[] imageBytes) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(imageBytes);
            return ImageIO.read(bis);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to read image", (Throwable)e);
            return null;
        }
    }

    private byte[] toByteArray(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

