/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.SkinURL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.URIWriter;
import org.exoplatform.web.url.MimeType;
import org.gatein.portal.controller.resource.ResourceRequestHandler;

class SimpleSkin
implements SkinConfig {
    private final String module;
    private final String name;
    private final String cssPath;
    private final String id;
    private final int priority;
    private final boolean filtered;
    private final List<String> additionalModules;
    private String type;

    public SimpleSkin(SkinService service, String module, String name, String cssPath) {
        this(service, module, name, cssPath, Integer.MAX_VALUE);
    }

    public SimpleSkin(SkinService service, String module, String name, String cssPath, int cssPriority) {
        this.module = module;
        this.name = name;
        this.cssPath = cssPath;
        this.id = module.replace('/', '_');
        this.priority = cssPriority;
        this.additionalModules = null;
        this.filtered = false;
    }

    public SimpleSkin(String module, String name, String cssPath, int cssPriority, List<String> additionalModules) {
        this.module = module;
        this.name = name;
        this.cssPath = cssPath;
        this.id = module.replace('/', '_');
        this.priority = cssPriority;
        this.additionalModules = additionalModules;
        this.filtered = false;
    }

    public SimpleSkin(String module, String name, String cssPath, int cssPriority, boolean filtered) {
        this.module = module;
        this.name = name;
        this.cssPath = cssPath;
        this.id = module.replace('/', '_');
        this.priority = cssPriority;
        this.additionalModules = null;
        this.filtered = filtered;
    }

    @Override
    public int getCSSPriority() {
        return this.priority;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getModule() {
        return this.module;
    }

    @Override
    public String getCSSPath() {
        return this.cssPath;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isFiltered() {
        return this.filtered;
    }

    @Override
    public List<String> getAdditionalModules() {
        return this.additionalModules;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "SimpleSkin[id=" + this.id + ",module=" + this.module + ",name=" + this.name + ",cssPath=" + this.cssPath + ", priority=" + this.priority + "]";
    }

    @Override
    public SkinURL createURL(final ControllerContext context) {
        if (context == null) {
            throw new NullPointerException("No controller context provided");
        }
        if (StringUtils.isBlank((CharSequence)this.cssPath)) {
            return null;
        }
        return new SkinURL(){
            Orientation orientation = null;
            boolean compress = !PropertyManager.isDevelopping();

            @Override
            public void setOrientation(Orientation orientation) {
                this.orientation = orientation;
            }

            @Override
            public String toString() {
                try {
                    String resource = SimpleSkin.this.cssPath.substring(1, SimpleSkin.this.cssPath.length() - ".css".length());
                    HashMap<QualifiedName, String> params = new HashMap<QualifiedName, String>();
                    params.put(ResourceRequestHandler.VERSION_QN, ResourceRequestHandler.VERSION);
                    params.put(ResourceRequestHandler.ORIENTATION_QN, this.orientation == Orientation.RT ? "rt" : "lt");
                    params.put(ResourceRequestHandler.COMPRESS_QN, this.compress ? "min" : "");
                    params.put(WebAppController.HANDLER_PARAM, "skin");
                    params.put(ResourceRequestHandler.RESOURCE_QN, resource);
                    StringBuilder url = new StringBuilder();
                    context.renderURL(params, new URIWriter((Appendable)url, MimeType.PLAIN));
                    return url.toString();
                }
                catch (IOException e) {
                    ExoLogger.getLogger(this.getClass()).error((Object)e.getMessage(), (Throwable)e);
                    return null;
                }
            }
        };
    }
}

