/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.oort.Oort;
import org.cometd.oort.OortContainer;
import org.cometd.oort.OortObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OortList<E>
extends OortContainer<List<E>> {
    private static final String TYPE_FIELD_ELEMENT_VALUE = "oort.list.element";
    private static final String ACTION_FIELD_ADD_VALUE = "oort.list.add";
    private static final String ACTION_FIELD_REMOVE_VALUE = "oort.list.remove";
    private final List<ElementListener<E>> listeners = new CopyOnWriteArrayList<ElementListener<E>>();
    private final Logger logger;

    public OortList(Oort oort, String name, OortObject.Factory<List<E>> factory) {
        super(oort, name, factory);
        this.logger = LoggerFactory.getLogger((String)Oort.loggerName(this.getClass(), oort.getURL(), name));
    }

    public void addElementListener(ElementListener<E> listener) {
        this.listeners.add(listener);
    }

    public void removeElementListener(ElementListener<E> listener) {
        this.listeners.remove(listener);
    }

    public void removeElementListeners() {
        this.listeners.clear();
    }

    public boolean contains(E element) {
        return ((List)this.getInfo(this.getOort().getURL()).getObject()).contains(element);
    }

    public boolean isPresent(E element) {
        for (OortObject.Info info : this) {
            if (!((List)info.getObject()).contains(element)) continue;
            return true;
        }
        return false;
    }

    public void addAndShare(OortObject.Result<Boolean> callback, E ... elements) {
        OortObject.Data<Boolean> data = new OortObject.Data<Boolean>(6, callback);
        data.put("oort.info.url", this.getOort().getURL());
        data.put("oort.info.name", this.getName());
        data.put("oort.info.object", elements);
        data.put("oort.info.type", TYPE_FIELD_ELEMENT_VALUE);
        data.put("oort.info.action", ACTION_FIELD_ADD_VALUE);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Sharing list add {}", data);
        }
        BayeuxServer bayeuxServer = this.getOort().getBayeuxServer();
        bayeuxServer.getChannel(this.getChannelName()).publish((Session)this.getLocalSession(), data, Promise.noop());
    }

    public void removeAndShare(OortObject.Result<Boolean> callback, E ... elements) {
        OortObject.Data<Boolean> data = new OortObject.Data<Boolean>(6, callback);
        data.put("oort.info.url", this.getOort().getURL());
        data.put("oort.info.name", this.getName());
        data.put("oort.info.object", elements);
        data.put("oort.info.type", TYPE_FIELD_ELEMENT_VALUE);
        data.put("oort.info.action", ACTION_FIELD_REMOVE_VALUE);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Sharing list remove {}", data);
        }
        BayeuxServer bayeuxServer = this.getOort().getBayeuxServer();
        bayeuxServer.getChannel(this.getChannelName()).publish((Session)this.getLocalSession(), data, Promise.noop());
    }

    @Override
    protected boolean isItemUpdate(Map<String, Object> data) {
        return TYPE_FIELD_ELEMENT_VALUE.equals(data.get("oort.info.type"));
    }

    @Override
    protected void onItem(OortObject.Info<List<E>> info, Map<String, Object> data) {
        boolean result;
        String action;
        List<Object> object = data.get("oort.info.object");
        if (object instanceof Object[]) {
            object = List.of((Object[])object);
        }
        List elements = object;
        List<E> list = info.getObject();
        switch (action = (String)data.get("oort.info.action")) {
            case "oort.list.add": {
                result = list.addAll(elements);
                break;
            }
            case "oort.list.remove": {
                result = list.removeAll(elements);
                break;
            }
            default: {
                throw new IllegalArgumentException(action);
            }
        }
        info.put("oort.info.version", data.get("oort.info.version"));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} list {} of {}", new Object[]{info.isLocal() ? "Local" : "Remote", action, elements});
        }
        switch (action) {
            case "oort.list.add": {
                this.notifyElementsAdded(info, elements);
                break;
            }
            case "oort.list.remove": {
                this.notifyElementsRemoved(info, elements);
            }
        }
        if (data instanceof OortObject.Data) {
            ((OortObject.Data)data).setResult(result);
        }
    }

    private void notifyElementsAdded(OortObject.Info<List<E>> info, List<E> elements) {
        for (ElementListener<E> listener : this.listeners) {
            try {
                listener.onAdded(info, elements);
            }
            catch (Throwable x) {
                this.logger.info("Exception while invoking listener " + listener, x);
            }
        }
    }

    private void notifyElementsRemoved(OortObject.Info<List<E>> info, List<E> elements) {
        for (ElementListener<E> listener : this.listeners) {
            try {
                listener.onRemoved(info, elements);
            }
            catch (Throwable x) {
                this.logger.info("Exception while invoking listener " + listener, x);
            }
        }
    }

    public static interface ElementListener<E>
    extends EventListener {
        default public void onAdded(OortObject.Info<List<E>> info, List<E> elements) {
        }

        default public void onRemoved(OortObject.Info<List<E>> info, List<E> elements) {
        }
    }

    public static class DeltaListener<E>
    implements OortObject.Listener<List<E>> {
        private final OortList<E> oortList;

        public DeltaListener(OortList<E> oortList) {
            this.oortList = oortList;
        }

        @Override
        public void onUpdated(OortObject.Info<List<E>> oldInfo, OortObject.Info<List<E>> newInfo) {
            List oldList = oldInfo == null ? List.of() : oldInfo.getObject();
            List<E> newList = newInfo.getObject();
            ArrayList<E> added = new ArrayList<E>(newList);
            added.removeAll(oldList);
            ArrayList removed = new ArrayList(oldList);
            removed.removeAll(newList);
            if (!added.isEmpty()) {
                this.oortList.notifyElementsAdded(newInfo, added);
            }
            if (!removed.isEmpty()) {
                this.oortList.notifyElementsRemoved(newInfo, removed);
            }
        }

        @Override
        public void onRemoved(OortObject.Info<List<E>> info) {
            this.oortList.notifyElementsRemoved(info, info.getObject());
        }
    }
}

