/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.init;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.StorageDBInitializer;

public class IngresSQLDBInitializer
extends StorageDBInitializer {
    public IngresSQLDBInitializer(Connection connection, JDBCDataContainerConfig containerConfig) throws IOException {
        super(connection, containerConfig);
    }

    @Override
    protected boolean isTableExists(Connection conn, String tableName) throws SQLException {
        return super.isTableExists(conn, tableName.toUpperCase().toLowerCase());
    }

    @Override
    protected boolean isSequenceExists(Connection conn, String sequenceName) throws SQLException {
        String seqName = sequenceName.toUpperCase().toLowerCase();
        ResultSet srs = null;
        Statement st = null;
        try {
            st = conn.createStatement();
            srs = st.executeQuery("SELECT NEXT VALUE FOR " + seqName);
            if (srs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            if (e.getMessage().indexOf("DEFINE CURSOR") >= 0 && e.getMessage().indexOf("Sequence") >= 0) {
                boolean bl = false;
                return bl;
            }
            throw new SQLException(e.getMessage()){

                @Override
                public Throwable getCause() {
                    return e;
                }
            };
        }
        finally {
            if (srs != null) {
                try {
                    srs.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e));
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the Statement: " + e));
                }
            }
        }
    }
}

