/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.meeds.social.cms.service.CMSService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.common.service.HTMLUploadImageProcessor;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.ImportList;
import org.exoplatform.wiki.model.NoteToExport;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageHistory;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.model.PermissionType;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.rendering.cache.AttachmentCountData;
import org.exoplatform.wiki.rendering.cache.MarkupData;
import org.exoplatform.wiki.rendering.cache.MarkupKey;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.BreadcrumbData;
import org.exoplatform.wiki.service.DataStorage;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.listener.PageWikiListener;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.SearchResultType;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.exoplatform.wiki.utils.Utils;
import org.gatein.api.EntityNotFoundException;

public class NoteServiceImpl
implements NoteService {
    public static final String CACHE_NAME = "wiki.PageRenderingCache";
    public static final String ATT_CACHE_NAME = "wiki.PageAttachmentCache";
    private static final String UNTITLED_PREFIX = "Untitled_";
    private static final String TEMP_DIRECTORY_PATH = "java.io.tmpdir";
    private static final Log log = ExoLogger.getLogger(NoteServiceImpl.class);
    private final WikiService wikiService;
    private final DataStorage dataStorage;
    private final ExoCache<Integer, MarkupData> renderingCache;
    private final ExoCache<Integer, AttachmentCountData> attachmentCountCache;
    private final Map<WikiPageParams, List<WikiPageParams>> pageLinksMap = new ConcurrentHashMap<WikiPageParams, List<WikiPageParams>>();
    private final IdentityManager identityManager;
    private final SpaceService spaceService;
    private final CMSService cmsService;
    private final IdentityRegistry identityRegistry;
    private final OrganizationService organizationService;
    private final ListenerService listenerService;
    private final HTMLUploadImageProcessor htmlUploadImageProcessor;

    public NoteServiceImpl(DataStorage dataStorage, CacheService cacheService, WikiService wikiService, IdentityManager identityManager, SpaceService spaceService, CMSService cmsService, IdentityRegistry identityRegistry, OrganizationService organizationService, ListenerService listenerService) {
        this.dataStorage = dataStorage;
        this.wikiService = wikiService;
        this.identityManager = identityManager;
        this.renderingCache = cacheService.getCacheInstance(CACHE_NAME);
        this.attachmentCountCache = cacheService.getCacheInstance(ATT_CACHE_NAME);
        this.spaceService = spaceService;
        this.listenerService = listenerService;
        this.cmsService = cmsService;
        this.identityRegistry = identityRegistry;
        this.organizationService = organizationService;
        this.htmlUploadImageProcessor = null;
    }

    public NoteServiceImpl(DataStorage dataStorage, CacheService cacheService, WikiService wikiService, IdentityManager identityManager, SpaceService spaceService, CMSService cmsService, IdentityRegistry identityRegistry, OrganizationService organizationService, ListenerService listenerService, HTMLUploadImageProcessor htmlUploadImageProcessor) {
        this.dataStorage = dataStorage;
        this.wikiService = wikiService;
        this.identityManager = identityManager;
        this.renderingCache = cacheService.getCacheInstance(CACHE_NAME);
        this.attachmentCountCache = cacheService.getCacheInstance(ATT_CACHE_NAME);
        this.spaceService = spaceService;
        this.listenerService = listenerService;
        this.cmsService = cmsService;
        this.identityRegistry = identityRegistry;
        this.organizationService = organizationService;
        this.htmlUploadImageProcessor = htmlUploadImageProcessor;
    }

    public static File zipFiles(String zipFileName, List<File> addToZip) throws IOException {
        String zipPath = System.getProperty(TEMP_DIRECTORY_PATH) + File.separator + zipFileName;
        NoteServiceImpl.cleanUp(new File(zipPath));
        try (FileOutputStream fos = new FileOutputStream(zipPath);
             ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(fos));){
            zos.setLevel(9);
            for (File file : addToZip) {
                if (!file.exists()) continue;
                try (FileInputStream fis = new FileInputStream(file);){
                    ZipEntry entry = new ZipEntry(file.getName());
                    zos.putNextEntry(entry);
                    int c = fis.read();
                    while (c != -1) {
                        zos.write(c);
                        c = fis.read();
                    }
                    zos.flush();
                }
            }
        }
        File zip = new File(zipPath);
        if (!zip.exists()) {
            throw new FileNotFoundException("The created zip file could not be found");
        }
        return zip;
    }

    public ExoCache<Integer, MarkupData> getRenderingCache() {
        return this.renderingCache;
    }

    public Map<WikiPageParams, List<WikiPageParams>> getPageLinksMap() {
        return this.pageLinksMap;
    }

    @Override
    public Page createNote(Wiki noteBook, String parentNoteName, Page note, Identity userIdentity) throws WikiException, IllegalAccessException {
        String pageName = TitleResolver.getId(note.getTitle(), false);
        note.setName(pageName);
        if (this.isExisting(noteBook.getType(), noteBook.getOwner(), pageName)) {
            throw new WikiException("Page " + noteBook.getType() + ":" + noteBook.getOwner() + ":" + pageName + " already exists, cannot create it.");
        }
        Page parentPage = this.getNoteOfNoteBookByName(noteBook.getType(), noteBook.getOwner(), parentNoteName);
        if (parentPage != null) {
            note.setOwner(userIdentity.getUserId());
            note.setAuthor(userIdentity.getUserId());
            note.setContent(note.getContent());
            Page createdPage = this.createNote(noteBook, parentPage, note);
            Space space = this.spaceService.getSpaceByGroupId(note.getWikiOwner());
            createdPage.setCanManage(this.canManageNotes(note.getAuthor(), space, note));
            createdPage.setCanImport(this.canImportNotes(note.getAuthor(), space, note));
            createdPage.setCanView(this.canViewNotes(note.getAuthor(), space, note));
            return createdPage;
        }
        throw new EntityNotFoundException("Parent note not foond");
    }

    @Override
    public Page createNote(Wiki noteBook, Page parentPage, Page note) throws WikiException {
        Page createdPage = this.dataStorage.createPage(noteBook, parentPage, note);
        createdPage.setToBePublished(note.isToBePublished());
        createdPage.setToBePublished(note.isToBePublished());
        createdPage.setAppName(note.getAppName());
        createdPage.setUrl(Utils.getPageUrl(createdPage));
        createdPage.setLang(note.getLang());
        this.invalidateCache(parentPage);
        this.invalidateCache(note);
        Utils.broadcast(this.listenerService, "note.posted", note.getAuthor(), createdPage);
        this.postAddPage(noteBook.getType(), noteBook.getOwner(), note.getName(), createdPage);
        return createdPage;
    }

    @Override
    public Page updateNote(Page note) throws WikiException {
        return this.updateNote(note, null);
    }

    @Override
    public Page updateNote(Page note, PageUpdateType type, Identity userIdentity) throws WikiException, IllegalAccessException, EntityNotFoundException {
        Page existingNote = this.getNoteById(note.getId());
        if (existingNote == null) {
            throw new EntityNotFoundException("Note to update not found");
        }
        Space space = this.spaceService.getSpaceByGroupId(note.getWikiOwner());
        if (userIdentity != null && !this.canManageNotes(userIdentity.getUserId(), space, existingNote)) {
            throw new IllegalAccessException("User does not have edit the note.");
        }
        if (PageUpdateType.EDIT_PAGE_CONTENT.equals((Object)type) || PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE.equals((Object)type)) {
            note.setUpdatedDate(Calendar.getInstance().getTime());
        }
        note.setContent(note.getContent());
        Page updatedPage = this.dataStorage.updatePage(note);
        this.invalidateCache(note);
        updatedPage.setUrl(Utils.getPageUrl(updatedPage));
        updatedPage.setToBePublished(note.isToBePublished());
        updatedPage.setCanManage(note.isCanManage());
        updatedPage.setCanImport(note.isCanImport());
        updatedPage.setCanView(note.isCanView());
        updatedPage.setAppName(note.getAppName());
        if (userIdentity != null) {
            Map<String, List<MetadataItem>> metadata = this.retrieveMetadataItems(note.getId(), userIdentity.getUserId());
            updatedPage.setMetadatas(metadata);
            note.setAuthor(userIdentity.getUserId());
        }
        Utils.broadcast(this.listenerService, "note.updated", note.getAuthor(), updatedPage);
        this.postUpdatePage(updatedPage.getWikiType(), updatedPage.getWikiOwner(), updatedPage.getName(), updatedPage, type);
        return updatedPage;
    }

    @Override
    public Page updateNote(Page note, PageUpdateType type) throws WikiException {
        return this.updateNote(note, type, null);
    }

    @Override
    public boolean deleteNote(String noteType, String noteOwner, String noteName) throws WikiException {
        if ("Home".equals(noteName) || noteName == null) {
            return false;
        }
        try {
            this.dataStorage.deletePage(noteType, noteOwner, noteName);
        }
        catch (WikiException e) {
            log.error((Object)("Can't delete note '" + noteName + "' "), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteNote(String noteType, String noteOwner, String noteName, Identity userIdentity) throws WikiException, IllegalAccessException, EntityNotFoundException {
        block9: {
            if ("Home".equals(noteName) || noteName == null) {
                return false;
            }
            try {
                Page note = this.getNoteOfNoteBookByName(noteType, noteOwner, noteName);
                if (note == null) {
                    log.error((Object)("Can't delete note '" + noteName + "'. This note does not exist."));
                    throw new EntityNotFoundException("Note to delete not found");
                }
                Space space = this.spaceService.getSpaceByGroupId(note.getWikiOwner());
                if (note != null) {
                    if (!this.canManageNotes(userIdentity.getUserId(), space, note)) {
                        log.error((Object)("Can't delete note '" + noteName + "'. does not have edit permission on it."));
                        throw new IllegalAccessException("User does not have edit permissions on the note.");
                    }
                    this.invalidateCachesOfPageTree(note, userIdentity.getUserId());
                    this.invalidateAttachmentCache(note);
                    ArrayList<Page> allChrildrenPages = new ArrayList<Page>();
                    LinkedList<Page> queue = new LinkedList<Page>();
                    queue.add(note);
                    while (!queue.isEmpty()) {
                        Page tempPage = (Page)queue.poll();
                        List<Page> childrenPages = this.getChildrenNoteOf(tempPage, userIdentity.getUserId(), false, false);
                        for (Page childPage : childrenPages) {
                            queue.add(childPage);
                            allChrildrenPages.add(childPage);
                        }
                    }
                    this.deleteNote(noteType, noteOwner, noteName);
                    this.postDeletePage(noteType, noteOwner, noteName, note);
                    for (Page childNote : allChrildrenPages) {
                        this.postDeletePage(childNote.getWikiType(), childNote.getWikiOwner(), childNote.getName(), childNote);
                    }
                    break block9;
                }
                log.error((Object)("Can't delete note '" + noteName + "'. This note does not exist."));
                return false;
            }
            catch (WikiException e) {
                log.error((Object)("Can't delete note '" + noteName + "' "), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean renameNote(String noteType, String noteOwner, String noteName, String newName, String newTitle) throws WikiException {
        if ("Home".equals(noteName) || noteName == null) {
            return false;
        }
        if (!noteName.equals(newName) && this.isExisting(noteType, noteOwner, newName)) {
            throw new WikiException("Note " + noteType + ":" + noteOwner + ":" + newName + " already exists, cannot rename it.");
        }
        this.dataStorage.renamePage(noteType, noteOwner, noteName, newName, newTitle);
        Page page = new Page(noteName);
        page.setWikiType(noteType);
        page.setWikiOwner(noteOwner);
        this.invalidateCache(page);
        return true;
    }

    @Override
    public void moveNote(WikiPageParams currentLocationParams, WikiPageParams newLocationParams) throws WikiException {
        this.dataStorage.movePage(currentLocationParams, newLocationParams);
    }

    @Override
    public boolean moveNote(WikiPageParams currentLocationParams, WikiPageParams newLocationParams, Identity userIdentity) throws WikiException, IllegalAccessException, EntityNotFoundException {
        try {
            Page moveNote = this.getNoteOfNoteBookByName(currentLocationParams.getType(), currentLocationParams.getOwner(), currentLocationParams.getPageName());
            if (moveNote == null) {
                throw new EntityNotFoundException("Note to move not found");
            }
            if (moveNote != null) {
                Space space = this.spaceService.getSpaceByGroupId(moveNote.getWikiOwner());
                if (!this.canManageNotes(userIdentity.getUserId(), space, moveNote)) {
                    throw new IllegalAccessException("User does not have edit the note.");
                }
            }
            this.moveNote(currentLocationParams, newLocationParams);
            Page note = new Page(currentLocationParams.getPageName());
            note.setWikiType(currentLocationParams.getType());
            note.setWikiOwner(currentLocationParams.getOwner());
            this.invalidateCache(note);
            this.invalidateAttachmentCache(note);
            this.postUpdatePage(newLocationParams.getType(), newLocationParams.getOwner(), moveNote.getName(), moveNote, PageUpdateType.MOVE_PAGE);
        }
        catch (WikiException e) {
            log.error((Object)("Can't move note '" + currentLocationParams.getPageName() + "' "), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public Page getNoteOfNoteBookByName(String noteType, String noteOwner, String noteName) throws WikiException {
        Page page = null;
        page = this.dataStorage.getPageOfWikiByName(noteType, noteOwner, noteName);
        this.checkToRemoveDomainInUrl(page);
        return page;
    }

    @Override
    public Page getNoteOfNoteBookByName(String noteType, String noteOwner, String noteName, Identity userIdentity, String source) throws IllegalAccessException, WikiException {
        Page page = this.getNoteOfNoteBookByName(noteType, noteOwner, noteName, userIdentity);
        if (StringUtils.isNotEmpty((String)source)) {
            if (source.equals("tree")) {
                this.postOpenByTree(noteType, noteOwner, noteName, page);
            }
            if (source.equals("breadCrumb")) {
                this.postOpenByBreadCrumb(noteType, noteOwner, noteName, page);
            }
        }
        return page;
    }

    @Override
    public Page getNoteOfNoteBookByName(String noteType, String noteOwner, String noteName, String lang, Identity userIdentity) throws WikiException, IllegalAccessException {
        Page page = this.getNoteOfNoteBookByName(noteType, noteOwner, noteName, userIdentity);
        if (lang != null) {
            page.setMetadatas(this.retrieveMetadataItems(page.getId() + "-" + lang, userIdentity.getUserId()));
        }
        return page;
    }

    @Override
    public Page getNoteOfNoteBookByName(String noteType, String noteOwner, String noteName, Identity userIdentity) throws IllegalAccessException, WikiException {
        Page page = null;
        page = this.getNoteOfNoteBookByName(noteType, noteOwner, noteName);
        if (page == null) {
            throw new EntityNotFoundException("page not found");
        }
        if (page != null) {
            Space space = this.spaceService.getSpaceByGroupId(page.getWikiOwner());
            if (!this.canViewNotes(userIdentity.getUserId(), space, page)) {
                throw new IllegalAccessException("User does not have view the note.");
            }
            page.setCanView(true);
            page.setCanManage(this.canManageNotes(userIdentity.getUserId(), space, page));
            page.setCanImport(this.canImportNotes(userIdentity.getUserId(), space, page));
            Map<String, List<MetadataItem>> metadata = this.retrieveMetadataItems(page.getId(), userIdentity.getUserId());
            page.setMetadatas(metadata);
        }
        return page;
    }

    @Override
    public Page getNoteById(String id) throws WikiException {
        if (id == null) {
            return null;
        }
        return this.dataStorage.getPageById(id);
    }

    @Override
    public DraftPage getDraftNoteById(String id, String userId) throws WikiException, IllegalAccessException {
        if (id == null) {
            return null;
        }
        DraftPage draftPage = this.dataStorage.getDraftPageById(id);
        this.computeDraftProps(draftPage, userId);
        return draftPage;
    }

    private void computeDraftProps(DraftPage draftPage, String userId) throws WikiException, IllegalAccessException {
        if (draftPage != null) {
            Space space = this.spaceService.getSpaceByGroupId(draftPage.getWikiOwner());
            if (!this.canViewNotes(userId, space, draftPage)) {
                throw new IllegalAccessException("User does not have the right view the note.");
            }
            draftPage.setCanView(true);
            draftPage.setCanManage(this.canManageNotes(userId, space, draftPage));
            draftPage.setCanImport(this.canImportNotes(userId, space, draftPage));
            String authorFullName = this.identityManager.getOrCreateIdentity("organization", draftPage.getAuthor()).getProfile().getFullName();
            draftPage.setAuthorFullName(authorFullName);
        }
    }

    @Override
    public DraftPage getLatestDraftOfPage(Page targetPage, String username) throws WikiException {
        if (targetPage == null || StringUtils.isEmpty((String)username)) {
            return null;
        }
        return this.dataStorage.getLatestDraftOfPage(targetPage, username);
    }

    @Override
    public Page getNoteById(String id, Identity userIdentity) throws IllegalAccessException, WikiException {
        if (id == null) {
            return null;
        }
        Page page = null;
        page = this.getNoteById(id);
        if (page != null) {
            Space space = this.spaceService.getSpaceByGroupId(page.getWikiOwner());
            if (!this.canViewNotes(userIdentity.getUserId(), space, page)) {
                throw new IllegalAccessException("User does not have view the note.");
            }
            page.setCanView(true);
            page.setCanManage(this.canManageNotes(userIdentity.getUserId(), space, page));
            page.setCanImport(this.canImportNotes(userIdentity.getUserId(), space, page));
        }
        return page;
    }

    @Override
    public Page getNoteById(String id, Identity userIdentity, String source) throws IllegalAccessException, WikiException {
        if (id == null) {
            return null;
        }
        Page page = this.getNoteById(id);
        if (page != null) {
            Space space = this.spaceService.getSpaceByGroupId(page.getWikiOwner());
            if (!this.canViewNotes(userIdentity.getUserId(), space, page)) {
                throw new IllegalAccessException("User does not have view the note.");
            }
            page.setCanView(true);
            page.setUrl(Utils.getPageUrl(page));
            page.setCanManage(this.canManageNotes(userIdentity.getUserId(), space, page));
            page.setCanImport(this.canImportNotes(userIdentity.getUserId(), space, page));
            Map<String, List<MetadataItem>> metadata = this.retrieveMetadataItems(id, userIdentity.getUserId());
            page.setMetadatas(metadata);
            if (StringUtils.isNotBlank((String)source)) {
                if (source.equals("tree")) {
                    this.postOpenByTree(page.getWikiType(), page.getWikiOwner(), page.getName(), page);
                }
                if (source.equals("breadCrumb")) {
                    this.postOpenByBreadCrumb(page.getWikiType(), page.getWikiOwner(), page.getName(), page);
                }
            }
        }
        return page;
    }

    @Override
    public Page getParentNoteOf(Page note) throws WikiException {
        return this.dataStorage.getParentPageOf(note);
    }

    @Override
    public NoteToExport getParentNoteOf(NoteToExport note) throws WikiException {
        Page page = new Page();
        page.setId(note.getId());
        page.setName(note.getName());
        page.setWikiId(note.getWikiId());
        page.setWikiOwner(note.getWikiOwner());
        page.setWikiType(note.getWikiType());
        Page parent = this.getParentNoteOf(page);
        if (parent == null) {
            return null;
        }
        return new NoteToExport(parent.getId(), parent.getName(), parent.getOwner(), parent.getAuthor(), parent.getContent(), parent.getSyntax(), parent.getTitle(), parent.getComment(), parent.getWikiId(), parent.getWikiType(), parent.getWikiOwner());
    }

    @Override
    public List<Page> getChildrenNoteOf(Page note, String userId, boolean withDrafts, boolean withChild) throws WikiException {
        List<Page> pages = this.dataStorage.getChildrenPageOf(note, userId, withDrafts);
        if (withChild) {
            for (Page page : pages) {
                long pageId = Long.parseLong(page.getId());
                page.setHasChild(this.dataStorage.hasChildren(pageId));
            }
        }
        return pages;
    }

    @Override
    public List<NoteToExport> getChildrenNoteOf(NoteToExport note, String userId) throws WikiException {
        Page page = new Page();
        page.setId(note.getId());
        page.setName(note.getName());
        page.setWikiId(note.getWikiId());
        page.setWikiOwner(note.getWikiOwner());
        page.setWikiType(note.getWikiType());
        List<Page> pages = this.getChildrenNoteOf(page, userId, false, false);
        ArrayList<NoteToExport> children = new ArrayList<NoteToExport>();
        for (Page child : pages) {
            if (child == null) continue;
            children.add(new NoteToExport(child.getId(), child.getName(), child.getOwner(), child.getAuthor(), child.getContent(), child.getSyntax(), child.getTitle(), child.getComment(), child.getWikiId(), child.getWikiType(), child.getWikiOwner()));
        }
        return children;
    }

    @Override
    public List<BreadcrumbData> getBreadCrumb(String noteType, String noteOwner, String noteName, boolean isDraftNote) throws WikiException, IllegalAccessException {
        return this.getBreadCrumb(null, noteType, noteOwner, noteName, null, null, isDraftNote);
    }

    @Override
    public List<BreadcrumbData> getBreadCrumb(String noteType, String noteOwner, String noteName, String lang, Identity userIdentity, boolean isDraftNote) throws WikiException, IllegalAccessException {
        return this.getBreadCrumb(null, noteType, noteOwner, noteName, lang, userIdentity, isDraftNote);
    }

    @Override
    public List<Page> getDuplicateNotes(Page parentNote, Wiki targetNoteBook, List<Page> resultList, String userId) throws WikiException {
        if (resultList == null) {
            resultList = new ArrayList<Page>();
        }
        if (resultList.size() > 6) {
            return resultList;
        }
        if (this.isExisting(targetNoteBook.getType(), targetNoteBook.getOwner(), parentNote.getName())) {
            resultList.add(parentNote);
        }
        List<Page> childrenNotes = this.getChildrenNoteOf(parentNote, userId, false, false);
        for (Page note : childrenNotes) {
            this.getDuplicateNotes(note, targetNoteBook, resultList, userId);
        }
        return resultList;
    }

    @Override
    public void removeDraftOfNote(WikiPageParams param) throws WikiException {
        Page page = this.getNoteOfNoteBookByName(param.getType(), param.getOwner(), param.getPageName());
        this.removeDraftOfNote(page, Utils.getCurrentUser());
    }

    @Override
    public void removeDraftOfNote(Page page, String username) throws WikiException {
        this.dataStorage.deleteDraftOfPage(page, username);
    }

    @Override
    public void removeDraftOfNote(WikiPageParams param, String lang) throws WikiException {
        Page page = this.getNoteOfNoteBookByName(param.getType(), param.getOwner(), param.getPageName());
        this.dataStorage.deleteDraftOfPage(page, Utils.getCurrentUser(), lang);
    }

    @Override
    public void removeDraft(String draftName) throws WikiException {
        this.dataStorage.deleteDraftByName(draftName, Utils.getCurrentUser());
    }

    @Override
    public List<PageHistory> getVersionsHistoryOfNote(Page note, String userName) throws WikiException {
        List<PageHistory> versionsHistory = this.dataStorage.getHistoryOfPage(note);
        if (versionsHistory == null || versionsHistory.isEmpty()) {
            this.dataStorage.addPageVersion(note, userName);
            versionsHistory = this.dataStorage.getHistoryOfPage(note);
        }
        for (PageHistory version : versionsHistory) {
            if (version.getAuthor() == null) continue;
            org.exoplatform.social.core.identity.model.Identity authorIdentity = this.identityManager.getOrCreateIdentity("organization", version.getAuthor());
            version.setAuthorFullName(authorIdentity.getProfile().getFullName());
        }
        return versionsHistory;
    }

    @Override
    public void createVersionOfNote(Page note, String userName) throws WikiException {
        this.dataStorage.addPageVersion(note, userName);
        if (note.getLang() != null) {
            String versionLandId = note.getId() + "-" + note.getLang();
            this.postUpdatePageVersionLanguage(versionLandId);
        }
    }

    @Override
    public void restoreVersionOfNote(String versionName, Page note, String userName) throws WikiException {
        this.dataStorage.restoreVersionOfPage(versionName, note);
        this.createVersionOfNote(note, userName);
        this.invalidateCache(note);
    }

    @Override
    public List<String> getPreviousNamesOfNote(Page note) throws WikiException {
        return this.dataStorage.getPreviousNamesOfPage(note);
    }

    @Override
    public List<Page> getNotesOfWiki(String noteType, String noteOwner) {
        return this.dataStorage.getPagesOfWiki(noteType, noteOwner);
    }

    @Override
    public boolean isExisting(String noteBookType, String noteBookOwner, String noteId) throws WikiException {
        return this.getNoteByRootPermission(noteBookType, noteBookOwner, noteId) != null;
    }

    @Override
    public DraftPage updateDraftForExistPage(DraftPage draftNoteToUpdate, Page targetPage, String revision, long clientTime, String username) throws WikiException {
        String draftSuffix = this.getDraftNameSuffix(clientTime);
        DraftPage newDraftPage = new DraftPage();
        newDraftPage.setId(draftNoteToUpdate.getId());
        newDraftPage.setName(targetPage.getName() + "_" + draftSuffix);
        newDraftPage.setNewPage(false);
        newDraftPage.setTitle(draftNoteToUpdate.getTitle());
        newDraftPage.setTargetPageId(draftNoteToUpdate.getTargetPageId());
        newDraftPage.setParentPageId(draftNoteToUpdate.getParentPageId());
        newDraftPage.setContent(draftNoteToUpdate.getContent());
        newDraftPage.setLang(draftNoteToUpdate.getLang());
        newDraftPage.setSyntax(draftNoteToUpdate.getSyntax());
        newDraftPage.setCreatedDate(new Date(clientTime));
        newDraftPage.setUpdatedDate(new Date(clientTime));
        if (StringUtils.isEmpty((String)revision)) {
            List<PageHistory> versions = this.getVersionsHistoryOfNote(targetPage, username);
            if (versions != null && !versions.isEmpty()) {
                newDraftPage.setTargetPageRevision(String.valueOf(versions.get(0).getVersionNumber()));
            } else {
                newDraftPage.setTargetPageRevision("1");
            }
        } else {
            newDraftPage.setTargetPageRevision(revision);
        }
        newDraftPage = this.dataStorage.updateDraftPageForUser(newDraftPage, Utils.getCurrentUser());
        return newDraftPage;
    }

    @Override
    public DraftPage updateDraftForNewPage(DraftPage draftNoteToUpdate, long clientTime) throws WikiException {
        String draftSuffix = this.getDraftNameSuffix(clientTime);
        DraftPage newDraftPage = new DraftPage();
        newDraftPage.setId(draftNoteToUpdate.getId());
        newDraftPage.setName(UNTITLED_PREFIX + draftSuffix);
        newDraftPage.setNewPage(true);
        newDraftPage.setTitle(draftNoteToUpdate.getTitle());
        newDraftPage.setTargetPageId(draftNoteToUpdate.getTargetPageId());
        newDraftPage.setParentPageId(draftNoteToUpdate.getParentPageId());
        newDraftPage.setTargetPageRevision("1");
        newDraftPage.setContent(draftNoteToUpdate.getContent());
        newDraftPage.setLang(draftNoteToUpdate.getLang());
        newDraftPage.setSyntax(draftNoteToUpdate.getSyntax());
        newDraftPage.setCreatedDate(new Date(clientTime));
        newDraftPage.setUpdatedDate(new Date(clientTime));
        newDraftPage = this.dataStorage.updateDraftPageForUser(newDraftPage, Utils.getCurrentUser());
        return newDraftPage;
    }

    @Override
    public DraftPage createDraftForExistPage(DraftPage draftPage, Page targetPage, String revision, long clientTime, String username) throws WikiException {
        String draftSuffix = this.getDraftNameSuffix(clientTime);
        DraftPage newDraftPage = new DraftPage();
        newDraftPage.setName(targetPage.getName() + "_" + draftSuffix);
        newDraftPage.setNewPage(false);
        newDraftPage.setTitle(draftPage.getTitle());
        newDraftPage.setTargetPageId(targetPage.getId());
        newDraftPage.setParentPageId(draftPage.getParentPageId());
        newDraftPage.setContent(draftPage.getContent());
        newDraftPage.setLang(draftPage.getLang());
        newDraftPage.setSyntax(draftPage.getSyntax());
        newDraftPage.setCreatedDate(new Date(clientTime));
        newDraftPage.setUpdatedDate(new Date(clientTime));
        if (StringUtils.isEmpty((String)revision)) {
            List<PageHistory> versions = this.getVersionsHistoryOfNote(targetPage, username);
            if (versions != null && !versions.isEmpty()) {
                newDraftPage.setTargetPageRevision(String.valueOf(versions.get(0).getVersionNumber()));
            } else {
                newDraftPage.setTargetPageRevision("1");
            }
        } else {
            newDraftPage.setTargetPageRevision(revision);
        }
        newDraftPage = this.dataStorage.createDraftPageForUser(newDraftPage, username);
        return newDraftPage;
    }

    @Override
    public DraftPage createDraftForNewPage(DraftPage draftPage, long clientTime) throws WikiException {
        String draftSuffix = this.getDraftNameSuffix(clientTime);
        DraftPage newDraftPage = new DraftPage();
        newDraftPage.setName(UNTITLED_PREFIX + draftSuffix);
        newDraftPage.setNewPage(true);
        newDraftPage.setTitle(draftPage.getTitle());
        newDraftPage.setTargetPageId(draftPage.getTargetPageId());
        newDraftPage.setTargetPageRevision("1");
        newDraftPage.setParentPageId(draftPage.getParentPageId());
        newDraftPage.setContent(draftPage.getContent());
        newDraftPage.setLang(draftPage.getLang());
        newDraftPage.setSyntax(draftPage.getSyntax());
        newDraftPage.setCreatedDate(new Date(clientTime));
        newDraftPage.setUpdatedDate(new Date(clientTime));
        newDraftPage = this.dataStorage.createDraftPageForUser(newDraftPage, Utils.getCurrentUser());
        return newDraftPage;
    }

    protected void invalidateCache(Page page) {
        WikiPageParams params = new WikiPageParams(page.getWikiType(), page.getWikiOwner(), page.getName());
        List<WikiPageParams> linkedPages = this.pageLinksMap.get(params);
        linkedPages = linkedPages == null ? new ArrayList<WikiPageParams>() : new ArrayList<WikiPageParams>(linkedPages);
        linkedPages.add(params);
        for (WikiPageParams wikiPageParams : linkedPages) {
            try {
                MarkupKey key = new MarkupKey(wikiPageParams, false);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key = new MarkupKey(wikiPageParams, false);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key = new MarkupKey(wikiPageParams, false);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
            }
            catch (Exception e) {
                log.warn((Object)String.format("Failed to invalidate cache of page [%s:%s:%s]", wikiPageParams.getType(), wikiPageParams.getOwner(), wikiPageParams.getPageName()));
            }
        }
    }

    protected void invalidateCachesOfPageTree(Page note, String userId) throws WikiException {
        LinkedList<Page> queue = new LinkedList<Page>();
        queue.add(note);
        while (!queue.isEmpty()) {
            Page currentPage = (Page)queue.poll();
            this.invalidateCache(currentPage);
            List<Page> childrenPages = this.getChildrenNoteOf(currentPage, userId, false, false);
            for (Page child : childrenPages) {
                queue.add(child);
            }
        }
    }

    protected void invalidateAttachmentCache(Page note) {
        WikiPageParams wikiPageParams = new WikiPageParams(note.getWikiType(), note.getWikiOwner(), note.getName());
        List<WikiPageParams> linkedPages = this.pageLinksMap.get(wikiPageParams);
        linkedPages = linkedPages == null ? new ArrayList<WikiPageParams>() : new ArrayList<WikiPageParams>(linkedPages);
        linkedPages.add(wikiPageParams);
        for (WikiPageParams linkedWikiPageParams : linkedPages) {
            try {
                MarkupKey key = new MarkupKey(linkedWikiPageParams, false);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
                key = new MarkupKey(linkedWikiPageParams, false);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
            }
            catch (Exception e) {
                log.warn((Object)String.format("Failed to invalidate cache of note [%s:%s:%s]", linkedWikiPageParams.getType(), linkedWikiPageParams.getOwner(), linkedWikiPageParams.getPageName()));
            }
        }
    }

    public void postUpdatePageVersionLanguage(String versionPageId) {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            l.postUpdatePageVersion(versionPageId);
        }
    }

    public void postDeletePageVersionLanguage(String versionPageId) {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            l.postDeletePageVersion(versionPageId);
        }
    }

    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page, PageUpdateType wikiUpdateType) throws WikiException {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postUpdatePage(wikiType, wikiOwner, pageId, page, wikiUpdateType);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postAddPage(wikiType, wikiOwner, pageId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    public void postDeletePage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postDeletePage(wikiType, wikiOwner, pageId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    public void postOpenByTree(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postgetPagefromTree(wikiType, wikiOwner, pageId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    public void postOpenByBreadCrumb(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postgetPagefromBreadCrumb(wikiType, wikiOwner, pageId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    private void checkToRemoveDomainInUrl(Page note) {
        block4: {
            if (note == null) {
                return;
            }
            String url = note.getUrl();
            if (url != null && url.contains("://")) {
                try {
                    URL oldURL = new URL(url);
                    note.setUrl(oldURL.getPath());
                }
                catch (MalformedURLException ex) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)("Malformed url " + url), (Throwable)ex);
                }
            }
        }
    }

    private boolean canManageNotes(String authenticatedUser, Space space, Page page) throws WikiException {
        if (space != null) {
            return this.spaceService.isSuperManager(authenticatedUser) || this.spaceService.isManager(space, authenticatedUser) || this.spaceService.isRedactor(space, authenticatedUser) || this.spaceService.isMember(space, authenticatedUser) && ArrayUtils.isEmpty((Object[])space.getRedactors());
        }
        if (StringUtils.equals((String)page.getOwner(), (String)IdentityConstants.SYSTEM)) {
            return this.cmsService.hasEditPermission(this.getIdentity(authenticatedUser), "notePage", page.getName());
        }
        return StringUtils.equals((String)page.getOwner(), (String)authenticatedUser);
    }

    private boolean canImportNotes(String authenticatedUser, Space space, Page page) throws WikiException {
        if (space != null) {
            return this.spaceService.isSuperManager(authenticatedUser) || this.spaceService.isManager(space, authenticatedUser) || this.spaceService.isRedactor(space, authenticatedUser);
        }
        if (StringUtils.equals((String)page.getOwner(), (String)IdentityConstants.SYSTEM)) {
            return this.cmsService.hasAccessPermission(this.getIdentity(authenticatedUser), "notePage", page.getName());
        }
        return StringUtils.equals((String)page.getOwner(), (String)authenticatedUser);
    }

    private boolean canViewNotes(String authenticatedUser, Space space, Page page) throws WikiException {
        if (space != null) {
            return this.spaceService.isMember(space, authenticatedUser);
        }
        if (StringUtils.equals((String)page.getOwner(), (String)IdentityConstants.SYSTEM) || StringUtils.isBlank((String)page.getOwner())) {
            return this.cmsService.hasAccessPermission(this.getIdentity(authenticatedUser), "notePage", page.getName());
        }
        return this.spaceService.isSuperManager(authenticatedUser) || StringUtils.equals((String)page.getOwner(), (String)authenticatedUser);
    }

    @Override
    public boolean hasPermissionOnPage(Page page, PermissionType permissionType, Identity user) throws WikiException {
        if (StringUtils.equals((String)IdentityConstants.SYSTEM, (String)page.getOwner())) {
            return false;
        }
        if (page.isDraftPage()) {
            return page.getAuthor().equals(user.getUserId());
        }
        return this.dataStorage.hasPermissionOnPage(page, permissionType, user);
    }

    private List<BreadcrumbData> getBreadCrumb(List<BreadcrumbData> list, String noteType, String noteOwner, String noteName, String lang, Identity userIdentity, boolean isDraftNote) throws WikiException, IllegalAccessException {
        Page parentNote;
        Page note;
        if (list == null) {
            list = new ArrayList<BreadcrumbData>(5);
        }
        if (noteName == null) {
            return list;
        }
        Page page = note = isDraftNote ? this.dataStorage.getDraftPageById(noteName) : this.getNoteOfNoteBookByName(noteType, noteOwner, noteName);
        if (note == null) {
            return list;
        }
        list.add(0, new BreadcrumbData(note.getName(), note.getId(), this.getNoteTitleWithTraduction(note, userIdentity, "", lang), noteType, noteOwner));
        Page page2 = parentNote = isDraftNote ? this.getNoteById(note.getParentPageId()) : this.getParentNoteOf(note);
        if (parentNote != null) {
            this.getBreadCrumb(list, noteType, noteOwner, parentNote.getName(), lang, userIdentity, false);
        }
        return list;
    }

    String getNoteTitleWithTraduction(Page note, Identity userIdentity, String source, String lang) throws WikiException, IllegalAccessException {
        if (userIdentity == null || StringUtils.isEmpty((String)lang)) {
            return note.getTitle();
        }
        Page page = this.getNoteByIdAndLang(Long.valueOf(note.getId()), userIdentity, source, lang);
        if (page != null) {
            return page.getTitle();
        }
        return note.getTitle();
    }

    private LinkedList<String> getNoteAncestorsIds(String noteId) throws WikiException {
        return this.getNoteAncestorsIds(null, noteId);
    }

    private LinkedList<String> getNoteAncestorsIds(LinkedList<String> ancestorsIds, String noteId) throws WikiException {
        if (ancestorsIds == null) {
            ancestorsIds = new LinkedList();
        }
        if (noteId == null) {
            return ancestorsIds;
        }
        Page note = this.getNoteById(noteId);
        String parentId = note.getParentPageId();
        if (parentId != null) {
            ancestorsIds.push(parentId);
            this.getNoteAncestorsIds(ancestorsIds, parentId);
        }
        return ancestorsIds;
    }

    private String getDraftNameSuffix(long clientTime) {
        return new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date(clientTime));
    }

    @Override
    public Page getNoteByRootPermission(String wikiType, String wikiOwner, String pageId) throws WikiException {
        return this.dataStorage.getPageOfWikiByName(wikiType, wikiOwner, pageId);
    }

    @Override
    public String getNoteRenderedContent(Page note) {
        String renderedContent = "";
        try {
            MarkupKey key = new MarkupKey(new WikiPageParams(note.getWikiType(), note.getWikiOwner(), note.getName()), false);
            MarkupData cachedData = (MarkupData)this.renderingCache.get((Serializable)Integer.valueOf(key.hashCode()));
            if (cachedData != null) {
                return cachedData.build();
            }
            renderedContent = note.getContent();
            this.renderingCache.put((Serializable)Integer.valueOf(key.hashCode()), (Object)new MarkupData(renderedContent));
        }
        catch (Exception e) {
            log.error((Object)String.format("Failed to get rendered content of note [%s:%s:%s]", note.getWikiType(), note.getWikiOwner(), note.getName()), (Throwable)e);
        }
        return renderedContent;
    }

    @Override
    public void importNotes(String zipLocation, Page parent, String conflict, Identity userIdentity) throws WikiException, IllegalAccessException, IOException {
        List<String> files = Utils.unzip(zipLocation, System.getProperty(TEMP_DIRECTORY_PATH));
        this.importNotes(files, parent, conflict, userIdentity);
    }

    @Override
    public void importNotes(List<String> files, Page parent, String conflict, Identity userIdentity) throws WikiException, IllegalAccessException, IOException {
        String notesFilePath = "";
        for (String file : files) {
            if (!file.contains("notesExport_")) continue;
            notesFilePath = file;
            break;
        }
        if (!notesFilePath.equals("")) {
            ObjectMapper mapper = new ObjectMapper();
            File notesFile = new File(notesFilePath);
            ImportList notes = (ImportList)mapper.readValue(notesFile, (TypeReference)new TypeReference<ImportList>(){});
            Wiki wiki = this.wikiService.getWikiByTypeAndOwner(parent.getWikiType(), parent.getWikiOwner());
            if (StringUtils.isNotEmpty((String)conflict) && conflict.equals("replaceAll")) {
                List<Page> notesTodelete = this.getAllNotes(parent, userIdentity.getUserId());
                for (Page noteTodelete : notesTodelete) {
                    if ("Home".equals(noteTodelete.getName()) || noteTodelete.getId().equals(parent.getId())) continue;
                    try {
                        this.deleteNote(wiki.getType(), wiki.getOwner(), noteTodelete.getName(), userIdentity);
                    }
                    catch (Exception e) {
                        log.warn("Note {} connot be deleted for import", new Object[]{noteTodelete.getName(), e});
                    }
                }
            }
            for (Page note : notes.getNotes()) {
                this.importNote(note, parent, this.wikiService.getWikiByTypeAndOwner(parent.getWikiType(), parent.getWikiOwner()), conflict, userIdentity);
            }
            for (Page note : notes.getNotes()) {
                this.replaceIncludedPages(note, wiki);
            }
            NoteServiceImpl.cleanUp(notesFile);
        }
    }

    public void importNote(Page note, Page parent, Wiki wiki, String conflict, Identity userIdentity) throws WikiException, IllegalAccessException {
        Page parent_ = this.getNoteOfNoteBookByName(wiki.getType(), wiki.getOwner(), parent.getName());
        if (parent_ == null) {
            parent_ = wiki.getWikiHome();
        }
        String imagesSubLocationPath = "Documents/notes/images";
        Page note_ = note;
        if (!"Home".equals(note.getName())) {
            note.setId(null);
            Page note_2 = this.getNoteOfNoteBookByName(wiki.getType(), wiki.getOwner(), note.getName());
            if (note_2 == null) {
                processedContent = this.htmlUploadImageProcessor.processSpaceImages(note.getContent(), wiki.getOwner(), imagesSubLocationPath);
                note.setContent(processedContent);
                note_ = this.createNote(wiki, parent_.getName(), note, userIdentity);
            } else if (StringUtils.isNotEmpty((String)conflict)) {
                if (conflict.equals("overwrite") || conflict.equals("replaceAll")) {
                    this.deleteNote(wiki.getType(), wiki.getOwner(), note.getName());
                    processedContent = this.htmlUploadImageProcessor.processSpaceImages(note.getContent(), wiki.getOwner(), imagesSubLocationPath);
                    note.setContent(processedContent);
                    note_ = this.createNote(wiki, parent_.getName(), note, userIdentity);
                }
                if (conflict.equals("duplicate")) {
                    int i;
                    String title = note.getTitle();
                    try {
                        i = title.lastIndexOf("_") != -1 ? Integer.valueOf(title.substring(title.lastIndexOf("_") + 1)) + 1 : 1;
                    }
                    catch (NumberFormatException e) {
                        i = 1;
                    }
                    String newTitle = note.getTitle() + "_" + i;
                    while (this.getNoteOfNoteBookByName(wiki.getType(), wiki.getOwner(), newTitle) != null || this.isExisting(wiki.getType(), wiki.getOwner(), TitleResolver.getId(newTitle, false))) {
                        newTitle = note.getTitle() + "_" + ++i;
                    }
                    note.setName(newTitle);
                    note.setTitle(newTitle);
                    String processedContent = this.htmlUploadImageProcessor.processSpaceImages(note.getContent(), wiki.getOwner(), imagesSubLocationPath);
                    note.setContent(processedContent);
                    note_ = this.createNote(wiki, parent_.getName(), note, userIdentity);
                }
                if (!(!conflict.equals("update") || note_2.getTitle().equals(note.getTitle()) && note_2.getContent().equals(note.getContent()))) {
                    note_2.setTitle(note.getTitle());
                    processedContent = this.htmlUploadImageProcessor.processSpaceImages(note.getContent(), wiki.getOwner(), imagesSubLocationPath);
                    note_2.setContent(processedContent);
                    note_2 = this.updateNote(note_2, PageUpdateType.EDIT_PAGE_CONTENT, userIdentity);
                    this.createVersionOfNote(note_2, userIdentity.getUserId());
                }
            }
        } else if (StringUtils.isNotEmpty((String)conflict) && (conflict.equals("update") || conflict.equals("overwrite") || conflict.equals("replaceAll"))) {
            Page note_1 = this.getNoteOfNoteBookByName(wiki.getType(), wiki.getOwner(), note.getName());
            if (!note.getContent().equals(note_1.getContent())) {
                processedContent = this.htmlUploadImageProcessor.processSpaceImages(note.getContent(), wiki.getOwner(), imagesSubLocationPath);
                note.setContent(processedContent);
                note_1.setContent(processedContent);
                note_1 = this.updateNote(note_1, PageUpdateType.EDIT_PAGE_CONTENT, userIdentity);
                this.createVersionOfNote(note_1, userIdentity.getUserId());
            }
        }
        if (note.getChildren() != null) {
            for (Page child : note.getChildren()) {
                this.importNote(child, note_, wiki, conflict, userIdentity);
            }
        }
    }

    @Override
    public PageList<SearchResult> search(WikiSearchData data) throws WikiException {
        try {
            ObjectPageList result = this.dataStorage.search(data);
            if (data.getTitle() != null && data.getWikiType() != null && data.getWikiOwner() != null && result.getPageSize() > 0) {
                Page homePage = this.wikiService.getWikiByTypeAndOwner(data.getWikiType(), data.getWikiOwner()).getWikiHome();
                if (data.getTitle().equals("") || homePage != null && homePage.getTitle().contains(data.getTitle())) {
                    Calendar wikiHomeCreateDate = Calendar.getInstance();
                    wikiHomeCreateDate.setTime(homePage.getCreatedDate());
                    Calendar wikiHomeUpdateDate = Calendar.getInstance();
                    wikiHomeUpdateDate.setTime(homePage.getUpdatedDate());
                    SearchResult wikiHomeResult = new SearchResult(data.getWikiType(), data.getWikiOwner(), homePage.getName(), null, null, homePage.getTitle(), SearchResultType.PAGE, wikiHomeUpdateDate, wikiHomeCreateDate);
                    List tempSearchResult = result.getAll();
                    tempSearchResult.add(wikiHomeResult);
                    result = new ObjectPageList(tempSearchResult, result.getPageSize());
                }
            }
            return result;
        }
        catch (Exception e) {
            log.error((Object)("Cannot search on wiki " + data.getWikiType() + ":" + data.getWikiOwner() + " - Cause : " + e.getMessage()), (Throwable)e);
            return new ObjectPageList(new ArrayList(), 0);
        }
    }

    private void replaceIncludedPages(Page note, Wiki wiki) throws WikiException {
        String content;
        Page note_ = this.getNoteOfNoteBookByName(wiki.getType(), wiki.getOwner(), note.getName());
        if (note_ != null && (content = note_.getContent()).contains("class=\"noteLink\" href=\"//-")) {
            while (content.contains("class=\"noteLink\" href=\"//-")) {
                String linkedParams = content.split("class=\"noteLink\" href=\"//-")[1].split("-//\"")[0];
                String noteBookType = linkedParams.split("-////-")[0];
                String noteBookOwner = linkedParams.split("-////-")[1];
                String NoteName = linkedParams.split("-////-")[2];
                Page linkedNote = null;
                linkedNote = this.getNoteOfNoteBookByName(wiki.getType(), wiki.getOwner(), NoteName);
                content = linkedNote != null ? content.replace("\"noteLink\" href=\"//-" + linkedParams + "-//", "\"noteLink\" href=\"" + linkedNote.getId()) : content.replace("\"noteLink\" href=\"//-" + linkedParams + "-//", "\"noteLink\" href=\"" + NoteName);
                if (!content.equals(note_.getContent())) continue;
                break;
            }
            if (!content.equals(note_.getContent())) {
                note_.setContent(content);
                this.updateNote(note_);
            }
        }
        if (note.getChildren() != null) {
            for (Page child : note.getChildren()) {
                this.replaceIncludedPages(child, wiki);
            }
        }
    }

    private String replaceUrl(String body, Map<String, String> urlToReplaces) {
        for (String url : urlToReplaces.keySet()) {
            while (body.contains(url)) {
                body = body.replace(url, urlToReplaces.get(url));
            }
        }
        return body;
    }

    public static void cleanUp(File file) throws IOException {
        if (Files.exists(file.toPath(), new LinkOption[0])) {
            Files.delete(file.toPath());
        }
    }

    public List<Page> getAllNotes(Page note, String userName) throws WikiException {
        ArrayList<Page> listOfNotes = new ArrayList<Page>();
        this.addAllNodes(note, listOfNotes, userName);
        return listOfNotes;
    }

    private void addAllNodes(Page note, List<Page> listOfNotes, String userName) throws WikiException {
        if (note != null) {
            listOfNotes.add(note);
            List<Page> children = this.getChildrenNoteOf(note, userName, true, false);
            if (children != null) {
                for (Page child : children) {
                    this.addAllNodes(child, listOfNotes, userName);
                }
            }
        }
    }

    private Map<String, List<MetadataItem>> retrieveMetadataItems(String noteId, String username) {
        org.exoplatform.social.core.identity.model.Identity currentIdentity = this.identityManager.getOrCreateIdentity("organization", username);
        long currentUserId = Long.parseLong(currentIdentity.getId());
        MetadataService metadataService = (MetadataService)CommonsUtils.getService(MetadataService.class);
        MetadataObject metadataObject = new MetadataObject("notes", noteId);
        List metadataItems = metadataService.getMetadataItemsByObject(metadataObject);
        HashMap<String, List<MetadataItem>> metadata = new HashMap<String, List<MetadataItem>>();
        metadataItems.stream().filter(metadataItem -> metadataItem.getMetadata().getAudienceId() == 0L || metadataItem.getMetadata().getAudienceId() == currentUserId).forEach(metadataItem -> {
            String type = metadataItem.getMetadata().getType().getName();
            metadata.computeIfAbsent(type, k -> new ArrayList());
            ((List)metadata.get(type)).add(metadataItem);
        });
        return metadata;
    }

    private Identity getIdentity(String username) {
        if (StringUtils.isBlank((String)username)) {
            return null;
        }
        Identity aclIdentity = this.identityRegistry.getIdentity(username);
        if (aclIdentity == null) {
            try {
                List<MembershipEntry> entries = this.organizationService.getMembershipHandler().findMembershipsByUser(username).stream().map(membership -> new MembershipEntry(membership.getGroupId(), membership.getMembershipType())).toList();
                aclIdentity = new Identity(username, entries);
                this.identityRegistry.register(aclIdentity);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to retrieve user " + username + " memberships", e);
            }
        }
        return aclIdentity;
    }

    @Override
    public Page getNoteByIdAndLang(Long pageId, Identity userIdentity, String source, String lang) throws WikiException, IllegalAccessException {
        Page page = this.getNoteById(String.valueOf(pageId), userIdentity, source);
        PageVersion publishedVersion = this.dataStorage.getPublishedVersionByPageIdAndLang(pageId, lang);
        if (page != null && publishedVersion != null) {
            page.setTitle(publishedVersion.getTitle());
            page.setContent(publishedVersion.getContent());
            page.setLang(publishedVersion.getLang());
            if (lang != null) {
                page.setMetadatas(this.retrieveMetadataItems(pageId + "-" + lang, userIdentity.getUserId()));
            }
        }
        return page;
    }

    @Override
    public PageVersion getPublishedVersionByPageIdAndLang(Long pageId, String lang) {
        return this.dataStorage.getPublishedVersionByPageIdAndLang(pageId, lang);
    }

    @Override
    public List<String> getPageAvailableTranslationLanguages(Long pageId, String userName, boolean withDrafts) throws WikiException {
        HashSet<String> langs = new HashSet<String>(this.dataStorage.getPageAvailableTranslationLanguages(pageId));
        if (withDrafts) {
            List<DraftPage> drafts = this.dataStorage.getDraftsOfPage(pageId, userName);
            drafts = drafts.stream().filter(jsonNodeData -> StringUtils.isNotBlank((String)jsonNodeData.getLang())).toList();
            langs.addAll(drafts.stream().map(Page::getLang).toList());
        }
        return langs.stream().toList();
    }

    @Override
    public List<PageHistory> getVersionsHistoryOfNoteByLang(Page note, String userName, String lang) throws WikiException {
        List<PageHistory> pageHistories = this.dataStorage.getPageHistoryVersionsByPageIdAndLang(Long.valueOf(note.getId()), lang);
        if (lang == null && pageHistories.isEmpty()) {
            this.dataStorage.addPageVersion(note, userName);
            pageHistories = this.dataStorage.getPageHistoryVersionsByPageIdAndLang(Long.valueOf(note.getId()), null);
        }
        return pageHistories;
    }

    @Override
    public DraftPage getLatestDraftPageByUserAndTargetPageAndLang(Long targetPageId, String username, String lang) {
        return this.dataStorage.getLatestDraftPageByUserAndTargetPageAndLang(targetPageId, username, lang);
    }

    @Override
    public void deleteVersionsByNoteIdAndLang(Long noteId, String userName, String lang) throws WikiException {
        this.dataStorage.deleteVersionsByNoteIdAndLang(noteId, lang);
        List<DraftPage> drafts = this.dataStorage.getDraftsOfPage(noteId, userName);
        for (DraftPage draftPage : drafts) {
            if (!StringUtils.equals((String)draftPage.getLang(), (String)lang)) continue;
            this.removeDraft(draftPage.getName());
        }
        this.postDeletePageVersionLanguage(noteId + "-" + lang);
    }
}

