/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.search;

import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.documents.legacy.search.data.SearchResult;
import org.exoplatform.documents.model.DocumentNodeFilter;
import org.exoplatform.documents.model.DocumentTimelineFilter;
import org.exoplatform.documents.storage.jcr.search.DocumentFileSearchResult;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class DocumentSearchServiceConnector {
    private static final Log LOG = ExoLogger.getLogger(DocumentSearchServiceConnector.class);
    private static final String SEARCH_QUERY_FILE_PATH_PARAM = "query.file.path";
    public static final String SEARCH_QUERY_TERM = "\"must\":{    \"query_string\":{    \"fields\": [\"title.whitespace\"],    \"query\": \"@term@\"  }},";
    public static final String EXTENDED_SEARCH_QUERY_TERM = "\"must\":{    \"query_string\":{    \"fields\": [\"title\",\"attachment.content\",\"dc:description\"],    \"query\": \"*@term@*\"  }},";
    public static final String QUERY_TAG_TERM = "@term@";
    public static final String ASTERISK_STR = "*";
    private static final String IMAGES = "\"image/bmp\",\"image/jpeg\",\"image/webp\",\"image/png\",\"image/gif\",\"image/avif\",\"image/tiff\"";
    private static final String SHEETS = "\"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet\",\"application/vnd.oasis.opendocument.spreadsheet\",\"officedocument.spreadsheetml.sheet\",\"application/vnd.ms-excel\",\"text/csv\"";
    private static final String PRESENTATIONS = "\"application/vnd.ms-powerpoint\",\"application/vnd.openxmlformats-officedocument.presentationml.presentation\",\"application/vnd.oasis.opendocument.presentation\"";
    private static final String PDFS = "\"application/pdf\"";
    private static final String ARCHIVES = "\"application/zip\",\"application/vnd.rar\"";
    private static final String VIDEOS = "\"video/x-msvideo\",\"video/mp4\",\"video/mpeg\",\"video/ogg\",\"video/webm\",\"video/3gpp\"";
    private static final String DOCUMENTS = "\"application/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"application/msword\",\"application/rtf\",\"application/vnd.oasis.opendocument.text\"";
    private final ConfigurationManager configurationManager;
    private final IdentityManager identityManager;
    private final ElasticSearchingClient client;
    private final String index;
    private String searchQueryFilePath;
    private String searchQuery;

    public DocumentSearchServiceConnector(ConfigurationManager configurationManager, IdentityManager identityManager, ElasticSearchingClient client, InitParams initParams) {
        this.configurationManager = configurationManager;
        this.identityManager = identityManager;
        this.client = client;
        PropertiesParam param = initParams.getPropertiesParam("constructor.params");
        this.index = param.getProperty("index");
        if (initParams.containsKey((Object)SEARCH_QUERY_FILE_PATH_PARAM)) {
            this.searchQueryFilePath = initParams.getValueParam(SEARCH_QUERY_FILE_PATH_PARAM).getValue();
            try {
                this.retrieveSearchQuery();
            }
            catch (Exception e) {
                LOG.error("Can't read elasticsearch search query from path {}", new Object[]{this.searchQueryFilePath, e});
            }
        }
    }

    public Collection<SearchResult> search(Identity userIdentity, String workspace, String path, DocumentNodeFilter filter, int offset, int limit, String sortField, String sortDirection) {
        if (userIdentity == null) {
            throw new IllegalArgumentException("Viewer identity is mandatory");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must be positive");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("Limit must be positive");
        }
        if (StringUtils.isBlank((String)filter.getQuery()) && BooleanUtils.isFalse((Boolean)filter.getFavorites()) && StringUtils.isEmpty((String)filter.getFileTypes()) && filter.getAfterDate() == null && filter.getBeforeDate() == null && filter.getMaxSize() == null && filter.getMinSize() == null) {
            throw new IllegalArgumentException("Filter term is mandatory");
        }
        switch (sortField) {
            case "lastUpdatedDate": {
                sortField = "lastUpdatedDate";
                break;
            }
            case "title": {
                sortField = "title.raw";
                break;
            }
            default: {
                sortField = "_score";
            }
        }
        String esQuery = this.buildQueryStatement(userIdentity, workspace, path, filter, sortField, sortDirection, false, offset, limit);
        String jsonResponse = this.client.sendRequest(esQuery, this.index);
        return this.buildResult(jsonResponse);
    }

    public long getTotalSize(Identity userIdentity, String workspace, String path) {
        if (userIdentity == null) {
            throw new IllegalArgumentException("Viewer identity is mandatory");
        }
        String esQuery = this.buildQueryStatement(userIdentity, workspace, path, (DocumentNodeFilter)new DocumentTimelineFilter(), "lastUpdatedDate", "ASC", true, 0, 0);
        String jsonResponse = this.client.sendRequest(esQuery, this.index);
        try {
            Map json;
            JSONParser parser = new JSONParser();
            try {
                json = (Map)parser.parse(jsonResponse);
            }
            catch (ParseException e) {
                throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
            }
            JSONObject jsonResult = (JSONObject)json.get("aggregations");
            jsonResult = (JSONObject)jsonResult.get((Object)"total_size");
            return ((Double)jsonResult.get((Object)"value")).longValue();
        }
        catch (Exception e) {
            throw new ElasticSearchException("Unable to get documents size", (Throwable)e);
        }
    }

    public String getLimit(int limit) {
        if (limit > 0) {
            return "\"size\":" + limit + ",";
        }
        return "";
    }

    private String buildQueryStatement(Identity userIdentity, String workspace, String path, DocumentNodeFilter filter, String sortField, String sortDirection, boolean getTotalSize, int offset, int limit) {
        Map<String, List<String>> metadataFilters = this.buildMetadatasFilter(filter, this.identityManager.getOrCreateIdentity("organization", userIdentity.getUserId()));
        String termQuery = this.buildTermQueryStatement(filter.getQuery(), BooleanUtils.isTrue((Boolean)filter.isExtendedSearch()));
        String favoriteQuery = this.buildFavoriteQueryStatement(metadataFilters.get(FavoriteService.METADATA_TYPE.getName()));
        if (StringUtils.isNotEmpty((String)path) && !((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return this.retrieveSearchQuery().replace("@term_query@", termQuery).replace("@favorite_query@", favoriteQuery).replace("@permissions@", this.getPermissionFilter(userIdentity)).replace("@fileTypes_query@", this.getFileTypesQuery(filter)).replace("@size_query@", this.getSizeQuery(filter)).replace("@date_query@", this.getDatesQuery(filter)).replace("@path@", (CharSequence)path).replace("@workspace@", workspace).replace("@size_agg@", this.getSizeAgg(getTotalSize)).replace("@sort_field@", sortField).replace("@sort_direction@", sortDirection).replace("@offset@", String.valueOf(offset)).replace("@limit@", this.getLimit(limit));
    }

    private String getFileTypesQuery(DocumentNodeFilter filter) {
        if (StringUtils.isNotEmpty((String)filter.getFileTypes())) {
            ArrayList<String> types = new ArrayList<String>();
            for (String type : filter.getFileTypes().split(",")) {
                try {
                    types.add((String)this.getClass().getDeclaredField(type.toUpperCase()).get(0));
                }
                catch (Exception e) {
                    LOG.warn("Cannot get list of mimeTypes related to type {}", new Object[]{type, e});
                }
            }
            return "{\n   \"bool\":{\n      \"should\":[\n          {\n           \"terms\":{\n               \"fileType\":[\n" + types.stream().collect(Collectors.joining(",")) + "]\n            }\n         }\n      ]\n   }\n},\n";
        }
        return "";
    }

    private String getSizeQuery(DocumentNodeFilter filter) {
        if (filter.getMinSize() != null || filter.getMaxSize() != null) {
            ArrayList<CallSite> sizes = new ArrayList<CallSite>();
            if (filter.getMinSize() != null) {
                sizes.add((CallSite)((Object)("\"gte\": " + filter.getMinSize() * 1024L * 1024L)));
            }
            if (filter.getMaxSize() != null) {
                sizes.add((CallSite)((Object)("\"lte\": " + filter.getMaxSize() * 1024L * 1024L)));
            }
            return "{\n   \"bool\":{\n      \"should\":[\n         {\n           \"range\": {\n             \"fileSize\": {\n" + sizes.stream().collect(Collectors.joining(",")) + "             }\n        }\n      }\n    ]\n  }\n},\n";
        }
        return "";
    }

    private String getDatesQuery(DocumentNodeFilter filter) {
        if (filter.getAfterDate() != null || filter.getBeforeDate() != null) {
            ArrayList<CallSite> dates = new ArrayList<CallSite>();
            if (filter.getAfterDate() != null) {
                dates.add((CallSite)((Object)("\"gte\": " + filter.getAfterDate())));
            }
            if (filter.getBeforeDate() != null) {
                dates.add((CallSite)((Object)("\"lte\": " + filter.getBeforeDate())));
            }
            return "{\n   \"bool\":{\n      \"should\":[\n         {\n           \"range\": {\n             \"lastUpdatedDate\": {\n" + dates.stream().collect(Collectors.joining(",")) + "             }\n        }\n      }\n    ]\n  }\n},\n";
        }
        return "";
    }

    private String getSizeAgg(boolean getTotalSize) {
        if (getTotalSize) {
            return "\"aggs\": {\n      \"total_size\": { \"sum\": { \"field\": \"fileSize\" } }\n    },";
        }
        return "";
    }

    private String getPermissionFilter(Identity userIdentity) {
        StringBuilder permissionSB = new StringBuilder();
        Set<String> membershipSet = this.getUserMemberships(userIdentity);
        if (!membershipSet.isEmpty()) {
            String memberships = StringUtils.join((Object[])membershipSet.toArray(new String[membershipSet.size()]), (String)"|");
            permissionSB.append("{\n").append("  \"term\" : { \"permissions\" : \"").append(userIdentity.getUserId()).append("\" }\n").append("},\n").append("{\n").append("  \"term\" : { \"permissions\" : \"").append(IdentityConstants.ANY).append("\" }\n").append("},\n").append("{\n").append("  \"regexp\" : { \"permissions\" : \"").append(memberships).append("\" }\n").append("}");
        } else {
            permissionSB.append("{\n").append("  \"term\" : { \"permissions\" : \"").append(userIdentity.getUserId()).append("\" }\n").append("},\n").append("{\n").append("  \"term\" : { \"permissions\" : \"").append(IdentityConstants.ANY).append("\" }\n").append("}");
        }
        return permissionSB.toString();
    }

    private Set<String> getUserMemberships(Identity userIdentity) {
        if (userIdentity == null) {
            throw new IllegalStateException("No Identity found: ConversationState.getCurrent().getIdentity() is null");
        }
        if (userIdentity.getMemberships() == null) {
            throw new IllegalStateException("No Membership found: ConversationState.getCurrent().getIdentity().getMemberships() is null");
        }
        HashSet<String> entries = new HashSet<String>();
        for (MembershipEntry entry : userIdentity.getMemberships()) {
            if (entry.getMembershipType().equals(ASTERISK_STR)) {
                entries.add(entry.toString().replace(ASTERISK_STR, ".*"));
                continue;
            }
            entries.add(entry.toString());
            entries.add("*:" + entry.getGroup());
        }
        return entries;
    }

    protected Collection<SearchResult> buildResult(String jsonResponse) {
        JSONArray jsonHits;
        Map json;
        LOG.debug("Search Query response from ES : {} ", new Object[]{jsonResponse});
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        JSONParser parser = new JSONParser();
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult != null && (jsonHits = (JSONArray)jsonResult.get((Object)"hits")) != null) {
            for (Object jsonHit : jsonHits) {
                results.add(this.buildHit((JSONObject)jsonHit));
            }
        }
        return results;
    }

    protected SearchResult buildHit(JSONObject jsonHit) {
        JSONObject hitSource = (JSONObject)jsonHit.get((Object)"_source");
        String title = this.getTitleFromJsonResult(hitSource);
        String url = this.getUrlFromJsonResult(hitSource);
        Long lastUpdatedDate = this.getUpdatedDateFromResult(hitSource);
        if (lastUpdatedDate == null) {
            lastUpdatedDate = new Date().getTime();
        }
        Double score = (Double)jsonHit.get((Object)"_score");
        JSONObject hitHighlight = (JSONObject)jsonHit.get((Object)"highlight");
        HashMap<String, List<String>> excerpts = new HashMap<String, List<String>>();
        StringBuilder excerpt = new StringBuilder();
        if (hitHighlight != null) {
            for (String key : hitHighlight.keySet()) {
                JSONArray highlights = (JSONArray)hitHighlight.get((Object)key);
                List excerptsList = highlights.stream().map(Object::toString).collect(Collectors.toList());
                excerpts.put(key, excerptsList);
                excerpt.append("... ").append(StringUtils.join(excerptsList, (String)"..."));
            }
        }
        LOG.debug("Excerpt extract from ES response : {}", new Object[]{excerpt.toString()});
        SearchResult searchResult = new SearchResult(url, title, excerpts, excerpt.toString(), null, null, lastUpdatedDate, score.longValue());
        String id = (String)jsonHit.get((Object)"_id");
        String workspace = (String)hitSource.get((Object)"workspace");
        String nodePath = (String)hitSource.get((Object)"path");
        return new DocumentFileSearchResult(searchResult, id, workspace, nodePath);
    }

    protected Long getUpdatedDateFromResult(JSONObject hitSource) {
        Object date = hitSource.get((Object)"lastUpdatedDate");
        if (date instanceof Long) {
            return (Long)date;
        }
        if (date != null) {
            try {
                return Long.parseLong(date.toString());
            }
            catch (Exception ex) {
                LOG.error("Can not parse updatedDate field as Long {}", new Object[]{date});
            }
        }
        return null;
    }

    protected String getUrlFromJsonResult(JSONObject hitSource) {
        return (String)hitSource.get((Object)"url");
    }

    protected String getTitleFromJsonResult(JSONObject hitSource) {
        return (String)hitSource.get((Object)"title");
    }

    protected String escapeReservedCharacters(String query) {
        return StringUtils.isNotEmpty((String)query) ? query.replaceAll("[" + Pattern.quote("+-=&|><!(){}\\[\\]^\"*?:\\/") + "]", Matcher.quoteReplacement("\\\\") + "$0") : query;
    }

    private String buildTermQueryStatement(String term, boolean extendedSearch) {
        boolean isEscapedQueryWithAndOperator;
        if (StringUtils.isBlank((String)term)) {
            return "";
        }
        if (term.startsWith("#")) {
            term = term.substring(1);
        }
        String originalTerm = term;
        term = this.escapeReservedCharacters(term);
        String escapedQueryWithAndOperator = this.buildEscapedQueryWithAndOperator(term);
        boolean isEscapedReservedCharactersTerm = !originalTerm.equals(term);
        boolean bl = isEscapedQueryWithAndOperator = !escapedQueryWithAndOperator.equals(term);
        if (!extendedSearch) {
            StringBuilder inputSplittedValue = new StringBuilder();
            String[] splittedValue = term.split(" ");
            for (int i = 0; i < splittedValue.length; ++i) {
                if (!StringUtils.isNotBlank((String)splittedValue[i])) continue;
                if (i != 0) {
                    inputSplittedValue.append(" AND ");
                }
                inputSplittedValue.append("(");
                String replaceSpecialCharInputValue = this.replaceSpecialCharInputValue(splittedValue[i]);
                inputSplittedValue.append(replaceSpecialCharInputValue);
                String inputWithAsteriskStr = ASTERISK_STR.concat(replaceSpecialCharInputValue).concat(ASTERISK_STR);
                inputSplittedValue.append(" OR ").append(inputWithAsteriskStr);
                inputSplittedValue.append(")");
            }
            return SEARCH_QUERY_TERM.replace(QUERY_TAG_TERM, inputSplittedValue.toString());
        }
        return isEscapedReservedCharactersTerm && !isEscapedQueryWithAndOperator ? EXTENDED_SEARCH_QUERY_TERM.replace(ASTERISK_STR, "\\\\*").replace(QUERY_TAG_TERM, term) : EXTENDED_SEARCH_QUERY_TERM.replace(QUERY_TAG_TERM, escapedQueryWithAndOperator);
    }

    private String retrieveSearchQuery() {
        if (StringUtils.isBlank((String)this.searchQuery) || PropertyManager.isDevelopping()) {
            try {
                InputStream queryFileIS = this.configurationManager.getInputStream(this.searchQueryFilePath);
                this.searchQuery = IOUtil.getStreamContentAsString((InputStream)queryFileIS);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error retrieving search query from file: " + this.searchQueryFilePath, e);
            }
        }
        return this.searchQuery;
    }

    private String buildFavoriteQueryStatement(List<String> values) {
        if (CollectionUtils.isEmpty(values)) {
            return "";
        }
        return "{\"terms\":{" + "\"metadatas.favorites.metadataName.keyword\": [\"" + StringUtils.join(values, (String)"\",\"") + "\"]}},";
    }

    private Map<String, List<String>> buildMetadatasFilter(DocumentNodeFilter filter, org.exoplatform.social.core.identity.model.Identity userIdentity) {
        HashMap<String, List<String>> metadataFilters = new HashMap<String, List<String>>();
        if (BooleanUtils.isTrue((Boolean)filter.getFavorites())) {
            metadataFilters.put(FavoriteService.METADATA_TYPE.getName(), Collections.singletonList(userIdentity.getId()));
        }
        return metadataFilters;
    }

    protected String buildEscapedQueryWithAndOperator(String term) {
        List<String> queryParts = Arrays.asList(term.split(" "));
        if (queryParts.size() > 1) {
            StringBuilder escapedQueryWithAndOperator = new StringBuilder();
            String pattern = "[-+=&|><!(){}\\[\\]^\"*?:\\\\/]";
            Pattern regex = Pattern.compile(pattern);
            int i = 0;
            for (int j = 1; i < queryParts.size() && j < queryParts.size(); ++i, ++j) {
                Matcher matcher = regex.matcher(queryParts.get(i));
                Matcher nextMatcher = regex.matcher(queryParts.get(j));
                escapedQueryWithAndOperator.append(queryParts.get(i));
                if (matcher.find()) {
                    escapedQueryWithAndOperator.append("\\\\* AND ");
                } else {
                    escapedQueryWithAndOperator.append("* AND ");
                }
                if (nextMatcher.find()) {
                    escapedQueryWithAndOperator.append("\\\\*");
                } else {
                    escapedQueryWithAndOperator.append(ASTERISK_STR);
                }
                if (j != queryParts.size() - 1) continue;
                escapedQueryWithAndOperator.append(queryParts.get(j));
                if (!nextMatcher.find()) continue;
                escapedQueryWithAndOperator.append("\\\\");
            }
            return escapedQueryWithAndOperator.toString();
        }
        return term;
    }

    private String replaceSpecialCharInputValue(String inputValue) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        int j = 0;
        int numberLetterOrDigit = 0;
        for (char c : inputValue.toCharArray()) {
            if (!Character.isLetterOrDigit(c) && Character.isWhitespace(c)) {
                if (j != 0) {
                    result.append("\\\\").append(c);
                } else if (i == 0) {
                    result.append(c);
                    ++j;
                } else {
                    result.append(c);
                    j = 0;
                }
            } else {
                result.append(c);
                ++numberLetterOrDigit;
                j = 0;
            }
            ++i;
        }
        if (numberLetterOrDigit == 0) {
            return ASTERISK_STR;
        }
        return result.toString();
    }
}

