/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.commons.chain.Context;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.QName;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.command.action.Action;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.document.HandlerNotFoundException;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.JCRName;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AddMetadataAction
implements Action {
    private static Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.ext.AddMetadataAction");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context ctx) throws Exception {
        PropertyImpl property = (PropertyImpl)ctx.get((Object)InvocationContext.CURRENT_ITEM);
        NodeImpl parent = this.getAndValidateParent(property);
        Content content = this.getContent(parent, property, ctx);
        try {
            if (!content.isEmpty()) {
                Properties props = this.extractMetaInfoProperties(ctx, content);
                this.setJCRProperties(parent, props);
            }
        }
        catch (HandlerNotFoundException e) {
            LOG.debug((Object)("Binary value reader error, content by path " + property.getPath() + ", property id " + property.getData().getIdentifier() + " : " + e.getMessage()));
        }
        catch (IOException e) {
            this.printWarning(property, e);
        }
        catch (DocumentReadException e) {
            this.printWarning(property, (Exception)((Object)e));
        }
        finally {
            content.destroy();
        }
        return false;
    }

    private Properties extractMetaInfoProperties(Context ctx, Content content) throws IllegalArgumentException, RepositoryException, IOException, DocumentReadException, HandlerNotFoundException {
        DocumentReaderService readerService = (DocumentReaderService)((ExoContainer)ctx.get((Object)InvocationContext.EXO_CONTAINER)).getComponentInstanceOfType(DocumentReaderService.class);
        if (readerService == null) {
            throw new IllegalArgumentException("No DocumentReaderService configured for current container");
        }
        Properties props = new Properties();
        props = readerService.getDocumentReader(content.mimeType).getProperties(content.stream);
        return props;
    }

    private void printWarning(PropertyImpl property, Exception exception) throws RepositoryException {
        if (PropertyManager.isDevelopping()) {
            LOG.warn((Object)("Binary value reader error, content by path " + property.getPath() + ", property id " + property.getData().getIdentifier() + " : " + exception.getMessage()), (Throwable)exception);
        } else {
            LOG.warn((Object)("Binary value reader error, content by path " + property.getPath() + ", property id " + property.getData().getIdentifier() + " : " + exception.getMessage()));
        }
    }

    private void setJCRProperties(NodeImpl parent, Properties props) throws Exception {
        if (!parent.isNodeType("dc:elementSet")) {
            parent.addMixin("dc:elementSet");
        }
        ValueFactoryImpl vFactory = parent.getSession().getValueFactory();
        LocationFactory lFactory = parent.getSession().getLocationFactory();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            QName qname = (QName)entry.getKey();
            JCRName jcrName = lFactory.createJCRName(new InternalQName(qname.getNamespace(), qname.getName()));
            PropertyDefinitionData definition = parent.getSession().getWorkspace().getNodeTypesHolder().getPropertyDefinitions(jcrName.getInternalName(), ((NodeData)parent.getData()).getPrimaryTypeName(), ((NodeData)parent.getData()).getMixinTypeNames()).getAnyDefinition();
            if (definition == null) continue;
            if (definition.isMultiple()) {
                Value[] values = new Value[]{this.createValue(entry.getValue(), (ValueFactory)vFactory)};
                parent.setProperty(jcrName.getAsString(), values);
                continue;
            }
            Value value = this.createValue(entry.getValue(), (ValueFactory)vFactory);
            parent.setProperty(jcrName.getAsString(), value);
        }
    }

    private NodeImpl getAndValidateParent(PropertyImpl property) throws Exception {
        NodeImpl parent = property.getParent();
        if (!parent.isNodeType("nt:resource")) {
            throw new Exception("Incoming node is not nt:resource type");
        }
        return parent;
    }

    private Content getContent(NodeImpl parent, PropertyImpl property, Context ctx) throws Exception {
        Content content = new Content();
        if (property.getInternalName().equals((Object)Constants.JCR_DATA)) {
            content.stream = ((ValueData)((PropertyData)property.getData()).getValues().get(0)).getAsStream();
            try {
                content.mimeType = parent.getProperty("jcr:mimeType").getString();
            }
            catch (PathNotFoundException e) {
                return content;
            }
        }
        if (property.getInternalName().equals((Object)Constants.JCR_MIMETYPE)) {
            int evt = (Integer)ctx.get((Object)InvocationContext.EVENT);
            if (evt != 4) {
                return content;
            }
            content.mimeType = property.getString();
            try {
                PropertyImpl propertyImpl = (PropertyImpl)parent.getProperty("jcr:data");
                content.stream = ((ValueData)((PropertyData)propertyImpl.getData()).getValues().get(0)).getAsStream();
            }
            catch (PathNotFoundException e) {
                return content;
            }
        }
        return content;
    }

    private Value createValue(Object obj, ValueFactory factory) throws ValueFormatException {
        if (obj instanceof String) {
            return factory.createValue((String)obj);
        }
        if (obj instanceof Calendar) {
            return factory.createValue((Calendar)obj);
        }
        if (obj instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)obj);
            return factory.createValue(cal);
        }
        throw new ValueFormatException("Unsupported value type " + obj.getClass());
    }

    private class Content {
        String mimeType;
        InputStream stream;

        private Content() {
        }

        boolean isEmpty() throws IOException {
            return this.mimeType == null || this.stream == null || this.stream.available() == 0;
        }

        void destroy() {
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Can't close stream", (Throwable)e);
                }
            }
        }
    }
}

