/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.rest.model.UserNodeBreadcrumbItem;
import org.exoplatform.portal.mop.rest.model.UserNodeRestEntity;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;

public class EntityBuilder {
    private static final Log LOG = ExoLogger.getLogger(EntityBuilder.class);
    public static final String GROUP = "group";

    private EntityBuilder() {
    }

    public static List<UserNodeRestEntity> toUserNodeRestEntity(Collection<UserNode> nodes, boolean expand, OrganizationService organizationService, LayoutService layoutService, UserACL userACL, UserPortal userPortal, boolean expandBreadcrumb) {
        if (nodes == null) {
            return Collections.emptyList();
        }
        ArrayList<UserNodeRestEntity> result = new ArrayList<UserNodeRestEntity>();
        for (UserNode userNode : nodes) {
            if (userNode == null) continue;
            UserNodeRestEntity resultNode = new UserNodeRestEntity(userNode);
            if (expand && userNode.getPageRef() != null) {
                Page userNodePage = layoutService.getPage(userNode.getPageRef());
                if (PageType.LINK.equals((Object)PageType.valueOf((String)userNodePage.getType()))) {
                    resultNode.setPageLink(userNodePage.getLink());
                }
                if (!StringUtils.isBlank((String)userNodePage.getEditPermission())) {
                    resultNode.setCanEditPage(userACL.hasEditPermission(userNodePage));
                    HashMap<String, Object> editPermission = new HashMap<String, Object>();
                    try {
                        editPermission.put("membershipType", userNodePage.getEditPermission().split(":")[0]);
                        editPermission.put(GROUP, organizationService.getGroupHandler().findGroupById(userNodePage.getEditPermission().split(":")[1]));
                    }
                    catch (Exception e) {
                        LOG.warn("Error when getting group with id {}", new Object[]{userNodePage.getEditPermission().split(":")[1], e});
                    }
                    resultNode.setPageEditPermission(editPermission);
                }
                if (userNodePage.getAccessPermissions() != null) {
                    ArrayList<Map<String, Object>> accessPermissions = new ArrayList();
                    if (userNodePage.getAccessPermissions().length == 1 && userNodePage.getAccessPermissions()[0].equals("Everyone")) {
                        HashMap<String, String> accessPermission = new HashMap<String, String>();
                        accessPermission.put("membershipType", userNodePage.getAccessPermissions()[0]);
                        accessPermissions.add(accessPermission);
                    } else {
                        accessPermissions = Arrays.stream(userNodePage.getAccessPermissions()).map(permission -> {
                            HashMap<String, String> accessPermission = new HashMap<String, String>();
                            try {
                                accessPermission.put("membershipType", permission.split(":")[0]);
                                accessPermission.put(GROUP, (String)organizationService.getGroupHandler().findGroupById(permission.split(":")[1]));
                            }
                            catch (Exception e) {
                                LOG.warn("Error when getting group with id {}", new Object[]{permission.split(":")[1], e});
                            }
                            return accessPermission;
                        }).collect(Collectors.toList());
                    }
                    resultNode.setPageAccessPermissions(accessPermissions);
                }
            }
            if (expandBreadcrumb) {
                List<UserNodeBreadcrumbItem> userNodeBreadcrumbItemList = EntityBuilder.getUserNodeBreadcrumbList(userPortal, layoutService, userNode);
                Collections.reverse(userNodeBreadcrumbItemList);
                resultNode.setUserNodeBreadcrumbItemList(userNodeBreadcrumbItemList);
            }
            resultNode.setChildren(EntityBuilder.toUserNodeRestEntity(userNode.getChildren(), expand, organizationService, layoutService, userACL, userPortal, expandBreadcrumb));
            result.add(resultNode);
        }
        return result;
    }

    private static List<UserNodeBreadcrumbItem> getUserNodeBreadcrumbList(UserPortal userPortal, LayoutService layoutService, UserNode userNode) {
        UserNavigation userNodeNavigation = userNode.getNavigation();
        UserNode rootNavigationNode = userPortal.getNode(userNodeNavigation, Scope.ALL, UserNodeFilterConfig.builder().build(), null);
        ArrayList<UserNodeBreadcrumbItem> userNodeBreadcrumbItemList = new ArrayList<UserNodeBreadcrumbItem>();
        String portalName = PortalContainer.getCurrentPortalContainerName();
        for (userNode = EntityBuilder.findTargetNode(userNode.getId(), rootNavigationNode); userNode != null && !userNode.getName().equals("default"); userNode = userNode.getParent()) {
            userNodeBreadcrumbItemList.add(EntityBuilder.computeUserNodeBreadcrumbItem(layoutService, userNode, portalName, userNodeNavigation.getKey().getName()));
        }
        return userNodeBreadcrumbItemList;
    }

    private static UserNodeBreadcrumbItem computeUserNodeBreadcrumbItem(LayoutService layoutService, UserNode node, String portalName, String siteName) {
        String nodeUri = null;
        if (node.getPageRef() != null) {
            Page userNodePage = layoutService.getPage(node.getPageRef());
            if (PageType.LINK.equals((Object)PageType.valueOf((String)userNodePage.getType()))) {
                nodeUri = userNodePage.getLink();
            } else {
                if (((String)siteName).contains("/spaces/")) {
                    siteName = "g/" + ((String)siteName).replaceAll("/", ":");
                }
                nodeUri = "/" + portalName + "/" + (String)siteName + "/" + node.getURI();
            }
        }
        return new UserNodeBreadcrumbItem(node.getId(), node.getName(), node.getResolvedLabel(), nodeUri, node.getTarget());
    }

    private static UserNode findTargetNode(String nodeId, UserNode rootNode) {
        for (UserNode userNode : rootNode.getChildren()) {
            if (userNode.getId().equals(nodeId)) {
                return userNode;
            }
            UserNode targetUserNode = EntityBuilder.findTargetNode(nodeId, userNode);
            if (targetUserNode == null) continue;
            return targetUserNode;
        }
        return null;
    }
}

