/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.views.impl;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.cms.views.CustomizeViewPlugin;
import org.exoplatform.services.cms.views.CustomizeViewService;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class StartableCustomizeViewServiceImpl
implements Startable,
CustomizeViewService {
    protected static final Log LOG = ExoLogger.getLogger(CustomizeViewService.class);
    protected ManageViewService viewService;
    protected List<CustomizeViewPlugin> plugins = new ArrayList<CustomizeViewPlugin>();

    public StartableCustomizeViewServiceImpl(ManageViewService viewService) {
        this.viewService = viewService;
    }

    public void start() {
        this.plugins.forEach(plugin -> {
            try {
                plugin.init();
                this.viewService.getConfiguredTemplates().addAll(plugin.getConfiguredTemplates());
                this.viewService.getConfiguredViews().addAll(plugin.getConfiguredViews());
            }
            catch (Exception e) {
                LOG.error((Object)"Couldn't initialize CustomizeViewPlugin", (Throwable)e);
            }
        });
    }

    public void stop() {
    }

    @Override
    public void addCustomizeViewPlugin(ComponentPlugin plugin) {
        Class<CustomizeViewPlugin> pclass = CustomizeViewPlugin.class;
        if (pclass.isAssignableFrom(plugin.getClass())) {
            CustomizeViewPlugin customizePlugin = (CustomizeViewPlugin)((Object)pclass.cast(plugin));
            this.plugins.add(customizePlugin);
        } else {
            LOG.error((Object)("The customizeViewPlugin plugin is not an instance of " + pclass.getName()));
        }
    }
}

