/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dto;

import java.io.Serializable;
import org.exoplatform.task.domain.ChangeLog;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.service.UserService;

public class ChangeLogEntry
implements Serializable {
    private long id;
    private Task task;
    private String author;
    private String authorFullName;
    private String authorAvatarUrl;
    private String actionName;
    private String target;
    private String targetFullName;
    private boolean external;
    private boolean isTargetFullNameExternal;
    private long createdTime = System.currentTimeMillis();

    public ChangeLogEntry() {
    }

    public ChangeLogEntry(ChangeLog changeLog, UserService userService) {
        this.id = changeLog.getId();
        this.task = changeLog.getTask();
        this.author = changeLog.getAuthor();
        this.authorFullName = userService.loadUser(changeLog.getAuthor()).getDisplayName();
        this.authorAvatarUrl = userService.loadUser(changeLog.getAuthor()).getAvatar();
        this.actionName = changeLog.getActionName();
        this.target = changeLog.getTarget();
        this.targetFullName = userService.loadUser(changeLog.getTarget()).getDisplayName();
        this.createdTime = changeLog.getCreatedTime();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthorFullName() {
        return this.authorFullName;
    }

    public String getAuthorAvatarUrl() {
        return this.authorAvatarUrl;
    }

    public void setAuthorFullName(String authorFullName) {
        this.authorFullName = authorFullName;
    }

    public void setAuthorAvatarUrl(String authorAvatarUrl) {
        this.authorAvatarUrl = authorAvatarUrl;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTargetFullName() {
        return this.targetFullName;
    }

    public void setTargetFullName(String targetFullName) {
        this.targetFullName = targetFullName;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(long createdTime) {
        this.createdTime = createdTime;
    }

    public boolean getExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public boolean getIsTargetFullNameExternal() {
        return this.isTargetFullNameExternal;
    }

    public void setIsTargetFullNameExternal(boolean isTargetFullNameExternal) {
        this.isTargetFullNameExternal = isTargetFullNameExternal;
    }
}

