/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.UUID;
import org.exoplatform.portal.mop.navigation.ModelAdapter;
import org.exoplatform.portal.mop.navigation.NodeAdapter;
import org.exoplatform.portal.mop.navigation.NodeState;

class NodeAdapterImpl<N>
implements NodeAdapter<N, N> {
    private final ModelAdapter<N> delegate;
    private final IdentityHashMap<N, String> handles = new IdentityHashMap();

    NodeAdapterImpl(ModelAdapter<N> delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getName(N node) {
        return this.delegate.getName(node);
    }

    @Override
    public NodeState getState(N node) {
        return this.delegate.getState(node);
    }

    @Override
    public N getParent(N node) {
        return this.delegate.getParent(node);
    }

    @Override
    public N getPrevious(N parent, N node) {
        return this.delegate.getPrevious(parent, node);
    }

    @Override
    public void setHandle(N node, String handle) {
        this.handles.put(node, handle);
    }

    @Override
    public String getHandle(N node) {
        String handle = this.delegate.getId(node);
        if (handle == null && (handle = this.handles.get(node)) == null) {
            handle = UUID.randomUUID().toString();
            this.handles.put(node, handle);
        }
        return handle;
    }

    @Override
    public N getChildren(N node) {
        return node;
    }

    @Override
    public N getDescendant(N node, String handle) {
        Object h = this.getHandle((Object)node);
        if (((String)h).equals(handle)) {
            return node;
        }
        Iterator<N> children = this.delegate.getChildren(node, false);
        while (children.hasNext()) {
            N child = children.next();
            N descendant = this.getDescendant(child, handle);
            if (descendant == null) continue;
            return descendant;
        }
        return null;
    }

    @Override
    public int size(N list) {
        return this.delegate.size(list);
    }

    @Override
    public Iterator<String> iterator(N list, boolean reverse) {
        final Iterator<N> iterator = this.delegate.getChildren(list, reverse);
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public String next() {
                Object node = iterator.next();
                return NodeAdapterImpl.this.getHandle(node);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

