/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.spi.portlet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Preference
implements Serializable {
    private final String name;
    private final List<String> values;
    private final boolean readOnly;

    public Preference(String name, List<String> values, boolean readOnly) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (values == null) {
            throw new NullPointerException();
        }
        if ((values = Collections.unmodifiableList(new ArrayList<String>(values))).size() == 0) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.values = values;
        this.readOnly = readOnly;
    }

    public Preference(String name, String value, boolean readOnly) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.values = Collections.singletonList(value);
        this.readOnly = readOnly;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.values.get(0);
    }

    public List<String> getValues() {
        return this.values;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Preference) {
            Preference that = (Preference)obj;
            return this.name.equals(that.name) && this.getValues().equals(that.getValues());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.values.hashCode() ^ (this.readOnly ? -1 : 0);
    }

    public String toString() {
        return "Preference[name=" + this.name + ",values=" + this.values + ",readOnly=" + this.readOnly + "]";
    }
}

