/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.externalstore;

import java.time.LocalDateTime;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.externalstore.IDMExternalStoreImportService;
import org.exoplatform.services.organization.externalstore.IDMExternalStoreService;
import org.exoplatform.services.organization.externalstore.IDMQueueService;
import org.exoplatform.services.organization.externalstore.model.IDMEntityType;
import org.exoplatform.services.organization.externalstore.model.IDMOperationType;
import org.exoplatform.services.organization.externalstore.model.IDMQueueEntry;
import org.picocontainer.Startable;

@Managed
@ManagedDescription(value="eXo Platform - IDM External Store")
@NameTemplate(value={@Property(key="service", value="idm"), @Property(key="name", value="IDMExternalStoreService")})
@RESTEndpoint(path="idm.externalstore")
public class IDMExternalStoreManagedBean
implements Startable {
    private IDMExternalStoreService externalStoreService;
    private OrganizationService organizationService;
    private IDMExternalStoreImportService externalStoreImportService;
    private IDMQueueService idmQueueService;

    @Managed
    @ManagedDescription(value="Returns modified entries on external store")
    @Impact(value=ImpactType.READ)
    public String listModifiedEntriesOnExternalStore() throws Exception {
        StringBuffer result = new StringBuffer();
        this.begin();
        try {
            this.getExternalStoreImportService().checkModifiedEntitiesOfType(IDMEntityType.USER, externalUsername -> {
                try {
                    User internalStoreUser = this.getOrganizationService().getUserHandler().findUserByName((String)externalUsername, UserStatus.ANY);
                    if (internalStoreUser == null) {
                        result.append("User Added: ");
                        result.append((String)externalUsername);
                        result.append("\r\n");
                    } else if (this.getExternalStoreService().isEntityModified(IDMEntityType.USER, (String)externalUsername)) {
                        result.append("User Modified: ");
                        result.append((String)externalUsername);
                        result.append("\r\n");
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, false);
            this.getExternalStoreImportService().checkModifiedEntitiesOfType(IDMEntityType.GROUP, externalGroupId -> {
                try {
                    Group internalStoreGroup = this.getOrganizationService().getGroupHandler().findGroupById((String)externalGroupId);
                    if (internalStoreGroup == null) {
                        result.append("Group Added: ");
                        result.append((String)externalGroupId);
                        result.append("\r\n");
                    } else {
                        result.append("Group and/or memberships Modified: ");
                        result.append((String)externalGroupId);
                        result.append("\r\n");
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, false);
        }
        finally {
            this.end();
        }
        return result.toString();
    }

    @Managed
    @ManagedDescription(value="Returns deleted entries from external store")
    @Impact(value=ImpactType.READ)
    public String listDeletedEntriesOnExternalStore() throws Exception {
        StringBuffer result = new StringBuffer();
        this.begin();
        try {
            this.getExternalStoreImportService().checkDeletedEntitiesOfType(IDMEntityType.USER, externalUsername -> {
                try {
                    result.append("User Deleted: ");
                    result.append((String)externalUsername);
                    result.append("\r\n");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            this.getExternalStoreImportService().checkDeletedEntitiesOfType(IDMEntityType.GROUP, externalGroupId -> {
                try {
                    result.append("Group Deleted: ");
                    result.append((String)externalGroupId);
                    result.append("\r\n");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        finally {
            this.end();
        }
        return result.toString();
    }

    @Managed
    @ManagedDescription(value="Check modified entries and import them to IDM Queue")
    @Impact(value=ImpactType.READ)
    public void importModifiedEntriesToQueue() throws Exception {
        this.begin();
        try {
            this.getExternalStoreImportService().importAllModifiedEntitiesToQueue();
        }
        finally {
            this.end();
        }
    }

    @Managed
    @ManagedDescription(value="Force Import all entities of type : 1 = User / 2 = Group / 3 = MembershipType")
    @Impact(value=ImpactType.READ)
    public void forceImportAllEntitiesToQueue(@ManagedDescription(value="Entity type index, 1 = User / 2 = Group / 3 = MembershipType") @ManagedName(value="entityType") String entityType) {
        this.begin();
        try {
            this.getExternalStoreImportService().forceUpdateEntitiesOfType(IDMEntityType.getEntityType(Integer.parseInt(entityType)));
        }
        finally {
            this.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    @ManagedDescription(value="Force Import a specific entity identified by its id and type : 1 = User / 2 = Group / 3 = MembershipType")
    @Impact(value=ImpactType.READ)
    public void forceImportEntity(@ManagedDescription(value="Entity type index, 1 = User / 2 = Group / 3 = MembershipType") @ManagedName(value="entityType") String entityType, @ManagedDescription(value="Entity id") @ManagedName(value="entityId") String entityId) throws Exception {
        this.begin();
        try {
            IDMEntityType<?> entityTypeObj = IDMEntityType.getEntityType(Integer.parseInt(entityType));
            this.getExternalStoreImportService().importEntityToInternalStore(entityTypeObj, entityId, true, true);
            if (IDMEntityType.GROUP.equals(entityTypeObj)) {
                this.getExternalStoreImportService().importEntityToInternalStore(IDMEntityType.GROUP_MEMBERSHIPS, entityId, true, true);
            }
        }
        finally {
            this.end();
        }
    }

    @Managed
    @ManagedDescription(value="Check deleted entries from external store, that exists on internal store and import them to IDM Queue")
    @Impact(value=ImpactType.READ)
    public void importDeletedEntriesToQueue() throws Exception {
        this.begin();
        try {
            this.getExternalStoreImportService().checkAllEntitiesToDeleteIntoQueue();
        }
        finally {
            this.end();
        }
    }

    @Managed
    @ManagedDescription(value="Purge processed queue entries")
    @Impact(value=ImpactType.READ)
    public void deleteProcessedEntriesFromQueue() throws Exception {
        this.getIdmQueueService().deleteProcessedEntries();
    }

    @Managed
    @ManagedDescription(value="Purge queue entries which number of retries has exceeded maxRetries")
    @Impact(value=ImpactType.READ)
    public void deleteExceededRetriesEntriesFromQueue() throws Exception {
        this.getIdmQueueService().deleteExceededRetriesEntries();
    }

    @Managed
    @ManagedDescription(value="Process IDM Queue: delete, update and creation operations of IDM entities")
    @Impact(value=ImpactType.READ)
    public void processQueue() {
        this.begin();
        try {
            this.getExternalStoreImportService().processQueueEntries();
        }
        finally {
            this.end();
        }
    }

    @Managed
    @ManagedDescription(value="Get current Queue size by counting only valid entries that aren't processed yet and that have nbRetries < maxRetries")
    @Impact(value=ImpactType.READ)
    public int countAllValidQueueEntries() throws Exception {
        this.begin();
        try {
            int n = this.getIdmQueueService().countAll();
            return n;
        }
        finally {
            this.end();
        }
    }

    @Managed
    @ManagedDescription(value="Get Queue entries count corresponding to nbRetries")
    @Impact(value=ImpactType.READ)
    public int countQueueEntries(@ManagedDescription(value="Number of retries of queue entries") @ManagedName(value="nbRetries") String nbRetries) throws Exception {
        this.begin();
        try {
            int n = this.getIdmQueueService().count(Integer.parseInt(nbRetries));
            return n;
        }
        finally {
            this.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    @ManagedDescription(value="Get Queue entries count corresponding to nbRetries")
    @Impact(value=ImpactType.READ)
    public String displayQueueEntries(@ManagedDescription(value="Number of retries of queue entries") @ManagedName(value="nbRetries") String nbRetries, @ManagedDescription(value="Number of queue entries to display") @ManagedName(value="limit") String limit) throws Exception {
        StringBuilder result = new StringBuilder();
        this.begin();
        try {
            List<IDMQueueEntry> entries = this.getIdmQueueService().pop(Integer.parseInt(limit), Integer.parseInt(nbRetries), false);
            for (IDMQueueEntry idmQueueEntry : entries) {
                if (idmQueueEntry.getOperationType() == IDMOperationType.ADD_OR_UPDATE) {
                    result.append("Add/Modify ");
                } else if (idmQueueEntry.getEntityType() == IDMEntityType.GROUP) {
                    result.append("Delete ");
                }
                if (idmQueueEntry.getEntityType() == IDMEntityType.USER) {
                    result.append("user '");
                } else if (idmQueueEntry.getEntityType() == IDMEntityType.GROUP) {
                    result.append("group '");
                } else if (idmQueueEntry.getEntityType() == IDMEntityType.ROLE) {
                    result.append("role '");
                }
                result.append(idmQueueEntry.getEntityId()).append("'");
                result.append("\n");
            }
        }
        finally {
            this.end();
        }
        return result.toString();
    }

    @Managed
    @ManagedDescription(value="Retrieves IDM Queue entries processing max retries")
    @Impact(value=ImpactType.READ)
    public int retrieveMaxRetries() {
        return this.getIdmQueueService().getMaxRetries();
    }

    @Managed
    @ManagedDescription(value="Get last checked time of EntityType: 1 = User / 2 = Group / 3 = MembershipType")
    @Impact(value=ImpactType.READ)
    public LocalDateTime retrieveLastCheckedTimeForType(@ManagedDescription(value="Entity type index, 1 = User / 2 = Group / 3 = MembershipType") @ManagedName(value="entityType") String entityType) throws Exception {
        this.begin();
        try {
            LocalDateTime localDateTime = this.getIdmQueueService().getLastCheckedTime(IDMEntityType.getEntityType(Integer.parseInt(entityType)));
            return localDateTime;
        }
        finally {
            this.end();
        }
    }

    public void start() {
    }

    public void stop() {
    }

    private OrganizationService getOrganizationService() {
        if (this.organizationService == null) {
            this.organizationService = IDMExternalStoreManagedBean.getService(OrganizationService.class);
        }
        return this.organizationService;
    }

    private IDMExternalStoreImportService getExternalStoreImportService() {
        if (this.externalStoreImportService == null) {
            this.externalStoreImportService = IDMExternalStoreManagedBean.getService(IDMExternalStoreImportService.class);
        }
        return this.externalStoreImportService;
    }

    private IDMExternalStoreService getExternalStoreService() {
        if (this.externalStoreService == null) {
            this.externalStoreService = IDMExternalStoreManagedBean.getService(IDMExternalStoreService.class);
        }
        return this.externalStoreService;
    }

    private IDMQueueService getIdmQueueService() {
        if (this.idmQueueService == null) {
            this.idmQueueService = IDMExternalStoreManagedBean.getService(IDMQueueService.class);
        }
        return this.idmQueueService;
    }

    private static <T> T getService(Class<T> clazz) {
        return clazz.cast(IDMExternalStoreManagedBean.getContainer().getComponentInstanceOfType(clazz));
    }

    private static ExoContainer getContainer() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container instanceof RootContainer) {
            container = PortalContainer.getInstance();
        }
        return container;
    }

    private void begin() {
        ExoContainer container = IDMExternalStoreManagedBean.getContainer();
        RequestLifeCycle.begin((ExoContainer)container);
        if (container instanceof PortalContainer) {
            ClassLoader classLoader = ((PortalContainer)container).getPortalClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private void end() {
        RequestLifeCycle.end();
    }
}

