/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.protocols.FcHeader;
import org.jgroups.protocols.FlowControl;
import org.jgroups.util.CreditMap;
import org.jgroups.util.Tuple;

@MBean(description="Simple flow control protocol based on a credit system")
public class MFC
extends FlowControl {
    protected static final FcHeader MFC_REPLENISH_HDR = new FcHeader(1);
    protected static final FcHeader MFC_CREDIT_REQUEST_HDR = new FcHeader(2);
    protected CreditMap credits;
    protected long last_credit_request;

    @Override
    @ManagedOperation(description="Unblock a sender")
    public void unblock() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("unblocking the sender and replenishing all members");
        }
        this.credits.replenishAll();
    }

    @Override
    @ManagedOperation(description="Print credits")
    public String printCredits() {
        return super.printCredits() + "\nsenders min credits: " + this.credits.computeLowestCreditWithAccumulated();
    }

    @Override
    @ManagedOperation(description="Print sender credits")
    public String printSenderCredits() {
        return this.credits.toString();
    }

    @Override
    @ManagedAttribute(description="Number of times flow control blocks sender")
    public int getNumberOfBlockings() {
        return this.credits.getNumBlockings();
    }

    @Override
    @ManagedAttribute(description="Average time blocked (in ms) in flow control when trying to send a message")
    public double getAverageTimeBlocked() {
        return this.credits.getAverageBlockTime();
    }

    @Override
    protected boolean handleMulticastMessage() {
        return true;
    }

    @Override
    protected Header getReplenishHeader() {
        return MFC_REPLENISH_HDR;
    }

    @Override
    protected Header getCreditRequestHeader() {
        return MFC_CREDIT_REQUEST_HDR;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.credits = new CreditMap(this.max_credits);
    }

    @Override
    public void stop() {
        super.stop();
        this.credits.clear();
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.credits.reset();
    }

    @Override
    protected Object handleDownMessage(Event evt, Message msg, Address dest, int length) {
        boolean rc;
        long block_time;
        if (dest != null) {
            return this.down_prot.down(evt);
        }
        long l = block_time = this.max_block_times != null ? this.getMaxBlockTime(length) : this.max_block_time;
        while (this.running && !(rc = this.credits.decrement(length, block_time)) && this.max_block_times == null && this.running) {
            if (!this.needToSendCreditRequest()) continue;
            List<Tuple<Address, Long>> targets = this.credits.getMembersWithCreditsLessThan(this.min_credits);
            for (Tuple<Address, Long> tuple : targets) {
                this.sendCreditRequest(tuple.getVal1(), Math.min(this.max_credits, this.max_credits - tuple.getVal2()));
            }
        }
        return this.down_prot.down(evt);
    }

    protected synchronized boolean needToSendCreditRequest() {
        long current_time = System.nanoTime();
        if (current_time - this.last_credit_request >= TimeUnit.NANOSECONDS.convert(this.max_block_time, TimeUnit.MILLISECONDS)) {
            this.last_credit_request = current_time;
            return true;
        }
        return false;
    }

    @Override
    protected void handleCredit(Address sender, long increase) {
        this.credits.replenish(sender, increase);
        if (this.log.isTraceEnabled()) {
            this.log.trace("received %d credits from %s, new credits for %s: %d, min_credits=%d", increase, sender, sender, this.credits.get(sender), this.credits.getMinCredits());
        }
    }

    @Override
    protected void handleViewChange(List<Address> mbrs) {
        super.handleViewChange(mbrs);
        HashSet<Address> keys = new HashSet<Address>(this.credits.keys());
        for (Address key : keys) {
            if (mbrs.contains(key)) continue;
            this.credits.remove(key);
        }
        for (Address key : mbrs) {
            this.credits.putIfAbsent(key);
        }
    }
}

