/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application.localization;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;

public class DefaultLocalePolicyService
implements LocalePolicy {
    private static final String USE_DEFAULT_SITE_LANGUAGE_PARAM = "useDefaultSiteLanguage";
    private LocaleConfigService localeConfigService;
    private boolean useDefaultSiteLanguage;

    public DefaultLocalePolicyService(LocaleConfigService localeConfigService, InitParams params) {
        this.localeConfigService = localeConfigService;
        if (params != null && params.containsKey((Object)USE_DEFAULT_SITE_LANGUAGE_PARAM)) {
            this.useDefaultSiteLanguage = Boolean.parseBoolean(params.getValueParam(USE_DEFAULT_SITE_LANGUAGE_PARAM).getValue());
        }
    }

    public Locale determineLocale(LocaleContextInfo context) {
        if (context.getRequestLocale() != null) {
            return context.getRequestLocale();
        }
        Locale locale = null;
        locale = context.getRemoteUser() == null ? this.getLocaleConfigForAnonymous(context) : this.getLocaleConfigForRegistered(context);
        if (locale == null) {
            locale = this.useDefaultSiteLanguage ? context.getPortalLocale() : this.localeConfigService.getDefaultLocaleConfig().getLocale();
        } else {
            Set supportedLocales = context.getSupportedLocales();
            if (supportedLocales == null) {
                supportedLocales = this.localeConfigService.getLocalConfigs().stream().map(LocaleConfig::getLocale).collect(Collectors.toSet());
            }
            if (!supportedLocales.contains(locale) && StringUtils.isNotBlank((String)locale.getVariant())) {
                locale = new Locale(locale.getLanguage(), locale.getCountry());
            }
            if (!supportedLocales.contains(locale) && StringUtils.isNotBlank((String)locale.getCountry())) {
                locale = new Locale(locale.getLanguage());
            }
            if (!supportedLocales.contains(locale)) {
                locale = this.localeConfigService.getDefaultLocaleConfig().getLocale();
            }
        }
        return locale;
    }

    protected Locale getLocaleConfigForRegistered(LocaleContextInfo context) {
        Locale locale = context.getLocaleIfLangSupported(context.getUserProfileLocale());
        if (locale == null) {
            locale = this.getLocaleConfigFromCookie(context);
        }
        if (locale == null) {
            locale = this.getLocaleConfigFromSession(context);
        }
        if (locale == null) {
            locale = this.getLocaleConfigFromBrowser(context);
        }
        return locale;
    }

    protected Locale getLocaleConfigFromBrowser(LocaleContextInfo context) {
        List locales = context.getBrowserLocales();
        if (locales != null && !locales.isEmpty()) {
            return context.getLocaleIfLangSupported((Locale)locales.get(0));
        }
        return null;
    }

    protected Locale getLocaleConfigForAnonymous(LocaleContextInfo context) {
        Locale locale = this.getLocaleConfigFromCookie(context);
        if (locale == null) {
            locale = this.getLocaleConfigFromSession(context);
        }
        if (locale == null) {
            locale = this.getLocaleConfigFromBrowser(context);
        }
        return locale;
    }

    protected Locale getLocaleConfigFromSession(LocaleContextInfo context) {
        return context.getSessionLocale();
    }

    protected Locale getLocaleConfigFromCookie(LocaleContextInfo context) {
        List locales = context.getCookieLocales();
        if (locales != null && !locales.isEmpty()) {
            return context.getLocaleIfLangSupported((Locale)locales.get(0));
        }
        return null;
    }
}

