/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;

public class OrganizationIdentityProvider
extends IdentityProvider<User> {
    private static final Log LOG = ExoLogger.getLogger((String)"organization");
    private OrganizationService organizationService;
    public static final String NAME = "organization";

    public OrganizationIdentityProvider(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    public String getName() {
        return NAME;
    }

    @Deprecated(forRemoval=true, since="the begining")
    public List<String> getAllUserId() {
        try {
            ListAccess allUsers = this.organizationService.getUserHandler().findAllUsers();
            int MAX_USERS = 500;
            User[] users = (User[])allUsers.load(0, allUsers.getSize() >= 500 ? 500 : allUsers.getSize());
            ArrayList<String> userIds = new ArrayList<String>();
            for (User user : users) {
                userIds.add(user.getUserName());
            }
            return userIds;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load all users");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User findByRemoteId(String remoteId) {
        User user;
        try {
            RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)this.organizationService));
            user = this.organizationService.getUserHandler().findUserByName(remoteId, UserStatus.ANY);
        }
        catch (Exception e) {
            LOG.warn((Object)"An error occurred while getting identity from store", (Throwable)e);
            User user2 = null;
            return user2;
        }
        finally {
            RequestLifeCycle.end();
        }
        return user;
    }

    public Identity createIdentity(User user) {
        Identity identity = new Identity(NAME, user.getUserName());
        identity.setEnable(user.isEnabled());
        return identity;
    }

    public void populateProfile(Profile profile, User user) {
        profile.setProperty("firstName", (Object)user.getFirstName());
        profile.setProperty("lastName", (Object)user.getLastName());
        profile.setProperty("fullName", (Object)user.getDisplayName());
        profile.setProperty("username", (Object)user.getUserName());
        profile.setProperty("email", (Object)user.getEmail());
        try {
            Map attributes;
            UserProfile userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName(user.getUserName());
            if (userProfile != null && (attributes = userProfile.getUserInfoMap()) != null && !attributes.isEmpty()) {
                Set entries = attributes.entrySet();
                for (Map.Entry entry : entries) {
                    String key = (String)entry.getKey();
                    if (key == null || profile.getProperty(key) != null) continue;
                    profile.setProperty(key, entry.getValue());
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to retrieve additional user profile attributes");
        }
    }

    public void onUpdateProfile(Profile profile) {
        new UpdateProfileProcess(profile).doUpdate();
    }

    private class UpdateProfileProcess {
        private Profile updatedProfile = null;
        private String userName = null;

        public UpdateProfileProcess(Profile updatedProfile) {
            this.updatedProfile = updatedProfile;
            this.userName = (String)updatedProfile.getProperty("username");
        }

        public void doUpdate() {
            try {
                if (this.updatedProfile.getListUpdateTypes().contains(Profile.UpdateType.CONTACT)) {
                    this.updateBasicInfo();
                    this.updateContact();
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Failed to update user by profile", (Throwable)e);
            }
        }

        private void updateBasicInfo() throws Exception {
            String firstName = (String)this.updatedProfile.getProperty("firstName");
            String lastName = (String)this.updatedProfile.getProperty("lastName");
            String email = (String)this.updatedProfile.getProperty("email");
            String fullName = firstName + " " + lastName;
            boolean hasUpdate = false;
            User foundUser = OrganizationIdentityProvider.this.organizationService.getUserHandler().findUserByName(this.userName);
            if (foundUser == null) {
                return;
            }
            if (!StringUtils.equals((CharSequence)foundUser.getFirstName(), (CharSequence)firstName)) {
                foundUser.setFirstName(firstName);
                hasUpdate = true;
            }
            if (!StringUtils.equals((CharSequence)foundUser.getLastName(), (CharSequence)lastName)) {
                foundUser.setLastName(lastName);
                hasUpdate = true;
            }
            if (!StringUtils.equals((CharSequence)foundUser.getEmail(), (CharSequence)email)) {
                foundUser.setEmail(email);
                hasUpdate = true;
            }
            if (!StringUtils.equals((CharSequence)foundUser.getDisplayName(), (CharSequence)fullName)) {
                foundUser.setDisplayName(fullName);
                hasUpdate = true;
            }
            if (hasUpdate) {
                OrganizationIdentityProvider.this.organizationService.getUserHandler().saveUser(foundUser, true);
            }
        }

        private void updateContact() throws Exception {
            String uExternal;
            String uGender;
            String position = (String)this.updatedProfile.getProperty("position");
            String gender = (String)this.updatedProfile.getProperty("gender");
            String external = (String)this.updatedProfile.getProperty("external");
            UserProfile foundUserProfile = OrganizationIdentityProvider.this.organizationService.getUserProfileHandler().findUserProfileByName(this.userName);
            if (foundUserProfile == null) {
                foundUserProfile = OrganizationIdentityProvider.this.organizationService.getUserProfileHandler().createUserProfileInstance(this.userName);
            }
            boolean hasUpdated = false;
            String uPosition = foundUserProfile.getAttribute(UserProfile.PERSONAL_INFO_KEYS[7]);
            if (!StringUtils.equals((CharSequence)position, (CharSequence)uPosition)) {
                foundUserProfile.setAttribute(UserProfile.PERSONAL_INFO_KEYS[7], position);
                hasUpdated = true;
            }
            if (!StringUtils.equals((CharSequence)gender, (CharSequence)(uGender = foundUserProfile.getAttribute(UserProfile.PERSONAL_INFO_KEYS[4])))) {
                foundUserProfile.setAttribute(UserProfile.PERSONAL_INFO_KEYS[4], gender);
                hasUpdated = true;
            }
            if (!StringUtils.equals((CharSequence)external, (CharSequence)(uExternal = foundUserProfile.getAttribute(UserProfile.OTHER_KEYS[2])))) {
                foundUserProfile.setAttribute(UserProfile.OTHER_KEYS[2], external);
                hasUpdated = true;
            }
            if (hasUpdated) {
                OrganizationIdentityProvider.this.organizationService.getUserProfileHandler().saveUserProfile(foundUserProfile, false);
            }
        }
    }
}

