/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage.cache;

import java.io.Serializable;
import java.util.List;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.mop.SiteFilter;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.dao.SiteDAO;
import org.exoplatform.portal.mop.storage.LayoutStorage;
import org.exoplatform.portal.mop.storage.NavigationStorage;
import org.exoplatform.portal.mop.storage.PageStorage;
import org.exoplatform.portal.mop.storage.SiteStorageImpl;
import org.exoplatform.portal.pom.data.PortalData;
import org.exoplatform.portal.pom.data.PortalKey;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.upload.UploadService;

public class CacheSiteStorage
extends SiteStorageImpl {
    public static final String SITE_CACHE_NAME = "portal.SiteService";
    public static final String SITE_KEYS_BY_FILTER_CACHE_NAME = "portal.SiteKeysByFilterService";
    private final FutureExoCache<SiteKey, PortalData, Object> siteFutureCache;
    private final ExoCache<SiteKey, PortalData> siteCache;
    private final FutureExoCache<SiteFilter, Object, Object> siteKeysByFilterFutureCache;
    private final ExoCache<SiteFilter, Object> siteKeysByFilterCache;

    public CacheSiteStorage(CacheService cacheService, SettingService settingService, ConfigurationManager configurationManager, NavigationStorage navigationStorage, PageStorage pageStorage, LayoutStorage layoutStorage, SiteDAO siteDAO, UploadService uploadService, FileService fileService) {
        super(settingService, configurationManager, navigationStorage, pageStorage, layoutStorage, siteDAO, uploadService, fileService);
        this.siteCache = cacheService.getCacheInstance(SITE_CACHE_NAME);
        this.siteFutureCache = new FutureExoCache((Loader)new Loader<SiteKey, PortalData, Object>(){

            public PortalData retrieve(Object context, SiteKey siteKey) throws Exception {
                PortalData portalData = CacheSiteStorage.super.getPortalConfig(siteKey);
                return portalData == null ? PortalData.NULL_OBJECT : portalData;
            }
        }, this.siteCache);
        this.siteKeysByFilterCache = cacheService.getCacheInstance(SITE_KEYS_BY_FILTER_CACHE_NAME);
        this.siteKeysByFilterFutureCache = new FutureExoCache((Loader)new Loader<SiteFilter, Object, Object>(){

            public List<SiteKey> retrieve(Object context, SiteFilter siteFilter) throws Exception {
                return CacheSiteStorage.super.getSitesKeys(siteFilter);
            }
        }, this.siteKeysByFilterCache);
    }

    @Override
    public void create(PortalData config) {
        try {
            super.create(config);
        }
        finally {
            this.siteFutureCache.remove((Serializable)this.getSiteKey(config.getKey()));
            this.clearSiteKeysByFilterFutureCache();
        }
    }

    @Override
    public void save(PortalData config) {
        try {
            super.save(config);
        }
        finally {
            this.siteFutureCache.remove((Serializable)this.getSiteKey(config.getKey()));
            this.clearSiteKeysByFilterFutureCache();
        }
    }

    @Override
    public void remove(PortalData config) {
        try {
            super.remove(config);
        }
        finally {
            this.siteFutureCache.remove((Serializable)this.getSiteKey(config.getKey()));
            this.clearSiteKeysByFilterFutureCache();
        }
    }

    @Override
    public PortalData getPortalConfig(SiteKey key) {
        PortalData portalData = (PortalData)this.siteFutureCache.get(null, (Object)key);
        return portalData == null || portalData.isNull() ? null : portalData;
    }

    @Override
    public List<SiteKey> getSitesKeys(SiteFilter siteFilter) {
        return (List)this.siteKeysByFilterFutureCache.get(null, (Object)siteFilter);
    }

    private SiteKey getSiteKey(PortalKey portalKey) {
        return new SiteKey(portalKey.getType(), portalKey.getId());
    }

    private void clearSiteKeysByFilterFutureCache() {
        this.siteKeysByFilterFutureCache.clear();
    }
}

