/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.compiler.scopes.FullMixinDefinition;
import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.compiler.scopes.ScopeFactory;
import com.github.sommeri.less4j.core.compiler.scopes.view.ScopeView;
import java.util.ArrayList;
import java.util.List;

public class CallerCalleeScopeJoiner {
    public ScopeView joinIfIndependentAndPreserveContent(IScope callerScope, IScope bodyScope) {
        ScopeView result = this.joinIfIndependent(callerScope, bodyScope);
        result.toIndependentWorkingCopyAllParents();
        return result;
    }

    public ScopeView joinIfIndependent(IScope callerScope, IScope bodyScope) {
        boolean isLocallyDefined = this.isLocallyDefined(callerScope, bodyScope);
        if (isLocallyDefined) {
            return ScopeFactory.createSaveableView(bodyScope);
        }
        ScopeView result = ScopeFactory.createJoinedScopesView(callerScope, bodyScope);
        return result;
    }

    private boolean isLocallyDefined(IScope callerScope, IScope bodyScope) {
        boolean isLocallyDefined = true;
        for (IScope checkScope = callerScope; isLocallyDefined && checkScope != null; checkScope = checkScope.getParent()) {
            isLocallyDefined = bodyScope.seesLocalDataOf(checkScope);
        }
        return isLocallyDefined;
    }

    public List<FullMixinDefinition> mixinsToImport(IScope callerScope, IScope calleeScope, List<FullMixinDefinition> unmodifiedMixinsToImport) {
        ArrayList<FullMixinDefinition> result = new ArrayList<FullMixinDefinition>();
        for (FullMixinDefinition mixinToImport : unmodifiedMixinsToImport) {
            boolean isLocalImport = this.isLocallyDefined(calleeScope, mixinToImport.getScope());
            ScopeView newScope = null;
            newScope = isLocalImport ? ScopeFactory.createSaveableView(mixinToImport.getScope()) : ScopeFactory.createJoinedScopesView(calleeScope, mixinToImport.getScope());
            newScope.toIndependentWorkingCopyAllParents();
            result.add(new FullMixinDefinition(mixinToImport.getMixin(), newScope));
        }
        return result;
    }
}

