/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.ldap;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.SortControl;
import org.apache.commons.lang3.StringUtils;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.NotYetImplementedException;
import org.picketlink.idm.impl.configuration.ExoIdentityStoreConfigurationContext;
import org.picketlink.idm.impl.helper.Tools;
import org.picketlink.idm.impl.model.ldap.LDAPIdentityObjectImpl;
import org.picketlink.idm.impl.store.ldap.LDAPIdentityObjectTypeConfiguration;
import org.picketlink.idm.impl.store.ldap.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.impl.store.ldap.LDAPIdentityStoreImpl;
import org.picketlink.idm.impl.store.ldap.SerializableSearchResult;
import org.picketlink.idm.spi.configuration.IdentityStoreConfigurationContext;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectRelationshipType;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.search.IdentityObjectSearchCriteria;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;

public class ExoLDAPIdentityStoreImpl
extends LDAPIdentityStoreImpl {
    public static final String MODIFICATION_DATE_SINCE = "modificationDateSince";
    private static Logger log = Logger.getLogger(LDAPIdentityStoreImpl.class.getName());

    public ExoLDAPIdentityStoreImpl(String id) {
        super(id);
    }

    public void bootstrap(IdentityStoreConfigurationContext configurationContext) throws IdentityException {
        ExoIdentityStoreConfigurationContext exoIdentityStoreConfigurationContext = new ExoIdentityStoreConfigurationContext(configurationContext);
        super.bootstrap((IdentityStoreConfigurationContext)exoIdentityStoreConfigurationContext);
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext ctx, String id) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            Tools.logMethodIn((Logger)log, (Level)Level.FINER, (String)"findIdentityObject", (Object[])new Object[]{"id", id});
        }
        LdapContext ldapContext = this.getLDAPContext(ctx);
        try {
            List<SerializableSearchResult> searchResult;
            if (id == null) {
                throw new IdentityException("identity id cannot be null");
            }
            String dn = id;
            IdentityObjectType type = null;
            IdentityObjectType[] possibleTypes = this.getConfiguration(ctx).getConfiguredTypes();
            HashSet<IdentityObjectType> matches = new HashSet<IdentityObjectType>();
            block16: for (IdentityObjectType possibleType : possibleTypes) {
                String[] typeCtxs;
                for (String typeCtx : typeCtxs = this.getTypeConfiguration(ctx, possibleType).getCtxDNs()) {
                    if (!StringUtils.isNotBlank((CharSequence)typeCtx) || !Tools.dnEndsWith((String)dn, (String)typeCtx)) continue;
                    matches.add(possibleType);
                    continue block16;
                }
            }
            if (matches.size() == 1) {
                type = (IdentityObjectType)matches.iterator().next();
            } else if (matches.size() > 1) {
                searchResult = null;
                for (IdentityObjectType possibleTypeMatch : matches) {
                    String idAttributeName;
                    LDAPIdentityObjectTypeConfiguration typeConfiguration = this.getTypeConfiguration(ctx, possibleTypeMatch);
                    Name jndiName = new CompositeName().add(dn);
                    Attributes attrs = ldapContext.getAttributes(jndiName);
                    Attribute nameAttribute = attrs.get(idAttributeName = typeConfiguration.getIdAttributeName());
                    if (nameAttribute == null) continue;
                    String filter = this.getTypeConfiguration(ctx, possibleTypeMatch).getEntrySearchFilter();
                    String[] entryCtxs = this.getTypeConfiguration(ctx, possibleTypeMatch).getCtxDNs();
                    String scope = this.getTypeConfiguration(ctx, possibleTypeMatch).getEntrySearchScope();
                    String name = nameAttribute.get().toString();
                    Object[] filterArgs = new Object[]{name};
                    if (filter != null) {
                        searchResult = this.searchIdentityObjects(ctx, entryCtxs, filter, filterArgs, new String[]{idAttributeName}, scope, null);
                        if (searchResult.size() <= 0) continue;
                        type = possibleTypeMatch;
                        break;
                    }
                    LDAPIdentityObjectImpl entry = (LDAPIdentityObjectImpl)this.findIdentityObject(ctx, name, possibleTypeMatch);
                    if (entry == null || !Tools.dnEquals((String)entry.getDn(), (String)dn)) continue;
                    type = possibleTypeMatch;
                    break;
                }
            }
            if (type == null) {
                searchResult = null;
                return searchResult;
            }
            Name jndiName = new CompositeName().add(dn);
            Attributes attrs = ldapContext.getAttributes(jndiName);
            if (attrs == null) {
                throw new IdentityException("Can't find identity entry with DN: " + dn);
            }
            LDAPIdentityObjectImpl result = this.createIdentityObjectInstance(ctx, type, attrs, dn);
            if (log.isLoggable(Level.FINER)) {
                Tools.logMethodOut((Logger)log, (Level)Level.FINER, (String)"findIdentityObject", (Object)result);
            }
            LDAPIdentityObjectImpl lDAPIdentityObjectImpl = result;
            return lDAPIdentityObjectImpl;
        }
        catch (NoSuchElementException dn) {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Exception occurred: ", e);
                }
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
            }
        }
        catch (NamingException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Identity object search failed.", (Throwable)e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Exception occurred: ", e);
                }
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
            }
        }
        if (log.isLoggable(Level.FINER)) {
            Tools.logMethodOut((Logger)log, (Level)Level.FINER, (String)"findIdentityObject", null);
        }
        return null;
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, Collection<IdentityObjectType> excludes, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            Tools.logMethodIn((Logger)log, (Level)Level.FINER, (String)"findIdentityObject", (Object[])new Object[]{"IdentityObject", identity, "IdentityObjectRelationshipType", relationshipType, "parent", parent, "IdentityObjectSearchCriteria", criteria});
        }
        if (relationshipType != null && !relationshipType.getName().equals("JBOSS_IDENTITY_MEMBERSHIP")) {
            throw new IdentityException("This store implementation supports only 'JBOSS_IDENTITY_MEMBERSHIP' relationship type");
        }
        LDAPIdentityObjectImpl ldapIO = this.getSafeLDAPIO(ctx, identity);
        LDAPIdentityObjectTypeConfiguration typeConfig = this.getTypeConfiguration(ctx, identity.getIdentityType());
        LdapContext ldapContext = this.getLDAPContext(ctx);
        List<Object> objects = new LinkedList<IdentityObject>();
        try {
            if (parent) {
                if (StringUtils.isNotBlank((CharSequence)typeConfig.getParentMembershipAttributeName())) {
                    jndiName = new CompositeName().add(ldapIO.getDn());
                    Attributes attrs = ldapContext.getAttributes(jndiName);
                    Attribute member = attrs.get(typeConfig.getParentMembershipAttributeName());
                    if (member != null) {
                        NamingEnumeration<?> memberValues = member.getAll();
                        while (memberValues.hasMoreElements()) {
                            String memberRef = memberValues.nextElement().toString();
                            String placeholder = typeConfig.getParentMembershipAttributePlaceholder();
                            if (placeholder != null && memberRef.equalsIgnoreCase(placeholder)) continue;
                            if (typeConfig.isParentMembershipAttributeDN()) {
                                IdentityObject identityObject = this.findIdentityObject(ctx, memberRef);
                                if (identityObject == null) continue;
                                if (criteria != null && criteria.getFilter() != null) {
                                    String name = Tools.stripDnToName((String)memberRef);
                                    String regex = Tools.wildcardToRegex((String)criteria.getFilter());
                                    if (!Pattern.matches(regex, name)) continue;
                                    objects.add(identityObject);
                                    continue;
                                }
                                objects.add(identityObject);
                                continue;
                            }
                            throw new NotYetImplementedException("LDAP limitation. If relationship targets are not refered with FQDNs and only names, it's not possible to map them to proper IdentityType and keep name uniqnes per type. Workaround needed");
                        }
                    }
                } else {
                    objects.addAll(this.findRelatedIdentityObjects(ctx, identity, ldapIO, criteria, false));
                }
            } else if (StringUtils.isBlank((CharSequence)typeConfig.getChildMembershipAttributeName())) {
                if (ldapIO != null) {
                    objects.addAll(this.findRelatedIdentityObjects(ctx, identity, ldapIO, criteria, true));
                }
            } else {
                jndiName = new CompositeName().add(ldapIO.getDn());
                Attributes attrs = ldapContext.getAttributes(jndiName);
                Attribute member = attrs.get(typeConfig.getChildMembershipAttributeName());
                if (member != null) {
                    NamingEnumeration<?> memberValues = member.getAll();
                    while (memberValues.hasMoreElements()) {
                        String memberRef = memberValues.nextElement().toString();
                        if (typeConfig.isChildMembershipAttributeDN()) {
                            if (criteria != null && criteria.getFilter() != null) {
                                String name = Tools.stripDnToName((String)memberRef);
                                String regex = Tools.wildcardToRegex((String)criteria.getFilter());
                                if (!Pattern.matches(regex, name)) continue;
                                objects.add(this.findIdentityObject(ctx, memberRef));
                                continue;
                            }
                            objects.add(this.findIdentityObject(ctx, memberRef));
                            continue;
                        }
                        throw new NotYetImplementedException("LDAP limitation. If relationship targets are not refered with FQDNs and only names, it's not possible to map them to proper IdentityType and keep name uniqnes per type. Workaround needed");
                    }
                }
            }
        }
        catch (NamingException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("Failed to resolve relationship", (Throwable)e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Exception occurred: ", e);
                }
                throw new IdentityException("Failed to close LDAP connection", (Throwable)e);
            }
        }
        if (criteria != null && criteria.isPaged()) {
            objects = this.cutPageFromResults(objects, criteria);
        }
        if (criteria != null && criteria.isSorted()) {
            this.sortByName(objects, criteria.isAscending());
        }
        if (log.isLoggable(Level.FINER)) {
            Tools.logMethodOut((Logger)log, (Level)Level.FINER, (String)"findIdentityObject", objects);
        }
        return objects;
    }

    private LdapContext getLDAPContext(IdentityStoreInvocationContext ctx) throws IdentityException {
        LdapContext ldapContext = null;
        try {
            ldapContext = (LdapContext)ctx.getIdentityStoreSession().getSessionContext();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Failed to obtain LDAP connection!");
            }
            throw new IdentityException("Could not obtain LDAP connection: ", (Throwable)e);
        }
        if (ldapContext == null) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Failed to obtain LDAP connection!");
            }
            throw new IdentityException("IllegalState: - Could not obtain LDAP connection");
        }
        return ldapContext;
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObjectType type, IdentityObjectSearchCriteria criteria) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            Tools.logMethodIn((Logger)log, (Level)Level.FINER, (String)"findIdentityObject", (Object[])new Object[]{"IdentityObjectType", type, "IdentityObjectSearchCriteria", criteria});
        }
        String nameFilter = "*";
        if (criteria != null && criteria.getFilter() != null) {
            nameFilter = criteria.getFilter();
        }
        this.checkIOType(type);
        LinkedList objects = new LinkedList();
        LDAPIdentityObjectTypeConfiguration typeConfiguration = this.getTypeConfiguration(invocationCtx, type);
        try {
            Control[] requestControls = null;
            if (criteria != null && criteria.isSorted() && this.configuration.isSortExtensionSupported()) {
                requestControls = new Control[]{new SortControl(typeConfiguration.getIdAttributeName(), true)};
            }
            StringBuilder af = new StringBuilder();
            if (criteria != null && criteria.isFiltered()) {
                af.append("(&");
                for (Map.Entry stringEntry : criteria.getValues().entrySet()) {
                    if (MODIFICATION_DATE_SINCE.equals(stringEntry.getKey())) {
                        if (stringEntry.getValue() == null || ((String[])stringEntry.getValue()).length != 1) continue;
                        String string = ((String[])stringEntry.getValue())[0];
                        af.append("(|").append("(createTimestamp>=").append(string).append("Z)").append("(modifyTimestamp>=").append(string).append("Z)").append("(whenCreated>=").append(string).append(".0Z)").append("(whenChanged>=").append(string).append(".0Z)").append(")");
                        continue;
                    }
                    for (String value : (String[])stringEntry.getValue()) {
                        String attributeName = this.getTypeConfiguration(invocationCtx, type).getAttributeMapping((String)stringEntry.getKey());
                        if (attributeName == null) {
                            attributeName = (String)stringEntry.getKey();
                        }
                        af.append("(").append(attributeName).append("=").append(value).append(")");
                    }
                }
                af.append(")");
            }
            String filter = this.getTypeConfiguration(invocationCtx, type).getEntrySearchFilter();
            List<SerializableSearchResult> sr = null;
            String[] stringArray = this.getTypeConfiguration(invocationCtx, type).getCtxDNs();
            String scope = this.getTypeConfiguration(invocationCtx, type).getEntrySearchScope();
            if (filter != null && filter.length() > 0) {
                filter = filter.replaceAll("\\{0\\}", nameFilter);
                sr = this.searchIdentityObjects(invocationCtx, stringArray, "(&(" + filter + ")" + af.toString() + ")", null, new String[]{typeConfiguration.getIdAttributeName()}, scope, requestControls);
            } else {
                filter = "(".concat(typeConfiguration.getIdAttributeName()).concat("=").concat(nameFilter).concat(")");
                sr = this.searchIdentityObjects(invocationCtx, stringArray, "(&(" + filter + ")" + af.toString() + ")", null, new String[]{typeConfiguration.getIdAttributeName()}, scope, requestControls);
            }
            for (SerializableSearchResult res : sr) {
                String dn = res.getNameInNamespace();
                if (criteria != null && criteria.isSorted() && this.configuration.isSortExtensionSupported()) {
                    if (!criteria.isAscending()) {
                        objects.addFirst(this.createIdentityObjectInstance(invocationCtx, type, res.getAttributes(), dn));
                        continue;
                    }
                    objects.addLast(this.createIdentityObjectInstance(invocationCtx, type, res.getAttributes(), dn));
                    continue;
                }
                objects.add(this.createIdentityObjectInstance(invocationCtx, type, res.getAttributes(), dn));
            }
        }
        catch (NoSuchElementException requestControls) {
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("IdentityObject search failed.", (Throwable)e);
        }
        if (criteria != null && criteria.isSorted() && !this.configuration.isSortExtensionSupported()) {
            this.sortByName(objects, criteria.isAscending());
        }
        if (criteria != null && criteria.isPaged()) {
            objects = (LinkedList)this.cutPageFromResults(objects, criteria);
        }
        if (log.isLoggable(Level.FINER)) {
            Tools.logMethodOut((Logger)log, (Level)Level.FINER, (String)"findIdentityObject", (Object)objects);
        }
        return objects;
    }

    public List<SerializableSearchResult> searchIdentityObjects(IdentityStoreInvocationContext ctx, String[] entryCtxs, String filter, Object[] filterArgs, String[] returningAttributes, String searchScope, Control[] requestControls) throws NamingException, IdentityException {
        String[] sanitizedEntryCtxs = entryCtxs;
        if (entryCtxs != null && entryCtxs.length > 0) {
            sanitizedEntryCtxs = (String[])Arrays.stream(entryCtxs).filter(StringUtils::isNotBlank).toArray(String[]::new);
        }
        return super.searchIdentityObjects(ctx, sanitizedEntryCtxs, filter, filterArgs, returningAttributes, searchScope, requestControls);
    }

    private void checkIOType(IdentityObjectType iot) throws IdentityException {
        if (iot == null) {
            throw new IllegalArgumentException("IdentityObjectType is null");
        }
        if (!this.getSupportedFeatures().isIdentityObjectTypeSupported(iot)) {
            throw new IdentityException("IdentityType not supported by this IdentityStore implementation: " + iot);
        }
    }

    private LDAPIdentityObjectTypeConfiguration getTypeConfiguration(IdentityStoreInvocationContext ctx, IdentityObjectType type) throws IdentityException {
        return this.getConfiguration(ctx).getTypeConfiguration(type.getName());
    }

    private LDAPIdentityStoreConfiguration getConfiguration(IdentityStoreInvocationContext ctx) throws IdentityException {
        return this.configuration;
    }

    private void sortByName(List<IdentityObject> objects, final boolean ascending) {
        Collections.sort(objects, new Comparator<IdentityObject>(){

            @Override
            public int compare(IdentityObject o1, IdentityObject o2) {
                if (ascending) {
                    return o1.getName().compareTo(o2.getName());
                }
                return o2.getName().compareTo(o1.getName());
            }
        });
    }

    private <T> List<T> cutPageFromResults(List<T> objects, IdentityObjectSearchCriteria criteria) {
        LinkedList<T> results = new LinkedList<T>();
        if (criteria.getMaxResults() == 0) {
            for (int i = criteria.getFirstResult(); i < objects.size(); ++i) {
                if (i >= objects.size()) continue;
                results.add(objects.get(i));
            }
        } else {
            for (int i = criteria.getFirstResult(); i < criteria.getFirstResult() + criteria.getMaxResults(); ++i) {
                if (i >= objects.size()) continue;
                results.add(objects.get(i));
            }
        }
        return results;
    }

    private LDAPIdentityObjectImpl getSafeLDAPIO(IdentityStoreInvocationContext ctx, IdentityObject io) throws IdentityException {
        if (io == null) {
            throw new IllegalArgumentException("IdentityObject is null");
        }
        if (io instanceof LDAPIdentityObjectImpl) {
            return (LDAPIdentityObjectImpl)io;
        }
        try {
            return (LDAPIdentityObjectImpl)this.findIdentityObject(ctx, io.getName(), io.getIdentityType());
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Failed to find IdentityObject in LDAP: " + io);
            }
            throw new IdentityException("Provided IdentityObject is not present in the store. Cannot operate on not stored objects.", (Throwable)e);
        }
    }
}

