/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.ArrayList;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.page.PageTemplateService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIDropDownControl;
import org.exoplatform.webui.core.model.SelectItemCategory;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInputItemSelector;

@ComponentConfig(template="system:/groovy/portal/webui/page/UIPageTemplateOptions.gtmpl")
public class UIPageTemplateOptions
extends UIFormInputItemSelector<String> {
    private SelectItemOption<String> selectedItemOption_ = null;

    public UIPageTemplateOptions() throws Exception {
        super("UIPageTemplateOptions", null, String.class);
        PageTemplateService pageTemplateService = (PageTemplateService)this.getApplicationComponent(PageTemplateService.class);
        this.categories_ = pageTemplateService.getPageTemplateCategories();
        this.selectedItemOption_ = this.getDefaultItemOption();
        ArrayList<SelectItemOption> itemOptions = new ArrayList<SelectItemOption>();
        for (SelectItemCategory itemCategory : this.categories_) {
            itemOptions.add(new SelectItemOption((Object)itemCategory.getName()));
        }
        UIDropDownControl uiItemSelector = (UIDropDownControl)this.addChild(UIDropDownControl.class, null, "UIDropDownPageTemp");
        uiItemSelector.setOptions(itemOptions);
        uiItemSelector.setAction("eXo.webui.UIPageTemplateOptions.selectPageLayout");
    }

    public SelectItemOption<String> getDefaultItemOption() {
        SelectItemCategory category = this.getSelectedCategory();
        if (category == null) {
            return null;
        }
        SelectItemOption itemOption = category.getSelectedItemOption();
        if (itemOption == null) {
            return null;
        }
        return itemOption;
    }

    public void setSelectOptionItem(String value) {
        boolean found = false;
        for (SelectItemCategory category : this.categories_) {
            category.setSelected(false);
            if (found) continue;
            for (SelectItemOption itemOption : category.getSelectItemOptions()) {
                if (!itemOption.getLabel().equals(value)) continue;
                UIDropDownControl uiItemSelector = (UIDropDownControl)this.findFirstComponentOfType(UIDropDownControl.class);
                uiItemSelector.setValue(category.getName());
                category.setSelected(true);
                this.selectedItemOption_ = itemOption;
                for (SelectItemOption item : category.getSelectItemOptions()) {
                    item.setSelected(false);
                }
                itemOption.setSelected(true);
                found = true;
            }
        }
        if (!found) {
            this.selectedItemOption_ = null;
        }
    }

    public SelectItemOption<String> getSelectedItemOption() {
        return this.selectedItemOption_;
    }

    public void decode(Object input, WebuiRequestContext context) {
        if (input == null || String.valueOf(input).length() < 1) {
            return;
        }
        this.setSelectOptionItem((String)input);
    }

    public Page createPageFromSelectedOption(String ownerType, String ownerId) throws Exception {
        if (this.selectedItemOption_ == null) {
            this.selectedItemOption_ = this.getDefaultItemOption();
        }
        if (this.selectedItemOption_ == null) {
            return null;
        }
        Object temp = this.selectedItemOption_.getValue();
        if (temp == null) {
            return null;
        }
        UserPortalConfigService configService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        return configService.createPageTemplate(temp.toString(), ownerType, ownerId);
    }
}

