/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.util;

import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.MimeResponse;
import javax.portlet.ResourceURL;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.mop.user.UserPortalImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.webui.application.WebuiRequestContext;

public class NavigationUtils {
    public static final Scope ECMS_NAVIGATION_SCOPE;
    private static ThreadLocal<Map<String, String>> gotNavigationKeeper;
    private static Constructor<UserNavigation> userNavigationCtor;
    private static final Log LOG;

    public static boolean gotNavigation(String portal, String user) {
        return NavigationUtils.gotNavigation(portal, user, "");
    }

    public static boolean gotNavigation(String portal, String user, String scope) {
        Map<String, String> navigations = gotNavigationKeeper.get();
        if (navigations == null) {
            return false;
        }
        String navigation = navigations.get(portal + " " + user + " " + scope);
        return navigation != null;
    }

    public static UserNavigation getUserNavigationOfPortal(UserPortal userPortal, String portalName) throws Exception {
        UserACL userACL = (UserACL)ExoContainerContext.getService(UserACL.class);
        UserPortalConfigService userPortalConfigService = (UserPortalConfigService)ExoContainerContext.getService(UserPortalConfigService.class);
        NavigationContext portalNav = userPortalConfigService.getNavigationService().loadNavigation(new SiteKey(SiteType.PORTAL, portalName));
        if (portalNav == null) {
            return null;
        }
        UserPortalConfig userPortalCfg = userPortalConfigService.getUserPortalConfig(portalName, ConversationState.getCurrent().getIdentity().getUserId(), PortalRequestContext.USER_PORTAL_CONTEXT);
        return userNavigationCtor.newInstance(userPortal, portalNav, userACL.hasEditPermission(userPortalCfg.getPortalConfig()));
    }

    public static UserNavigation getUserNavigation(UserPortal userPortal, SiteKey siteKey) throws Exception {
        if (siteKey.getTypeName().equalsIgnoreCase(SiteType.PORTAL.getName())) {
            return NavigationUtils.getUserNavigationOfPortal(userPortal, siteKey.getName());
        }
        UserACL userACL = (UserACL)ExoContainerContext.getService(UserACL.class);
        UserPortalConfigService userPortalConfigService = (UserPortalConfigService)ExoContainerContext.getService(UserPortalConfigService.class);
        NavigationContext portalNav = userPortalConfigService.getNavigationService().loadNavigation(siteKey);
        if (portalNav == null) {
            return null;
        }
        return userNavigationCtor.newInstance(userPortal, portalNav, userACL.hasEditPermissionOnNavigation(siteKey));
    }

    public static void removeNavigationAsJson(String portalName, String username) throws Exception {
        for (String scope : new String[]{"single", "children", "grandchildren", "all"}) {
            NavigationUtils.removeNavigationAsJson(portalName, username, scope);
        }
    }

    public static void removeNavigationAsJson(String portalName, String username, String scope) throws Exception {
        String key = portalName + " " + username + " " + scope;
        Map<String, String> navigations = gotNavigationKeeper.get();
        if (navigations != null) {
            navigations.remove(key);
            gotNavigationKeeper.set(navigations);
        }
    }

    public static String getNavigationAsJSON(String portalName, String username) throws Exception {
        return NavigationUtils.getNavigationAsJSON(portalName, username, null, "");
    }

    public static String getNavigationAsJSON(String portalName, String username, Scope scope, String navigationScope) throws Exception {
        String key = portalName + " " + username + " " + navigationScope;
        Map<String, String> navigations = gotNavigationKeeper.get();
        if (navigations == null) {
            navigations = new Hashtable<String, String>();
        } else {
            String navigationData = navigations.get(key);
            if (navigationData != null) {
                return navigationData;
            }
        }
        UserPortalConfigService userPortalConfigService = (UserPortalConfigService)ExoContainerContext.getService(UserPortalConfigService.class);
        UserPortalConfig userPortalCfg = userPortalConfigService.getUserPortalConfig(portalName, username, PortalRequestContext.USER_PORTAL_CONTEXT);
        UserPortal userPortal = userPortalCfg.getUserPortal();
        UserNodeFilterConfig.Builder filterConfigBuilder = UserNodeFilterConfig.builder();
        filterConfigBuilder.withReadWriteCheck().withVisibility(Visibility.DISPLAYED, new Visibility[]{Visibility.TEMPORAL});
        filterConfigBuilder.withTemporalCheck();
        UserNodeFilterConfig filterConfig = filterConfigBuilder.build();
        UserNavigation navigation = NavigationUtils.getUserNavigationOfPortal(userPortal, portalName);
        UserNode root = userPortal.getNode(navigation, scope == null ? ECMS_NAVIGATION_SCOPE : scope, filterConfig, null);
        String ret = NavigationUtils.createJsonTree(navigation, root);
        navigations.put(key, ret);
        gotNavigationKeeper.set(navigations);
        return ret;
    }

    private static String createJsonTree(UserNavigation navigation, UserNode rootNode) throws Exception {
        StringBuffer sbJsonTree = new StringBuffer();
        sbJsonTree.append("[");
        sbJsonTree.append("{");
        sbJsonTree.append("\"ownerId\":\"").append(navigation.getKey().getName()).append("\",");
        sbJsonTree.append("\"ownerType\":\"").append(navigation.getKey().getTypeName()).append("\",");
        sbJsonTree.append("\"priority\":\"").append(navigation.getPriority()).append("\",");
        sbJsonTree.append("\"nodes\":").append(NavigationUtils.addJsonNodes(rootNode.getChildren().iterator()));
        sbJsonTree.append("}");
        sbJsonTree.append("]");
        return sbJsonTree.toString();
    }

    private static StringBuffer addJsonNodes(Iterator<UserNode> children) throws Exception {
        StringBuffer sbJsonTree = new StringBuffer();
        sbJsonTree.append("[");
        boolean first = true;
        while (children.hasNext()) {
            UserNode child = children.next();
            if (!first) {
                sbJsonTree.append(",");
            }
            first = false;
            sbJsonTree.append("{");
            sbJsonTree.append("\"icon\":").append((String)(child.getIcon() != null ? "\"" + child.getIcon() + "\"" : "null")).append(",");
            sbJsonTree.append("\"label\":\"").append(child.getLabel()).append("\",");
            sbJsonTree.append("\"name\":\"").append(child.getName()).append("\",");
            sbJsonTree.append("\"resolvedLabel\":\"").append(child.getResolvedLabel()).append("\",");
            String childURI = "";
            if (child.getPageRef() != null) {
                childURI = child.getURI();
            }
            sbJsonTree.append("\"uri\":\"").append(childURI).append("\",");
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            MimeResponse res = (MimeResponse)context.getResponse();
            ResourceURL resourceURL = res.createResourceURL();
            resourceURL.setResourceID(res.encodeURL(child.getURI()));
            StringWriter w = new StringWriter();
            resourceURL.write((Writer)w, true);
            sbJsonTree.append("\"getNodeURL\":\"").append(((Object)w).toString()).append("\",");
            sbJsonTree.append("\"nodes\":").append(NavigationUtils.addJsonNodes(child.getChildren().iterator()));
            sbJsonTree.append("}");
        }
        sbJsonTree.append("]");
        return sbJsonTree;
    }

    static {
        block2: {
            ECMS_NAVIGATION_SCOPE = Scope.CHILDREN;
            gotNavigationKeeper = new ThreadLocal();
            userNavigationCtor = null;
            LOG = ExoLogger.getLogger((String)NavigationUtils.class.getName());
            try {
                userNavigationCtor = UserNavigation.class.getDeclaredConstructor(UserPortalImpl.class, NavigationContext.class, Boolean.TYPE);
                userNavigationCtor.setAccessible(true);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e);
            }
        }
    }
}

