/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.portal.artifacts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.exoplatform.services.context.DocumentContext;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.wcm.portal.artifacts.CreatePortalArtifactsService;
import org.exoplatform.services.wcm.portal.artifacts.CreatePortalPlugin;
import org.exoplatform.services.wcm.portal.artifacts.IgnorePortalPlugin;

public class CreatePortalArtifactsServiceImpl
implements CreatePortalArtifactsService {
    public static final String CREATE_PORTAL_EVENT = "PortalArtifactsInitializerServiceImpl.portal.onCreate";
    private HashMap<String, CreatePortalPlugin> artifactPlugins = new LinkedHashMap<String, CreatePortalPlugin>();
    private List<String> initialPortals = new ArrayList<String>();
    private ListenerService listenerService;

    public CreatePortalArtifactsServiceImpl(ListenerService listenerService) {
        this.listenerService = listenerService;
    }

    @Override
    public void addPlugin(CreatePortalPlugin artifactsPlugin) throws Exception {
        this.artifactPlugins.put(artifactsPlugin.getName(), artifactsPlugin);
    }

    public void addIgnorePortalPlugin(IgnorePortalPlugin ignorePortalPlugin) throws Exception {
        List<String> ignoredPortals = ignorePortalPlugin.getIgnorePortals();
        if (ignoredPortals != null && !ignoredPortals.isEmpty()) {
            this.initialPortals.addAll(ignoredPortals);
        }
    }

    @Override
    public void deployArtifactsToPortal(SessionProvider sessionProvider, String portalName, String portalTemplateName) throws Exception {
        if (this.initialPortals.contains(portalName)) {
            return;
        }
        DocumentContext.getCurrent().getAttributes().put("isSkipRaiseActivity", true);
        for (CreatePortalPlugin plugin : this.artifactPlugins.values()) {
            if (portalTemplateName == null || !plugin.getName().startsWith(portalTemplateName)) continue;
            plugin.deployToPortal(sessionProvider, portalName);
        }
        for (CreatePortalPlugin plugin : this.artifactPlugins.values()) {
            if (plugin.getName().startsWith("template")) continue;
            plugin.deployToPortal(sessionProvider, portalName);
        }
        this.listenerService.broadcast(CREATE_PORTAL_EVENT, (Object)portalName, (Object)sessionProvider);
    }

    @Override
    public HashMap<String, CreatePortalPlugin> getArtifactPlugins() {
        return this.artifactPlugins;
    }
}

