/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.xmlprocessor.filters;

import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.social.common.xmlprocessor.BaseXMLFilterPlugin;
import org.exoplatform.social.common.xmlprocessor.DOMParser;
import org.exoplatform.social.common.xmlprocessor.Tokenizer;
import org.exoplatform.social.common.xmlprocessor.model.Node;

public class OpenLinkNewTabFilterPlugin
extends BaseXMLFilterPlugin {
    public static final String TARGET = "target";

    @Override
    public Object doFilter(Object input) {
        if (input instanceof String) {
            return this.filterLinkTags((String)input);
        }
        return input;
    }

    private String filterLinkTags(String xmlString) {
        List<String> xmlTokens = Tokenizer.tokenize(xmlString);
        Node rootNode = DOMParser.createDOMTree(xmlTokens);
        this.nodeFilter(rootNode);
        return rootNode.toString();
    }

    private void nodeFilter(Node currentNode) {
        if ("a".equalsIgnoreCase(currentNode.getTitle())) {
            String currentDomain = CommonsUtils.getCurrentDomain();
            String target = currentNode.getAttributes().get(TARGET);
            if (target != null && currentNode.getAttributes().get("href").indexOf(currentDomain) == -1) {
                currentNode.getAttributes().put(TARGET, "_blank");
            } else {
                currentNode.getAttributes().put(TARGET, "_self");
            }
            return;
        }
        LinkedList<Node> currentChildNode = currentNode.getChildNodes();
        for (int i = 0; i < currentChildNode.size(); ++i) {
            this.nodeFilter(currentChildNode.get(i));
        }
    }
}

