/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.form.field;

import java.util.Collection;
import org.exoplatform.ecm.webui.form.DialogFormField;
import org.exoplatform.ecm.webui.form.UIFormRichtextInput;
import org.exoplatform.ecm.webui.utils.DialogFormUtil;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.form.UIFormInputBase;

public class UIFormRichtextField
extends DialogFormField {
    private final String TOOLBAR = "toolbar";
    private final String WIDTH = "width";
    private final String HEIGHT = "height";
    private final String ENTERMODE = "enterMode";
    private final String SHIFT_ENTER_MODE = "shiftEnterMode";
    private String toolbar;
    private String width;
    private String height;
    private String enterMode;
    private String shiftEnterMode;

    public UIFormRichtextField(String name, String label, String[] arguments) {
        super(name, label, arguments);
    }

    @Override
    public <T extends UIFormInputBase> T createUIFormInput() throws Exception {
        UIFormRichtextInput richtext = new UIFormRichtextInput(this.name, this.name, this.defaultValue);
        this.setPredefineOptions();
        richtext.setToolbar(this.toolbar);
        richtext.setWidth(this.width);
        richtext.setHeight(this.height);
        richtext.setEnterMode(this.enterMode);
        richtext.setShiftEnterMode(this.shiftEnterMode);
        richtext.setIgnoreParserHTML(true);
        StringBuffer contentsCss = new StringBuffer();
        contentsCss.append("[");
        SkinService skinService = (SkinService)WCMCoreUtils.getService(SkinService.class);
        String skin = Util.getUIPortalApplication().getUserPortalConfig().getPortalConfig().getSkin();
        String portal = Util.getUIPortal().getName();
        Collection portalSkins = skinService.getPortalSkins(skin);
        SkinConfig customSkin = skinService.getSkin(portal, Util.getUIPortalApplication().getUserPortalConfig().getPortalConfig().getSkin());
        if (customSkin != null) {
            portalSkins.add(customSkin);
        }
        for (SkinConfig portalSkin : portalSkins) {
            contentsCss.append("'").append(portalSkin.createURL(Util.getPortalRequestContext().getControllerContext())).append("',");
        }
        contentsCss.append("'/commons-extension/ckeditor/contents.css'");
        contentsCss.append("]");
        richtext.setCss(contentsCss.toString());
        if (this.validateType != null) {
            DialogFormUtil.addValidators(richtext, this.validateType);
        }
        return (T)((Object)richtext);
    }

    private void setPredefineOptions() {
        if (this.options == null) {
            return;
        }
        for (String option : this.options.split(",")) {
            String[] entry = option.split(":");
            if ("toolbar".equals(entry[0])) {
                this.toolbar = entry[1];
                continue;
            }
            if ("width".equals(entry[0])) {
                this.width = entry[1];
                continue;
            }
            if ("height".equals(entry[0])) {
                this.height = entry[1];
                continue;
            }
            if ("enterMode".equals(entry[0])) {
                this.enterMode = entry[1];
                continue;
            }
            if (!"shiftEnterMode".equals(entry[0])) continue;
            this.shiftEnterMode = entry[1];
        }
    }
}

