/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.IOException;
import net.jcip.annotations.Immutable;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public class Grib2SectionIdentification {
    private final int center_id;
    private final int subcenter_id;
    private final int master_table_version;
    private final int local_table_version;
    private final int significanceOfRT;
    private final int year;
    private final int month;
    private final int day;
    private final int hour;
    private final int minute;
    private final int second;
    private final int productionStatus;
    private final int processedDataType;

    public Grib2SectionIdentification(RandomAccessFile raf) throws IOException {
        long sectionEnd = raf.getFilePointer();
        int length = GribNumbers.int4(raf);
        sectionEnd += (long)length;
        int section = raf.read();
        if (section != 1) {
            throw new IllegalArgumentException("Not a GRIB-2 Identification section");
        }
        this.center_id = GribNumbers.int2(raf);
        this.subcenter_id = GribNumbers.int2(raf);
        this.master_table_version = raf.read();
        this.local_table_version = raf.read();
        this.significanceOfRT = raf.read();
        this.year = GribNumbers.int2(raf);
        this.month = raf.read();
        this.day = raf.read();
        this.hour = raf.read();
        this.minute = raf.read();
        this.second = raf.read();
        this.productionStatus = raf.read();
        this.processedDataType = raf.read();
        raf.seek(sectionEnd);
    }

    public Grib2SectionIdentification(int center_id, int subcenter_id, int master_table_version, int local_table_version, int significanceOfRT, int year, int month, int day, int hour, int minute, int second, int productionStatus, int processedDataType) {
        this.center_id = center_id;
        this.subcenter_id = subcenter_id;
        this.master_table_version = master_table_version;
        this.local_table_version = local_table_version;
        this.significanceOfRT = significanceOfRT;
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.productionStatus = productionStatus;
        this.processedDataType = processedDataType;
    }

    public int getCenter_id() {
        return this.center_id;
    }

    public int getSubcenter_id() {
        return this.subcenter_id;
    }

    public int getMaster_table_version() {
        return this.master_table_version;
    }

    public int getLocal_table_version() {
        return this.local_table_version;
    }

    public boolean useLocalTablesOnly() {
        return this.master_table_version == 255 && this.local_table_version != 0;
    }

    public int getSignificanceOfRT() {
        return this.significanceOfRT;
    }

    public CalendarDate getReferenceDate() {
        return CalendarDate.of(null, (int)this.year, (int)this.month, (int)this.day, (int)this.hour, (int)this.minute, (int)this.second);
    }

    public int getProductionStatus() {
        return this.productionStatus;
    }

    public int getTypeOfProcessedData() {
        return this.processedDataType;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public String toString() {
        return "id {center_id=" + this.center_id + ", subcenter_id=" + this.subcenter_id + ", master_table_version=" + this.master_table_version + ", local_table_version=" + this.local_table_version + '}';
    }
}

