/*
 * Decompiled with CFR 0.152.
 */
package juzu.request;

import java.util.Map;
import java.util.concurrent.Executor;
import juzu.PropertyType;
import juzu.Response;
import juzu.impl.bridge.spi.RequestBridge;
import juzu.impl.request.ControllerHandler;
import juzu.impl.request.Request;
import juzu.request.ApplicationContext;
import juzu.request.ClientContext;
import juzu.request.Dispatch;
import juzu.request.HttpContext;
import juzu.request.Phase;
import juzu.request.RequestParameter;
import juzu.request.SecurityContext;
import juzu.request.UserContext;

public class RequestContext {
    private static final Object[] EMPTY = new Object[0];
    protected final ControllerHandler handler;
    protected final Request request;
    protected Response response;

    public RequestContext(Request request, ControllerHandler handler) {
        this.request = request;
        this.handler = handler;
    }

    public ControllerHandler getHandler() {
        return this.handler;
    }

    public Map<String, RequestParameter> getParameters() {
        return this.request.getParameterArguments();
    }

    public ClientContext getClientContext() {
        return this.getBridge().getClientContext();
    }

    public HttpContext getHttpContext() {
        return this.getBridge().getHttpContext();
    }

    public SecurityContext getSecurityContext() {
        return this.getBridge().getSecurityContext();
    }

    public UserContext getUserContext() {
        return this.getBridge().getUserContext();
    }

    public ApplicationContext getApplicationContext() {
        return this.getBridge().getApplicationContext();
    }

    public <T> T getProperty(PropertyType<T> propertyType) {
        return this.getBridge().getProperty(propertyType);
    }

    public final Executor getExecutor() {
        return this.request.getExecutor();
    }

    public final Phase getPhase() {
        return this.getBridge().getPhase();
    }

    final RequestBridge getBridge() {
        return this.request.getBridge();
    }

    public Dispatch createDispatch(ControllerHandler<?> handler) {
        return this.request.createDispatch(handler);
    }

    public Phase.Action.Dispatch createActionDispatch(ControllerHandler<Phase.Action> handler) {
        return (Phase.Action.Dispatch)this.request.createDispatch(handler, EMPTY);
    }

    public Phase.Action.Dispatch createActionDispatch(ControllerHandler<Phase.Action> handler, Object arg) {
        return (Phase.Action.Dispatch)this.request.createDispatch(handler, new Object[]{arg});
    }

    public Phase.Action.Dispatch createActionDispatch(ControllerHandler<Phase.Action> handler, Object[] args) {
        return (Phase.Action.Dispatch)this.request.createDispatch(handler, args);
    }

    public Phase.View.Dispatch createViewDispatch(ControllerHandler<Phase.View> handler) {
        return (Phase.View.Dispatch)this.request.createDispatch(handler, EMPTY);
    }

    public Phase.View.Dispatch createViewDispatch(ControllerHandler<Phase.View> handler, Object arg) {
        return (Phase.View.Dispatch)this.request.createDispatch(handler, new Object[]{arg});
    }

    public Phase.View.Dispatch createViewDispatch(ControllerHandler<Phase.View> handler, Object[] args) {
        return (Phase.View.Dispatch)this.request.createDispatch(handler, args);
    }

    public Phase.Resource.Dispatch createResourceDispatch(ControllerHandler<Phase.Resource> handler) {
        return (Phase.Resource.Dispatch)this.request.createDispatch(handler, EMPTY);
    }

    public Phase.Resource.Dispatch createResourceDispatch(ControllerHandler<Phase.Resource> handler, Object arg) {
        return (Phase.Resource.Dispatch)this.request.createDispatch(handler, new Object[]{arg});
    }

    public Phase.Resource.Dispatch createResourceDispatch(ControllerHandler<Phase.Resource> handler, Object[] args) {
        return (Phase.Resource.Dispatch)this.request.createDispatch(handler, args);
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }
}

