/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.listener;

import org.exoplatform.news.model.News;
import org.exoplatform.news.service.NewsService;
import org.exoplatform.news.utils.NewsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class NewsActivityListener
extends ActivityListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(NewsActivityListener.class);
    private static final String NEWS_ID = "newsId";
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private NewsService newsService;

    public NewsActivityListener(ActivityManager activityManager, IdentityManager identityManager, SpaceService spaceService, NewsService newsService) {
        this.newsService = newsService;
        this.spaceService = spaceService;
        this.identityManager = identityManager;
        this.activityManager = activityManager;
    }

    public void shareActivity(ActivityLifeCycleEvent event) {
        String originalActivityId;
        ExoSocialActivity originalActivity;
        ExoSocialActivity sharedActivity = event.getActivity();
        if (sharedActivity != null && sharedActivity.getTemplateParams() != null && sharedActivity.getTemplateParams().containsKey("originalActivityId") && (originalActivity = this.activityManager.getActivity(originalActivityId = (String)sharedActivity.getTemplateParams().get("originalActivityId"))) != null && originalActivity.getTemplateParams() != null && originalActivity.getTemplateParams().containsKey(NEWS_ID)) {
            String newsId = (String)originalActivity.getTemplateParams().get(NEWS_ID);
            org.exoplatform.services.security.Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            try {
                News news = this.newsService.getNewsById(newsId, currentIdentity, false);
                if (news != null) {
                    Identity posterIdentity = this.getIdentity(sharedActivity);
                    Space space = this.getSpace(sharedActivity);
                    this.newsService.shareNews(news, space, posterIdentity, sharedActivity.getId());
                }
            }
            catch (Exception e) {
                LOG.error("Error while sharing news {} to activity {}", new Object[]{newsId, sharedActivity.getId(), e});
            }
        }
    }

    public void likeActivity(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = this.activityManager.getActivity(event.getActivity().getId());
        if (activity != null && activity.getTemplateParams() != null && activity.getTemplateParams().containsKey(NEWS_ID)) {
            org.exoplatform.services.security.Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            try {
                News news = this.newsService.getNewsByActivityId(activity.getId(), currentIdentity);
                NewsUtils.broadcastEvent("exo.news.likeArticle", currentIdentity.getUserId(), news);
            }
            catch (Exception e) {
                LOG.error((Object)"Error broadcast like news event", (Throwable)e);
            }
        }
    }

    public void saveComment(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = this.activityManager.getActivity(event.getActivity().getParentId());
        if (activity != null && activity.getTemplateParams() != null && activity.getTemplateParams().containsKey(NEWS_ID)) {
            org.exoplatform.services.security.Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            try {
                News news = this.newsService.getNewsByActivityId(activity.getId(), currentIdentity);
                NewsUtils.broadcastEvent("exo.news.commentArticle", currentIdentity.getUserId(), news);
            }
            catch (Exception e) {
                LOG.error((Object)"Error broadcast comment news event", (Throwable)e);
            }
        }
    }

    private Identity getIdentity(ExoSocialActivity sharedActivity) {
        String posterIdentityId = sharedActivity.getPosterId();
        return this.identityManager.getIdentity(posterIdentityId);
    }

    private Space getSpace(ExoSocialActivity sharedActivity) {
        String spacePrettyName = sharedActivity.getActivityStream().getPrettyId();
        return this.spaceService.getSpaceByPrettyName(spacePrettyName);
    }
}

