/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.listener;

import javax.jcr.Node;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.news.model.News;
import org.exoplatform.news.service.NewsService;
import org.exoplatform.news.service.NewsTargetingService;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class NewsPublicationListener
extends Listener<CmsService, Node> {
    private NewsService newsService = (NewsService)WCMCoreUtils.getService(NewsService.class);
    private NewsTargetingService newsTargetingService = (NewsTargetingService)WCMCoreUtils.getService(NewsTargetingService.class);

    public void onEvent(Event<CmsService, Node> event) throws Exception {
        News news;
        Node targetNode;
        if ("PublicationService.event.postChangeState".equals(event.getEventName()) && (targetNode = (Node)event.getData()).isNodeType("exo:news") && targetNode.getProperty("publication:currentState").getString().equals("published") && StringUtils.isEmpty((CharSequence)(news = this.newsService.getNewsById(targetNode.getUUID(), false)).getActivities())) {
            news.setTargets(this.newsTargetingService.getTargetsByNewsId(news.getId()));
            this.newsService.postNews(news, news.getAuthor());
        }
    }
}

